/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DensityAnalystNative;
import com.supermap.analyst.spatialanalyst.DensityAnalystParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.NeighbourShape;
import com.supermap.analyst.spatialanalyst.NeighbourShapeAnnulus;
import com.supermap.analyst.spatialanalyst.NeighbourShapeCircle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeRectangle;
import com.supermap.analyst.spatialanalyst.NeighbourShapeWedge;
import com.supermap.analyst.spatialanalyst.NeighbourUnitType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandle;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class DensityAnalyst {
    private static License a;
    private static transient Vector b;

    private DensityAnalyst() {
    }

    public static DatasetGrid kernelDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        return DensityAnalyst.kernelDensity(parameter, sourceDataset, valueFieldName, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid kernelDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Recordset recordset = sourceDataset.getRecordset(false, CursorType.STATIC);
            DatasetGrid datasetGrid = DensityAnalyst.a(parameter, recordset, valueFieldName, targetDatasource, targetDatasetName);
            recordset.dispose();
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static DatasetGrid a(DensityAnalystParameter densityAnalystParameter, Recordset recordset, String string, Datasource datasource, String string2) {
        String string3;
        DensityAnalyst.a();
        if (recordset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset) == 0L) {
            String string4 = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (string != null && !string.isEmpty()) {
            if (recordset.getFieldInfos().indexOf(string) == -1) {
                String string5 = InternalResourceSpatialanalyst.loadString("valueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            string3 = recordset.getFieldInfos().get(string);
            if (string3 == null || string3.getType() != FieldType.DOUBLE && string3.getType() != FieldType.INT16 && string3.getType() != FieldType.INT32 && string3.getType() != FieldType.INT64 && string3.getType() != FieldType.SINGLE) {
                String string6 = InternalResourceSpatialanalyst.loadString("valueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = densityAnalystParameter.getBounds().isEmpty();
        if (bl) {
            densityAnalystParameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = densityAnalystParameter.getResolution();
        if (Toolkit.isZero((double)densityAnalystParameter.getResolution()) || densityAnalystParameter.getResolution() < 0.0) {
            bl2 = true;
            double d2 = Math.min(densityAnalystParameter.getBounds().getHeight(), densityAnalystParameter.getBounds().getWidth());
            densityAnalystParameter.setResolution(d2 / 500.0);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)densityAnalystParameter);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        long l4 = DensityAnalystNative.jni_KernelDensity(l, l2, string, l3, string2);
        if (bl) {
            densityAnalystParameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            densityAnalystParameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)densityAnalystParameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetGrid;
    }

    public static DatasetGrid pointDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName) {
        return DensityAnalyst.pointDensity(parameter, sourceDataset, valueFieldName, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid pointDensity(DensityAnalystParameter parameter, DatasetVector sourceDataset, String valueFieldName, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Recordset recordset = sourceDataset.getRecordset(false, CursorType.STATIC);
            DatasetGrid datasetGrid = DensityAnalyst.b(parameter, recordset, valueFieldName, targetDatasource, targetDatasetName);
            recordset.dispose();
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static DatasetGrid b(DensityAnalystParameter densityAnalystParameter, Recordset recordset, String string, Datasource datasource, String string2) {
        String string3;
        DensityAnalyst.a();
        if (densityAnalystParameter == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)densityAnalystParameter) == 0L) {
            String string4 = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (densityAnalystParameter.getSearchNeighbourhood() == null) {
            String string5 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (recordset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset) == 0L) {
            String string6 = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string6);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (string != null && !string.isEmpty()) {
            if (recordset.getFieldInfos().indexOf(string) == -1) {
                String string7 = InternalResourceSpatialanalyst.loadString("valueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
            string3 = recordset.getFieldInfos().get(string);
            if (string3 == null || string3.getType() != FieldType.DOUBLE && string3.getType() != FieldType.INT16 && string3.getType() != FieldType.INT32 && string3.getType() != FieldType.INT64 && string3.getType() != FieldType.SINGLE) {
                String string8 = InternalResourceSpatialanalyst.loadString("valueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
        }
        if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            string3 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = densityAnalystParameter.getBounds().isEmpty();
        if (bl) {
            densityAnalystParameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = densityAnalystParameter.getResolution();
        double d2 = Math.min(densityAnalystParameter.getBounds().getHeight(), densityAnalystParameter.getBounds().getWidth());
        if (Toolkit.isZero((double)densityAnalystParameter.getResolution()) || densityAnalystParameter.getResolution() < 0.0) {
            bl2 = true;
            densityAnalystParameter.setResolution(d2 / 500.0);
        }
        int n = (int)(d2 / densityAnalystParameter.getResolution());
        int n2 = InternalEnum.getUGCValue(densityAnalystParameter.getSearchNeighbourhood().getShapeType());
        switch (n2) {
            case 1: {
                NeighbourShape neighbourShape = (NeighbourShapeRectangle)densityAnalystParameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeRectangle)neighbourShape).getHeight() > (double)(n / 2)) && !(((NeighbourShapeRectangle)neighbourShape).getWidth() > (double)(n / 2))) break;
                    String string9 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string9);
                }
                if (!(((NeighbourShapeRectangle)neighbourShape).getHeight() > d2 / 2.0) && !(((NeighbourShapeRectangle)neighbourShape).getWidth() > d2 / 2.0)) break;
                String string10 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string10);
            }
            case 2: {
                NeighbourShape neighbourShape = (NeighbourShapeCircle)densityAnalystParameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeCircle)neighbourShape).getRadius() > (double)(n / 2))) break;
                    String string11 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string11);
                }
                if (!(((NeighbourShapeCircle)neighbourShape).getRadius() > d2 / 2.0)) break;
                String string12 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string12);
            }
            case 3: {
                NeighbourShape neighbourShape = (NeighbourShapeAnnulus)densityAnalystParameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeAnnulus)neighbourShape).getInnerRadius() > (double)(n / 2)) && !(((NeighbourShapeAnnulus)neighbourShape).getOuterRadius() > (double)(n / 2))) break;
                    String string13 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string13);
                }
                if (!(((NeighbourShapeAnnulus)neighbourShape).getInnerRadius() > d2 / 2.0) && !(((NeighbourShapeAnnulus)neighbourShape).getOuterRadius() > d2 / 2.0)) break;
                String string14 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string14);
            }
            case 4: {
                NeighbourShape neighbourShape = (NeighbourShapeWedge)densityAnalystParameter.getSearchNeighbourhood();
                if (neighbourShape.getUnitType() == NeighbourUnitType.CELL) {
                    if (!(((NeighbourShapeWedge)neighbourShape).getRadius() > (double)(n / 2))) break;
                    String string15 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string15);
                }
                if (!(((NeighbourShapeWedge)neighbourShape).getRadius() > d2 / 2.0)) break;
                String string16 = InternalResourceSpatialanalyst.loadString("parameter.SearchNeighbourhood", "NeighbourhoodIsTooLarge", "spatialanalyst_resources");
                throw new IllegalArgumentException(string16);
            }
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)densityAnalystParameter);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        long l4 = DensityAnalystNative.jni_PointDensity(l, l2, string, l3, string2);
        if (bl) {
            densityAnalystParameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            densityAnalystParameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)densityAnalystParameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

