/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasource;
import com.supermap.data.HistoricalMoment;
import com.supermap.data.HistoricalMomentInfo;
import com.supermap.data.HistoricalchangedEvent;
import com.supermap.data.HistoricalchangedListener;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Version;
import com.supermap.data.VersionInfo;
import com.supermap.data.VersionManagerNative;
import com.supermap.data.VersionchangedEvent;
import com.supermap.data.VersionchangedListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class VersionManager
extends InternalHandleDisposable {
    protected Datasource m_datasource = null;
    private transient ReentrantLock c = new ReentrantLock();
    transient CopyOnWriteArrayList<VersionchangedListener> a;
    transient CopyOnWriteArrayList<HistoricalchangedListener> b;

    VersionManager(long handle, Datasource datasource) {
        this.setHandle(handle, true);
        this.m_datasource = datasource;
    }

    public Version getCurrentVersion() {
        this.checkValid();
        long l = VersionManagerNative.jni_GetCurrentVersion(this.getHandle());
        if (l != 0L) {
            Version version = new Version(l, this);
            return version;
        }
        return null;
    }

    public Version changeVersion(String strVersionName) {
        this.checkValid();
        long l = VersionManagerNative.jni_ChangeVersion(this.getHandle(), strVersionName);
        if (l > 0L) {
            this.clearCurrentHistoricalMoment();
            VersionchangedEvent versionchangedEvent = new VersionchangedEvent(this, this);
            this.fireChange(versionchangedEvent);
            return new Version(l, this);
        }
        return null;
    }

    public HistoricalMoment changeHistoricalMoment(String strHistoricalMomentName) {
        this.checkValid();
        long l = VersionManagerNative.jni_ChangeHistoricalMoment(this.getHandle(), strHistoricalMomentName);
        if (l > 0L) {
            HistoricalchangedEvent historicalchangedEvent = new HistoricalchangedEvent(this, this);
            this.fireHistoricalChange(historicalchangedEvent);
            return new HistoricalMoment(l);
        }
        return null;
    }

    public HistoricalMoment getCurrentHistoricalMoment() {
        this.checkValid();
        long l = VersionManagerNative.jni_GetCurrentHistoricalMoment(this.getHandle());
        if (l != 0L) {
            HistoricalMoment historicalMoment = new HistoricalMoment(l);
            return historicalMoment;
        }
        return null;
    }

    public boolean setHistoricalMoment(Date date) {
        this.checkValid();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        return VersionManagerNative.jni_SetHistoricalMoment(this.getHandle(), string);
    }

    public Date getHistoricalMoment() {
        this.checkValid();
        String string = VersionManagerNative.jni_GetHistoricalMoment2(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public boolean clearCurrentHistoricalMoment() {
        this.checkValid();
        return VersionManagerNative.jni_ClearCurrentHistoricalMoment(this.getHandle());
    }

    public Version createVersion(VersionInfo info) {
        this.checkValid();
        long l = VersionManagerNative.jni_CreateVersion(this.getHandle(), info.getName(), info.getDescription());
        if (l == 0L) {
            return null;
        }
        return new Version(l, this);
    }

    public boolean deleteVersion(String strName) {
        this.checkValid();
        return VersionManagerNative.jni_DeleteVersion(this.getHandle(), strName);
    }

    public boolean deleteHistoricalMoment(String strName) {
        this.checkValid();
        return VersionManagerNative.jni_DeleteHistoricalMoment(this.getHandle(), strName);
    }

    public Version getVersion(String strName) {
        this.checkValid();
        long l = VersionManagerNative.jni_GetVersion(this.getHandle(), strName);
        Version version = null;
        if (l != 0L) {
            version = new Version(l, this);
        }
        return version;
    }

    public Version[] getVersions() {
        this.checkValid();
        long[] lArray = VersionManagerNative.jni_GetVersions(this.getHandle());
        Version[] versionArray = new Version[lArray.length];
        for (int i = 0; i < versionArray.length; ++i) {
            versionArray[i] = lArray[i] != 0L ? new Version(lArray[i], this) : null;
        }
        return versionArray;
    }

    public String[] getVersionNames() {
        String[] stringArray = VersionManagerNative.jni_GetVersionNames(this.getHandle());
        return stringArray;
    }

    public HistoricalMoment createHistoricalMoment(HistoricalMomentInfo info) {
        long l;
        Object object;
        if (info.getVersion() == null) {
            return null;
        }
        if (info.getTime() != null) {
            object = new GregorianCalendar(Locale.getDefault());
            ((Calendar)object).setTime(info.getTime());
            int n = ((Calendar)object).get(1);
            int n2 = ((Calendar)object).get(2) + 1;
            int n3 = ((Calendar)object).get(5);
            int n4 = ((Calendar)object).get(11);
            int n5 = ((Calendar)object).get(12);
            int n6 = ((Calendar)object).get(13);
            String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
            l = VersionManagerNative.jni_CreateHistoricalMoment(this.getHandle(), info.getName(), string, info.getVersion().getHandle());
        } else {
            l = VersionManagerNative.jni_CreateHistoricalMoment2(this.getHandle(), info.getName(), info.getVersion().getHandle());
        }
        if (l == 0L) {
            return null;
        }
        object = new HistoricalMoment(l);
        return object;
    }

    public HistoricalMoment getHistoricalMoment(String name) {
        this.checkValid();
        long l = VersionManagerNative.jni_GetHistoricalMoment(this.getHandle(), name);
        if (l == 0L) {
            return null;
        }
        HistoricalMoment historicalMoment = new HistoricalMoment(l);
        return historicalMoment;
    }

    public HistoricalMoment[] getHistoricalMoment(Version version) {
        this.checkValid();
        long[] lArray = VersionManagerNative.jni_GetHistoricalMomentsByVersion(this.getHandle(), version.getHandle());
        if (lArray.length == 0) {
            return null;
        }
        HistoricalMoment[] historicalMomentArray = new HistoricalMoment[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            historicalMomentArray[i] = new HistoricalMoment(lArray[i]);
        }
        return historicalMomentArray;
    }

    public HistoricalMoment[] getHistoricalMoments(Date startTime, Date endTime) {
        this.checkValid();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(startTime);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        gregorianCalendar.setTime(endTime);
        n = gregorianCalendar.get(1);
        n2 = gregorianCalendar.get(2) + 1;
        n3 = gregorianCalendar.get(5);
        n4 = gregorianCalendar.get(11);
        n5 = gregorianCalendar.get(12);
        n6 = gregorianCalendar.get(13);
        String string2 = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        long[] lArray = VersionManagerNative.jni_GetHistoricalMomentsByTime(this.getHandle(), string, string2);
        if (lArray.length == 0) {
            return null;
        }
        HistoricalMoment[] historicalMomentArray = new HistoricalMoment[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            historicalMomentArray[i] = new HistoricalMoment(lArray[i]);
        }
        return historicalMomentArray;
    }

    public Duration getServerDifferenceTime() {
        this.checkValid();
        Duration duration = this.getCurrentVersion().getServerDifferenceTime();
        return duration;
    }

    public String[] getHistoricalMomentNames() {
        this.checkValid();
        return VersionManagerNative.jni_GetHistoricalMomentNames(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        this.m_datasource = null;
        this.setHandle(0L);
    }

    protected void checkValid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    protected void fireChange(VersionchangedEvent event) {
        if (this.a != null) {
            CopyOnWriteArrayList<VersionchangedListener> copyOnWriteArrayList = this.a;
            for (VersionchangedListener versionchangedListener : copyOnWriteArrayList) {
                versionchangedListener.versionchanged(event);
            }
        }
    }

    protected void fireHistoricalChange(HistoricalchangedEvent event) {
        if (this.b != null) {
            CopyOnWriteArrayList<HistoricalchangedListener> copyOnWriteArrayList = this.b;
            for (HistoricalchangedListener historicalchangedListener : copyOnWriteArrayList) {
                historicalchangedListener.Historicalchanged(event);
            }
        }
    }

    public void addVersionChangeListener(VersionchangedListener l) {
        this.c.lock();
        try {
            if (this.a == null) {
                this.a = new CopyOnWriteArrayList();
            }
            if (!this.a.contains(l)) {
                this.a.add(l);
            }
        }
        finally {
            this.c.unlock();
        }
    }

    public void addHistoricalChangeListener(HistoricalchangedListener l) {
        this.c.lock();
        try {
            if (this.b == null) {
                this.b = new CopyOnWriteArrayList();
            }
            if (!this.b.contains(l)) {
                this.b.add(l);
            }
        }
        finally {
            this.c.unlock();
        }
    }

    public void removeVersionChangeListener(VersionchangedListener l) {
        this.c.lock();
        try {
            if (this.a != null && this.a.contains(l)) {
                this.a.remove(l);
            }
        }
        finally {
            this.c.unlock();
        }
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            VersionManagerNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }
}

