/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SpatialTemporalItemInfo;
import com.supermap.data.SpatialTemporalObjectNative;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

public class SpatialTemporalObject
extends InternalHandleDisposable {
    public SpatialTemporalObject() {
        long l = SpatialTemporalObjectNative.jni_New();
        this.setHandle(l, true);
    }

    public SpatialTemporalObject(String name, String des, String extinfo) {
        long l = SpatialTemporalObjectNative.jni_New1(name, des, extinfo);
        this.setHandle(l, true);
    }

    public SpatialTemporalObject(SpatialTemporalObject object) {
        long l = SpatialTemporalObjectNative.jni_New();
        this.setHandle(l, true);
        this.setName(object.getName());
        this.setExtendInfo(object.getExtendInfo());
        this.setDescription(object.getDescription());
        for (int i = 0; i < this.getCount(); ++i) {
            SpatialTemporalItemInfo spatialTemporalItemInfo = this.getAllItemInfos()[i];
            this.AddItem(spatialTemporalItemInfo.getTime(), spatialTemporalItemInfo.getName(), spatialTemporalItemInfo.getItemKey(), spatialTemporalItemInfo.getSourceXML());
        }
    }

    protected SpatialTemporalObject(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, true);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = SpatialTemporalObjectNative.jni_GetName(this.getHandle());
        return string;
    }

    public void setName(String strName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialTemporalObjectNative.jni_SetName(this.getHandle(), strName);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = SpatialTemporalObjectNative.jni_GetDesCription(this.getHandle());
        return string;
    }

    public void setDescription(String strDes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialTemporalObjectNative.jni_SetDesCription(this.getHandle(), strDes);
    }

    public String getExtendInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = SpatialTemporalObjectNative.jni_GetExtInfo(this.getHandle());
        return string;
    }

    public void setExtendInfo(String strExtInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialTemporalObjectNative.jni_SetExtInfo(this.getHandle(), strExtInfo);
    }

    public int AddItem(SpatialTemporalItemInfo itemInfo) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(itemInfo.getTime());
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = SpatialTemporalObjectNative.jni_AddItem(this.getHandle(), n, n2, n3, n4, n5, n6, itemInfo.getName(), itemInfo.getItemKey(), itemInfo.getSourceXML());
        return n7;
    }

    public int AddItem(Date time, String Name, String ItemKey, String strSourceXml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(time);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = SpatialTemporalObjectNative.jni_AddItem(this.getHandle(), n, n2, n3, n4, n5, n6, Name, ItemKey, strSourceXml);
        return n7;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialTemporalObjectNative.jni_GetCount(this.getHandle());
    }

    public SpatialTemporalItemInfo[] findItemInfos(Date startTime, Date endTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(startTime);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar2.setTime(endTime);
        int n7 = gregorianCalendar2.get(1);
        int n8 = gregorianCalendar2.get(2) + 1;
        int n9 = gregorianCalendar2.get(5);
        int n10 = gregorianCalendar2.get(11);
        int n11 = gregorianCalendar2.get(12);
        int n12 = gregorianCalendar2.get(13);
        long[] lArray = SpatialTemporalObjectNative.jni_FindItemInfos(this.getHandle(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12);
        SpatialTemporalItemInfo[] spatialTemporalItemInfoArray = new SpatialTemporalItemInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            spatialTemporalItemInfoArray[i] = new SpatialTemporalItemInfo(lArray[i], this);
        }
        return spatialTemporalItemInfoArray;
    }

    public SpatialTemporalItemInfo[] getAllItemInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = SpatialTemporalObjectNative.jni_GetAllItemInfos(this.getHandle());
        SpatialTemporalItemInfo[] spatialTemporalItemInfoArray = new SpatialTemporalItemInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            spatialTemporalItemInfoArray[i] = new SpatialTemporalItemInfo(lArray[i], this);
        }
        return spatialTemporalItemInfoArray;
    }

    public Date getStartTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-9]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = SpatialTemporalObjectNative.jni_getStartTime(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                ((SimpleDateFormat)dateFormat).applyPattern("yyyy-MM-dd HH:mm:ss");
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public Date getEndTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-9]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = SpatialTemporalObjectNative.jni_getEndTime(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                ((SimpleDateFormat)dateFormat).applyPattern("yyyy-MM-dd HH:mm:ss");
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public boolean RemoveItem(Date time) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(time);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        boolean bl = SpatialTemporalObjectNative.jni_RemoveItem(this.getHandle(), n, n2, n3, n4, n5, n6);
        return bl;
    }

    public boolean RemoveItem(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SpatialTemporalObjectNative.jni_RemoveItem1(this.getHandle(), name);
        return bl;
    }

    public boolean RemoveAllItem() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SpatialTemporalObjectNative.jni_RemoveAllItem(this.getHandle());
        return bl;
    }

    public String ToXML(String strXMLPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = SpatialTemporalObjectNative.jni_ToXML(this.getHandle(), strXMLPath);
        return string;
    }

    public boolean FromXML(String strXMLPath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = SpatialTemporalObjectNative.jni_FromXML(this.getHandle(), strXMLPath);
        return bl;
    }

    public int IndexOf(SpatialTemporalItemInfo itemInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialTemporalObjectNative.jni_IndexOf(this.getHandle(), itemInfo.getHandle());
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SpatialTemporalObjectNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

