/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetMosaic;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.MosaicToolkit;
import com.supermap.data.PrjCoordSys;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class MosaicAddImageDataMain {
    public static void main(String[] args) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.print("MosaicAddImageDataMain process id is: ");
        System.out.println(Integer.valueOf(runtimeMXBean.getName().split("@")[0]));
        if (args.length < 3) {
            System.out.println("MosaicAddImageDataMain args length less than 3");
            return;
        }
        DatasourceConnectionInfo datasourceConnectionInfo = new DatasourceConnectionInfo();
        datasourceConnectionInfo.setServer(args[0]);
        datasourceConnectionInfo.setEngineType(EngineType.UDBX);
        Datasource datasource = new Datasource(EngineType.UDBX);
        datasource.create(datasourceConnectionInfo);
        String string = datasource.getDatasets().getAvailableDatasetName("mosaic");
        DatasetMosaic datasetMosaic = datasource.getDatasets().createDatasetMosaic(string, PrjCoordSys.fromEPSG(Integer.parseInt(args[1])));
        if (datasetMosaic == null) {
            System.out.println("resultMosaic is null.");
            return;
        }
        boolean bl = MosaicToolkit.addMosaicFilesWithFile(datasetMosaic, args[2], args.length < 4 ? "" : args[3]);
        if (!bl) {
            System.out.println(args[2] + "addFiles failure");
        }
        datasource.close();
    }
}

