/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.Material3D;
import com.supermap.data.Material3DNative;
import com.supermap.data.Material3DPBRNative;
import com.supermap.data.ModelEntityManager;
import com.supermap.data.PBRAlphaModeType;
import com.supermap.data.TextureData;
import com.supermap.data.TextureMotionParameter;
import java.util.ArrayList;

public class Material3DPBR
extends Material3D {
    public Material3DPBR() {
        Material3DPBRNative.jni_New(this.getHandle());
    }

    protected Material3DPBR(long materialHandle, long modelHandle) {
        this.dispose();
        long l = Material3DNative.jni_New2(materialHandle);
        this.setHandle(l, true);
        if (modelHandle != 0L) {
            long[] lArray = Material3DNative.jni_GetTextureData(materialHandle, modelHandle);
            super.resetTexureData(lArray);
        }
    }

    protected Material3DPBR(long pMaterial, ModelEntityManager pEM) {
        this.dispose();
        long l = Material3DNative.jni_New2(pMaterial);
        this.setHandle(l, true);
        long[] lArray = Material3DNative.jni_GetTextureData2(pMaterial, pEM.getHandle());
        super.resetTexureData(lArray);
    }

    protected Material3DPBR(long pMaterial) {
        super(pMaterial);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Material3DPBRNative.jni_Delete(this.getHandle());
        }
        this.b();
        this.clearHandle();
    }

    public Material3DPBR(Material3DPBR material3DPBR) {
        ArrayList arrayList;
        if (material3DPBR == null) {
            String string = InternalResource.loadString("material3DPBR", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (material3DPBR.getHandle() == 0L) {
            String string = InternalResource.loadString("material3DPBR", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Material3DPBRNative.jni_Clone(material3DPBR.getHandle(), this.getHandle());
        if (material3DPBR.a != null && (arrayList = material3DPBR.a).size() > 0) {
            this.a = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                TextureData textureData = null;
                textureData = ((TextureData)arrayList.get(i)).isExternal() ? new TextureData(true) : new TextureData(((TextureData)arrayList.get(i)).getHandle());
                textureData.setName(((TextureData)arrayList.get(i)).getName());
                this.a.add(textureData);
            }
        }
    }

    public Material3DPBR clone() {
        return new Material3DPBR(this);
    }

    private void b() {
        if (this.a != null) {
            for (int i = 0; i < this.a.size(); ++i) {
                ((TextureData)this.a.get(i)).dispose();
            }
            this.a.clear();
        }
    }

    public double[] getEmissiveFactor() {
        this.displayExceptionMessage(this.getHandle(), "getEmissiveFactor()");
        return Material3DPBRNative.jni_GetEmissiveFactor(this.getHandle());
    }

    public void setEmissiveFactor(double[] result) {
        this.displayExceptionMessage(this.getHandle(), "setEmissiveFactor(double[] value)");
        if (result.length != 3) {
            return;
        }
        Material3DPBRNative.jni_SetEmissiveFactor(this.getHandle(), result);
    }

    public int getEmissiveTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getEmissiveTextureIndex()");
        return Material3DPBRNative.jni_GetEmissiveTextureIndex(this.getHandle());
    }

    public void setEmissiveTextureIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setEmissiveTextureIndex(int value)");
        Material3DPBRNative.jni_SetEmissiveTextureIndex(this.getHandle(), result);
    }

    public void setEmissiveTextureCoordIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setEmissiveTextureCoordIndex(int value)");
        Material3DPBRNative.jni_SetEmissiveTextureCoordIndex(this.getHandle(), result);
    }

    public int getEmissiveTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getEmissiveTextureCoordIndex()");
        return Material3DPBRNative.jni_GetEmissiveTextureCoordIndex(this.getHandle());
    }

    public int getNormalTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getNormalTextureIndex()");
        return Material3DPBRNative.jni_GetNormalTextureIndex(this.getHandle());
    }

    public void setNormalTextureIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setNormalTextureIndex(int value)");
        Material3DPBRNative.jni_SetNormalTextureIndex(this.getHandle(), result);
    }

    public int getNormalTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getNormalTextureCoordIndex()");
        return Material3DPBRNative.jni_GetNormalTextureCoordIndex(this.getHandle());
    }

    public void setNormalTextureCoordIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setNormalTextureCoordIndex(int value)");
        Material3DPBRNative.jni_SetNormalTextureCoordIndex(this.getHandle(), result);
    }

    public float getNormalTextureScale() {
        this.displayExceptionMessage(this.getHandle(), "getNormalTextureScale()");
        return Material3DPBRNative.jni_GetNormalTextureScale(this.getHandle());
    }

    public void setNormalTextureScale(float result) {
        this.displayExceptionMessage(this.getHandle(), "setNormalTextureScale(float value)");
        Material3DPBRNative.jni_SetNormalTextureScale(this.getHandle(), result);
    }

    public int getOcclusionTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getOcclusionTextureIndex()");
        return Material3DPBRNative.jni_GetOcclusionTextureIndex(this.getHandle());
    }

    public void setOcclusionTextureIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setOcclusionTextureIndex(int value)");
        Material3DPBRNative.jni_SetOcclusionTextureIndex(this.getHandle(), result);
    }

    public int getOcclusionTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getOcclusionTextureCoordIndex()");
        return Material3DPBRNative.jni_GetOcclusionTextureCoordIndex(this.getHandle());
    }

    public void setOcclusionTextureCoordIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setOcclusionTextureCoordIndex(int value)");
        Material3DPBRNative.jni_SetOcclusionTextureCoordIndex(this.getHandle(), result);
    }

    public float getOcclusionTextureStrength() {
        this.displayExceptionMessage(this.getHandle(), "getOcclusionTextureStrength()");
        return Material3DPBRNative.jni_GetOcclusionTextureStrength(this.getHandle());
    }

    public void setOcclusionTextureStrength(float result) {
        this.displayExceptionMessage(this.getHandle(), "setOcclusionTextureStrength(float value)");
        Material3DPBRNative.jni_SetOcclusionTextureStrength(this.getHandle(), result);
    }

    public PBRAlphaModeType getAlphaMode() {
        this.displayExceptionMessage(this.getHandle(), "getAlphaMode()");
        int n = Material3DPBRNative.jni_GetAlphaMode(this.getHandle());
        switch (n) {
            case 0: {
                return PBRAlphaModeType.UNKNOWN;
            }
            case 1: {
                return PBRAlphaModeType.OPAQUE;
            }
            case 2: {
                return PBRAlphaModeType.MASK;
            }
        }
        return PBRAlphaModeType.BLEND;
    }

    public void setAlphaMode(PBRAlphaModeType modeType) {
        this.displayExceptionMessage(this.getHandle(), "setAlphaMode(int value)");
        Material3DPBRNative.jni_SetAlphaMode(this.getHandle(), modeType.value());
    }

    public float getAlphaCutoff() {
        this.displayExceptionMessage(this.getHandle(), "getAlphaCutoff()");
        return Material3DPBRNative.jni_GetAlphaCutoff(this.getHandle());
    }

    public void setAlphaCutoff(float result) {
        this.displayExceptionMessage(this.getHandle(), "setAlphaCutoff(float value)");
        Material3DPBRNative.jni_SetAlphaCutoff(this.getHandle(), result);
    }

    public boolean isDoubleSided() {
        this.displayExceptionMessage(this.getHandle(), "getIsDoubleSided()");
        return Material3DPBRNative.jni_IsDoubleSided(this.getHandle());
    }

    public void setDoubleSided(boolean result) {
        this.displayExceptionMessage(this.getHandle(), "setIsDoubleSided(boolean value)");
        Material3DPBRNative.jni_SetDoubleSided(this.getHandle(), result);
    }

    public double[] getBaseColor() {
        this.displayExceptionMessage(this.getHandle(), "getBaseColor()");
        return Material3DPBRNative.jni_GetBaseColor(this.getHandle());
    }

    public void setBaseColor(double[] color) {
        this.displayExceptionMessage(this.getHandle(), "setIsDoubleSided(boolean value)");
        Material3DPBRNative.jni_SetBaseColor(this.getHandle(), color);
    }

    public int getBaseColorTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getBaseColorTextureIndex()");
        return Material3DPBRNative.jni_GetBaseColorTextureIndex(this.getHandle());
    }

    public void setBaseColorTextureIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setBaseColorTextureIndex(int value)");
        Material3DPBRNative.jni_SetBaseColorTextureIndex(this.getHandle(), result);
    }

    public int getBaseColorTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getBaseColorTextureCoordIndex()");
        return Material3DPBRNative.jni_GetBaseColorTextureCoordIndex(this.getHandle());
    }

    public void setBaseColorTextureCoordIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setBaseColorTextureCoordIndex(int value)");
        Material3DPBRNative.jni_SetBaseColorTextureCoordIndex(this.getHandle(), result);
    }

    public int getMetallicRoughnessTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getMetallicRoughnessTextureIndex()");
        return Material3DPBRNative.jni_GetMetallicRoughnessTextureIndex(this.getHandle());
    }

    public void setMetallicRoughnessTextureIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setMetallicRoughnessTextureIndex(int value)");
        Material3DPBRNative.jni_SetMetallicRoughnessTextureIndex(this.getHandle(), result);
    }

    public int getMetallicRoughnessTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getMetallicRoughnessTextureCoordIndex()");
        return Material3DPBRNative.jni_GetMetallicRoughnessTextureCoordIndex(this.getHandle());
    }

    public void setMetallicRoughnessTextureCoordIndex(int result) {
        this.displayExceptionMessage(this.getHandle(), "setMetallicRoughnessTextureCoordIndex(int value)");
        Material3DPBRNative.jni_SetMetallicRoughnessTextureCoordIndex(this.getHandle(), result);
    }

    public float getMetallicFactor() {
        this.displayExceptionMessage(this.getHandle(), "getMetallicFactor()");
        return Material3DPBRNative.jni_GetMetallicFactor(this.getHandle());
    }

    public void setMetallicFactor(float result) {
        this.displayExceptionMessage(this.getHandle(), "setMetallicFactor(float value)");
        Material3DPBRNative.jni_SetMetallicFactor(this.getHandle(), result);
    }

    public float getRoughnessFactor() {
        this.displayExceptionMessage(this.getHandle(), "getRoughnessFactor()");
        return Material3DPBRNative.jni_GetRoughnessFactor(this.getHandle());
    }

    public void setRoughnessFactor(float result) {
        this.displayExceptionMessage(this.getHandle(), "setRoughnessFactor(float value)");
        Material3DPBRNative.jni_SetRoughnessFactor(this.getHandle(), result);
    }

    public void displayExceptionMessage(long handle, String message) {
        if (handle == 0L) {
            String string = InternalResource.loadString(message, "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    public TextureMotionParameter getBaseColorTextureOffsetMotionParameter() {
        this.displayExceptionMessage(this.getHandle(), "getBaseColorTextureOffsetMotionParameter()");
        float[] fArray = Material3DPBRNative.jni_GetBaseColorTextureOffsetMotionParameter(this.getHandle());
        if (fArray.length != 3) {
            return null;
        }
        return new TextureMotionParameter(fArray[0], fArray[1], fArray[2]);
    }

    public void setBaseColorTextureOffsetMotionParameter(TextureMotionParameter parameters) {
        this.displayExceptionMessage(this.getHandle(), "setBaseColorTextureOffsetMotionParameter()");
        float[] fArray = new float[]{parameters.getSpeedU(), parameters.getSpeedV(), parameters.getPeriod()};
        Material3DPBRNative.jni_SetBaseColorTextureOffsetMotionParameter(this.getHandle(), fArray);
    }

    public TextureMotionParameter getBaseColorTextureTilingMotionParameter() {
        this.displayExceptionMessage(this.getHandle(), "getBaseColorTextureTilingMotionParameter()");
        float[] fArray = Material3DPBRNative.jni_GetBaseColorTextureTilingMotionParameter(this.getHandle());
        if (fArray.length != 3) {
            return null;
        }
        return new TextureMotionParameter(fArray[0], fArray[1], fArray[2]);
    }

    public void setBaseColorTextureTilingMotionParameter(TextureMotionParameter parameters) {
        this.displayExceptionMessage(this.getHandle(), "setBaseColorTextureTilingMotionParameter()");
        float[] fArray = new float[]{parameters.getSpeedU(), parameters.getSpeedV(), parameters.getPeriod()};
        Material3DPBRNative.jni_SetBaseColorTextureTilingMotionParameter(this.getHandle(), fArray);
    }

    public TextureMotionParameter getEmissiveTextureTilingMotionParameter() {
        this.displayExceptionMessage(this.getHandle(), "getEmissiveTextureTilingMotionParameter()");
        float[] fArray = Material3DPBRNative.jni_GetEmissiveTextureTilingMotionParameter(this.getHandle());
        if (fArray.length != 3) {
            return null;
        }
        return new TextureMotionParameter(fArray[0], fArray[1], fArray[2]);
    }

    public void setEmissiveTextureTilingMotionParameter(TextureMotionParameter parameters) {
        this.displayExceptionMessage(this.getHandle(), "setEmissiveTextureTilingMotionParameter()");
        float[] fArray = new float[]{parameters.getSpeedU(), parameters.getSpeedV(), parameters.getPeriod()};
        Material3DPBRNative.jni_SetEmissiveTextureTilingMotionParameter(this.getHandle(), fArray);
    }

    public TextureMotionParameter getEmissiveTextureOffsetMotionParameter() {
        this.displayExceptionMessage(this.getHandle(), "getEmissiveTextureOffsetMotionParameter()");
        float[] fArray = Material3DPBRNative.jni_GetEmissiveTextureOffsetMotionParameter(this.getHandle());
        if (fArray.length != 3) {
            return null;
        }
        return new TextureMotionParameter(fArray[0], fArray[1], fArray[2]);
    }

    public void setEmissiveTextureOffsetMotionParameter(TextureMotionParameter parameters) {
        this.displayExceptionMessage(this.getHandle(), "setEmissiveTextureOffsetMotionParameter()");
        float[] fArray = new float[]{parameters.getSpeedU(), parameters.getSpeedV(), parameters.getPeriod()};
        Material3DPBRNative.jni_SetEmissiveTextureOffsetMotionParameter(this.getHandle(), fArray);
    }

    public int getMaskTextureIndex() {
        this.displayExceptionMessage(this.getHandle(), "getMaskTextureIndex()");
        return Material3DPBRNative.jni_GetMaskTextureIndex(this.getHandle());
    }

    public void setMaskTextureIndex(int maskTextureIndex) {
        this.displayExceptionMessage(this.getHandle(), "setMaskTextureIndex()");
        Material3DPBRNative.jni_SetMaskTextureIndex(this.getHandle(), maskTextureIndex);
    }

    public int getMaskTextureCoordIndex() {
        this.displayExceptionMessage(this.getHandle(), "getMaskTextureCoordIndex()");
        return Material3DPBRNative.jni_GetMaskTextureCoordIndex(this.getHandle());
    }

    public void setMaskTextureCoordIndex(int maskTextureIndex) {
        this.displayExceptionMessage(this.getHandle(), "setMaskTextureCoordIndex()");
        Material3DPBRNative.jni_SetMaskTextureCoordIndex(this.getHandle(), maskTextureIndex);
    }
}

