/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoTextNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextPart;
import com.supermap.data.TextStyle;
import java.util.ArrayList;

public class GeoText
extends Geometry {
    private ArrayList a = null;
    private TextStyle b = null;

    public GeoText() {
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this.b();
        this.a = new ArrayList();
    }

    public GeoText(GeoText geoText) {
        if (geoText == null) {
            String string = InternalResource.loadString("geoText", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_Clone(geoText.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        int n = geoText.a().size();
        for (int i = 0; i < n; ++i) {
            TextPart textPart = new TextPart(this, i);
            this.a.add(textPart);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoText);
    }

    public GeoText(TextPart part) {
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this.b();
        this.a = new ArrayList();
        this.addPart(part);
        InternalHandleDisposable.makeSureNativeObjectLive(part);
    }

    public GeoText(TextPart part, TextStyle textStyle) {
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
        this.addPart(part);
        this.setTextStyle(textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    GeoText(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        this.c();
    }

    protected static GeoText creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoText(handle);
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        for (int i = 0; i < this.getPartCount(); ++i) {
            string = string + this.getPart(i).getText();
        }
        return string;
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle());
    }

    public TextStyle getTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.b == null && (l = GeoTextNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this.b = TextStyle.createInstance(l);
        }
        return this.b;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        GeoTextNative.jni_SetTextStyle(this.getHandle(), textStyle2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle2);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle()) == 0;
    }

    public int addPart(TextPart part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GeoTextNative.jni_AddPart(this.getHandle(), part.getHandle(), part.getX(), part.getY());
        TextPart textPart = new TextPart(this, n);
        this.a.add(textPart);
        InternalHandleDisposable.makeSureNativeObjectLive(part);
        return n;
    }

    public TextPart getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        TextPart textPart = (TextPart)this.a.get(index);
        return textPart;
    }

    public boolean insertPart(int index, TextPart part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = GeoTextNative.jni_InsertPart(this.getHandle(), index, part.getHandle(), part.getX(), part.getY());
        if (bl) {
            TextPart textPart = new TextPart(this, index);
            this.a.add(index, textPart);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(part);
        return bl;
    }

    public int indexOf(TextPart part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a.indexOf(part);
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoTextNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    public boolean setPart(int index, TextPart part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (part == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (part.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeoTextNative.jni_SetPart(this.getHandle(), index, part.getHandle(), part.getX(), part.getY());
        if (bl) {
            TextPart textPart = new TextPart(this, index);
            this.a.set(index, textPart);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(part);
        return bl;
    }

    public static GeoText makeAlongLineText(String text, GeoLine line) {
        if (line.getHandle() == 0L) {
            String string = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (text == null || text.trim().length() == 0) {
            String string = InternalResource.loadString("text", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoText geoText = new GeoText();
        boolean bl = GeoTextNative.jni_MakeAlongLineText(geoText.getHandle(), text, line.getHandle(), false, 0.0);
        if (bl) {
            geoText.c();
            InternalHandleDisposable.makeSureNativeObjectLive(line);
            return geoText;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(line);
        return null;
    }

    public static GeoText makeAlongLineText(String text, GeoLine line, double fixedAngle) {
        if (line.getHandle() == 0L) {
            String string = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (text == null || text.trim().length() == 0) {
            String string = InternalResource.loadString("text", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoText geoText = new GeoText();
        boolean bl = GeoTextNative.jni_MakeAlongLineText(geoText.getHandle(), text, line.getHandle(), true, fixedAngle);
        if (bl) {
            geoText.c();
            InternalHandleDisposable.makeSureNativeObjectLive(line);
            return geoText;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(line);
        return null;
    }

    @Override
    public GeoText clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoText(this);
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTextNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTextNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.c();
        }
        return bl;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clearHandle();
            this.b = null;
        }
    }

    public Rectangle2D getRealBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        GeoTextNative.jni_GetRealBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setRealBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTextNative.jni_SetRealBounds(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom());
    }

    ArrayList a() {
        return this.a;
    }

    void b() {
        this.getTextStyle().a();
    }

    private void c() {
        this.a.clear();
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            TextPart textPart = new TextPart(this, i);
            this.a.add(textPart);
        }
    }
}

