/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoTable3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoTable3D
extends Geometry3D {
    public GeoTable3D() {
        long l = GeoTable3DNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoTable3D(GeoTable3D geoTable3D) {
        if (geoTable3D == null) {
            String string = InternalResource.loadString("GeoTable3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoTable3D.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoTable3D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoTable3DNative.jni_Clone(geoTable3D.getHandle(), this.getHandle());
    }

    public GeoTable3D(Point3D position, double length1, double length2, double ratio, double height) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoTable3DNative.jni_New3(dArray, length1, length2, ratio, height);
        this.setHandle(l, true);
    }

    @Override
    public GeoTable3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoTable3D(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoTable3D", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTable3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getDiagonal1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDiagonal1", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTable3DNative.jni_GetDiagonal1(this.getHandle());
    }

    public void setDiagonal1(double diagonal1) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDiagonal1", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTable3DNative.jni_SetDiagonal1(this.getHandle(), diagonal1);
    }

    public double getDiagonal2() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDiagonal2", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTable3DNative.jni_GetDiagonal2(this.getHandle());
    }

    public void setDiagonal2(double diagonal2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDiagonal2", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTable3DNative.jni_SetDiagonal2(this.getHandle(), diagonal2);
    }

    public double getRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRatio", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTable3DNative.jni_GetRatio(this.getHandle());
    }

    public void setRatio(double ratio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRatio", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTable3DNative.jni_SetRatio(this.getHandle(), ratio);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTable3DNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTable3DNative.jni_SetHeight(this.getHandle(), height);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoTable3DNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

