/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPointNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Toolkit;

public class GeoPoint
extends Geometry {
    public GeoPoint() {
        long l = GeoPointNative.jni_New();
        this.setHandle(l, true);
        this.a();
    }

    public GeoPoint(double x, double y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public GeoPoint(GeoPoint point) {
        if (point.getHandle() == 0L) {
            String string = InternalResource.loadString("point", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPointNative.jni_Clone(point.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(point);
    }

    public GeoPoint(Point2D point) {
        this(point.getX(), point.getY());
    }

    GeoPoint(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPointNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPointNative.jni_GetX(this.getHandle());
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPointNative.jni_GetY(this.getHandle());
    }

    public void setX(double x) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPointNative.jni_SetX(this.getHandle(), x);
    }

    public void setY(double y) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPointNative.jni_SetY(this.getHandle(), y);
    }

    @Override
    public GeoPoint clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPoint(this);
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPointNative.jni_Clear(this.getHandle());
        GeoPointNative.jni_SetX(this.getHandle(), -1.7976931348623157E308);
        GeoPointNative.jni_SetY(this.getHandle(), -1.7976931348623157E308);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Toolkit.isZero(this.getX() - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.getY() - -1.7976931348623157E308, -1.0E-10, 1.0E-10);
        return bl;
    }

    void a() {
        this.setX(-1.7976931348623157E308);
        this.setY(-1.7976931348623157E308);
    }
}

