/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPicture3DNative;
import com.supermap.data.GeoPictureNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import java.io.File;

public class GeoPicture3D
extends Geometry3D {
    public GeoPicture3D() {
        long l = GeoPicture3DNative.jni_New();
        this.setHandle(l, true);
    }

    GeoPicture3D(long handle) {
        this.setHandle(handle, false);
    }

    public GeoPicture3D(GeoPicture3D geoPicture3D) {
        if (geoPicture3D == null) {
            String string = InternalResource.loadString("geoPicture3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoPicture3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPicture3D", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPictureNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPicture3D);
    }

    public GeoPicture3D(String imageFile, Point3D position, double width, double height, double rotationZ) {
        File file = new File(imageFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("imageFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (width <= 0.0) {
            String string = InternalResource.loadString("width", "GeoPicture3D_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (height <= 0.0) {
            String string = InternalResource.loadString("height", "GeoPicture3D_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPicture3DNative.jni_New1(imageFile, position.getX(), position.getY(), position.getZ(), width, height, rotationZ);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoPicture3D(String imageFile, Point3D position, double width,double height, double rotationZ)", "GeoPicture_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, true);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getWidth(this.getHandle());
    }

    public void setWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture3D_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPicture3DNative.jni_setWidth(this.getHandle(), value);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture3D_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPicture3DNative.jni_setHeight(this.getHandle(), value);
    }

    public String getImageFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPicture3DNative.jni_getImageFile(this.getHandle());
    }

    public void setImageFile(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPicture3DNative.jni_setImageFile(this.getHandle(), value);
    }

    @Override
    public GeoPicture3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPicture3D(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPicture3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

