/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCurvePolygonNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoCurvePolygon
extends Geometry {
    private ArrayList<Geometry> a;

    public GeoCurvePolygon() {
        long l = GeoCurvePolygonNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    GeoCurvePolygon(long handle) {
        if (0L != handle) {
            this.setHandle(handle, false);
            this.a = new ArrayList();
            GeoCurvePolygon.a(this);
        }
    }

    public GeoCurvePolygon(GeoCurvePolygon geoParametricRegion) {
        if (geoParametricRegion == null) {
            String string = InternalResource.loadString("GeoParametricRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParametricRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParametricRegion", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCurvePolygonNative.jni_Clone(l);
        this.a = new ArrayList();
        this.setHandle(l2, true);
        GeoCurvePolygon.a(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricRegion);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCurvePolygonNative.jni_GetPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCurvePolygonNative.jni_GetArea(this.getHandle());
    }

    public boolean addRing(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoCurvePolygonNative.jni_AddRing(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.a.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.a.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n != -1;
    }

    public int getRingCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCurvePolygonNative.jni_GetRingCount(this.getHandle());
    }

    public Geometry getRing(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    @Override
    public GeoCurvePolygon clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCurvePolygon(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCurvePolygonNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getRingCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCurvePolygonNative.jni_Clear(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (Geometry geometry : this.a) {
            geometry.setIsDisposable(true);
            geometry.setHandle(0L);
            geometry.clearHandle();
        }
        this.a.clear();
    }

    static void a(GeoCurvePolygon geoCurvePolygon) {
        int n = geoCurvePolygon.getRingCount();
        long[] lArray = new long[n];
        GeoCurvePolygonNative.jni_AllGeometrys(geoCurvePolygon.getHandle(), lArray);
        for (long l : lArray) {
            Geometry geometry = Geometry.createInstance(l);
            if (null == geometry) continue;
            geometry.setIsDisposable(false);
            geoCurvePolygon.a.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCurvePolygon);
    }

    protected static GeoCurvePolygon creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoCurvePolygon(handle);
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoCurvePolygonNative.jni_ConvertToRegion(this.getHandle());
        if (l != 0L) {
            GeoRegion geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
            return geoRegion;
        }
        return null;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoCurvePolygonNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }
}

