/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCompoundCurveNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoCompoundCurve
extends Geometry {
    private ArrayList<Geometry> a;

    public GeoCompoundCurve() {
        long l = GeoCompoundCurveNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    GeoCompoundCurve(long handle) {
        if (0L != handle) {
            this.setHandle(handle, false);
            this.a = new ArrayList();
            GeoCompoundCurve.a(this);
        }
    }

    public GeoCompoundCurve(GeoCompoundCurve geoParametricLine) {
        if (geoParametricLine == null) {
            String string = InternalResource.loadString("GeoParametricLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParametricLine);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParametricLine", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCompoundCurveNative.jni_Clone(l);
        this.a = new ArrayList();
        this.setHandle(l2, true);
        GeoCompoundCurve.a(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricLine);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCompoundCurveNative.jni_GetLength(this.getHandle());
    }

    public boolean addCurve(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoCompoundCurveNative.jni_AddCurve(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.a.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.a.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n != -1;
    }

    public int getCurveCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCompoundCurveNative.jni_GetCurveCount(this.getHandle());
    }

    public Geometry getCurve(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    @Override
    public GeoCompoundCurve clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCompoundCurve(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCompoundCurveNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCurveCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompoundCurveNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            for (Geometry geometry : this.a) {
                geometry.setIsDisposable(true);
                geometry.setHandle(0L);
                geometry.clearHandle();
            }
            this.a.clear();
        }
    }

    private static void a(GeoCompoundCurve geoCompoundCurve) {
        int n = geoCompoundCurve.getCurveCount();
        long[] lArray = new long[n];
        GeoCompoundCurveNative.jni_AllGeometrys(geoCompoundCurve.getHandle(), lArray);
        Geometry geometry = null;
        for (long l : lArray) {
            geometry = Geometry.createInstance(l);
            if (null == geometry) continue;
            geometry.setIsDisposable(false);
            geoCompoundCurve.a.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompoundCurve);
    }

    protected static GeoCompoundCurve creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoCompoundCurve(handle);
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoCompoundCurveNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }
}

