/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetIDType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfoNative;
import com.supermap.data.Datasets;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.GeoStoreType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.Rectangle2D;

public class DatasetVectorInfo
extends InternalHandleDisposable {
    public DatasetVectorInfo() {
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.a();
    }

    public DatasetVectorInfo(String name, DatasetType type) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalInvalidState internalInvalidState = Dataset.b(name);
        if (internalInvalidState != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "Dataset_NameErrorPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(DatasetVectorInfoNative.jni_New(), true);
        this.a();
        this.setName(name);
        this.setType(type);
    }

    public DatasetVectorInfo(DatasetVectorInfo datasetVectorInfo) {
        if (datasetVectorInfo == null) {
            String string = InternalResource.loadString("datasetVectorInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetVectorInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetVectorInfoNative.jni_Clone(datasetVectorInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetVectorInfo);
    }

    public DatasetVectorInfo(String name, DatasetVector templateDataset) {
        if (templateDataset == null) {
            String string = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = templateDataset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = DatasetVectorInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(name);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalInvalidState internalInvalidState = Dataset.b(value);
        if (internalInvalidState != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "Dataset_NameErrorPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetVectorInfoNative.jni_SetName(this.getHandle(), value);
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetType(this.getHandle());
        return (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
    }

    public DatasetIDType getDatasetIDType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetDatasetIDType(this.getHandle());
        return (DatasetIDType)Enum.parseUGCValue(DatasetIDType.class, n);
    }

    public void setDatasetIDType(DatasetIDType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetDatasetIDType(this.getHandle(), type.getUGCValue());
    }

    public void setType(DatasetType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!Datasets.a(value)) {
            String string = InternalResource.loadString("value", "DatasetVectorInfo_IllegalDatasetType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVectorInfoNative.jni_SetType(this.getHandle(), value.getUGCValue());
    }

    public GeoStoreType getGeoStoreType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetGeoStoreType(this.getHandle());
        return (GeoStoreType)Enum.parseUGCValue(GeoStoreType.class, n);
    }

    public void setGeoStoreType(GeoStoreType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetGeoStoreType(this.getHandle(), value.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVectorInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVectorInfoNative.jni_SetEncodeType(this.getHandle(), value.getUGCValue());
    }

    public boolean isFileCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetIsFileCache(this.getHandle());
    }

    public void setFileCache(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVectorInfoNative.jni_SetIsFileCache(this.getHandle(), value);
    }

    public void setBlobTablespaceName(String strTablespaceName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVectorInfoNative.jni_SetBlobTablespaceName(this.getHandle(), strTablespaceName);
    }

    public String getBlobTablespaceName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVectorInfoNative.jni_GetBlobTablespaceName(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetVectorInfoNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{value.getLeft(), value.getBottom(), value.getRight(), value.getTop()};
        DatasetVectorInfoNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "{Name=\"" + this.getName() + "\",Type=" + this.getType().name() + ",EncodeType=" + this.getEncodeType().name() + ",IsFileCache=" + this.isFileCache() + "}";
        return string;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    void a() {
        if (this.getHandle() != 0L) {
            DatasetVectorInfoNative.jni_Reset(this.getHandle());
        }
    }
}

