/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CodeDomainNative;
import com.supermap.data.CodeInfo;
import com.supermap.data.Domain;
import com.supermap.data.FieldType;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class CodeDomain
extends Domain {
    CodeDomain(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
    }

    protected CodeDomain() {
        this.setHandle(CodeDomainNative.jni_New());
    }

    public CodeDomain(int id, String name, String description, FieldType fieldType) {
        long l = CodeDomainNative.jni_New3(id, name, description, fieldType.value());
        if (l == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.setHandle(l);
    }

    public CodeDomain(int id, String name, String description, FieldType fieldType, ArrayList<CodeInfo> codeInfos) {
        long[] lArray = new long[codeInfos.size()];
        for (int i = 0; i < codeInfos.size(); ++i) {
            if (codeInfos.get(i).getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = codeInfos.get(i).getHandle();
        }
        long l = CodeDomainNative.jni_New2(id, name, description, fieldType.value(), lArray);
        if (l == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.setHandle(l);
    }

    public int getCodeCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCodeInfos().length;
    }

    public CodeInfo[] getCodeInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = CodeDomainNative.jni_GetCodeInfos(this.getHandle());
        CodeInfo[] codeInfoArray = new CodeInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            codeInfoArray[i] = new CodeInfo(lArray[i]);
        }
        return codeInfoArray;
    }

    public CodeInfo get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = CodeDomainNative.jni_Get(this.getHandle(), index);
        CodeInfo codeInfo = new CodeInfo(l);
        return codeInfo;
    }

    public boolean add(CodeInfo codeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfo) {
            return false;
        }
        if (codeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return CodeDomainNative.jni_Add(this.getHandle(), codeInfo.getHandle());
    }

    public void append(CodeInfo[] codeInfos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfos) {
            return;
        }
        long[] lArray = new long[codeInfos.length];
        for (int i = 0; i < codeInfos.length; ++i) {
            if (codeInfos[i].getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = codeInfos[i].getHandle();
        }
        CodeDomainNative.jni_Append(this.getHandle(), lArray);
    }

    public boolean set(int index, CodeInfo codeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == codeInfo) {
            return false;
        }
        if (index < 0 || index >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (codeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return CodeDomainNative.jni_Set(this.getHandle(), index, codeInfo.getHandle());
    }

    public void remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCodeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        CodeDomainNative.jni_Remove(this.getHandle(), index);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeDomainNative.jni_RemoveAll(this.getHandle());
    }
}

