/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Domain;
import com.supermap.data.FieldType;
import com.supermap.data.InternalResource;
import com.supermap.data.RangeDomainNative;
import com.supermap.data.RangeInfo;
import java.util.ArrayList;

public class RangeDomain
extends Domain {
    RangeDomain(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
    }

    protected RangeDomain() {
        this.setHandle(RangeDomainNative.jni_New());
    }

    public RangeDomain(int id, String name, String description, FieldType fieldType) {
        long l = RangeDomainNative.jni_New3(id, name, description, fieldType.value());
        if (l == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.setHandle(l);
    }

    public RangeDomain(int id, String name, String description, FieldType fieldType, ArrayList<RangeInfo> rangeInfos) {
        long[] lArray = new long[rangeInfos.size()];
        for (int i = 0; i < rangeInfos.size(); ++i) {
            if (rangeInfos.get(i).getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = rangeInfos.get(i).getHandle();
        }
        long l = RangeDomainNative.jni_New2(id, name, description, fieldType.value(), lArray);
        if (l == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.setHandle(l);
    }

    public int getRangeCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getRangeInfos().length;
    }

    public RangeInfo[] getRangeInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = RangeDomainNative.jni_GetRangeInfos(this.getHandle());
        RangeInfo[] rangeInfoArray = new RangeInfo[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            rangeInfoArray[i] = new RangeInfo(lArray[i]);
        }
        return rangeInfoArray;
    }

    public RangeInfo get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = RangeDomainNative.jni_Get(this.getHandle(), index);
        RangeInfo rangeInfo = new RangeInfo(l);
        return rangeInfo;
    }

    public boolean add(RangeInfo rangeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfo) {
            return false;
        }
        if (rangeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RangeDomainNative.jni_Add(this.getHandle(), rangeInfo.getHandle());
    }

    public void append(RangeInfo[] rangeInfos) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfos) {
            return;
        }
        long[] lArray = new long[rangeInfos.length];
        for (int i = 0; i < rangeInfos.length; ++i) {
            if (rangeInfos[i].getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = rangeInfos[i].getHandle();
        }
        RangeDomainNative.jni_Append(this.getHandle(), lArray);
    }

    public boolean set(int index, RangeInfo rangeInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == rangeInfo) {
            return false;
        }
        if (index < 0 || index >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (rangeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RangeDomainNative.jni_Set(this.getHandle(), index, rangeInfo.getHandle());
    }

    public void remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getRangeCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        RangeDomainNative.jni_Remove(this.getHandle(), index);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        RangeDomainNative.jni_RemoveAll(this.getHandle());
    }
}

