/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material;
import com.supermap.data.Mesh;
import com.supermap.data.MeshesNative;
import java.util.ArrayList;

public class Meshes
extends InternalHandle {
    private ArrayList<Mesh> a = null;

    protected Meshes(long handle) {
        this.setHandle(handle);
        this.a = new ArrayList();
        this.a();
    }

    private void a() {
        long[] lArray = new long[2];
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            MeshesNative.jni_Get(this.getHandle(), i, lArray);
            long l = lArray[0];
            long l2 = lArray[1];
            if (l == 0L) continue;
            Mesh mesh = new Mesh(l);
            if (l2 != 0L) {
                Material material = new Material(l2);
                mesh.setMaterial(material);
            }
            this.a.add(mesh);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MeshesNative.jni_GetCount(this.getHandle());
    }

    public int add(Mesh mesh) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mesh == null) {
            String string = InternalResource.loadString("add", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Mesh mesh2 = new Mesh(mesh, false);
        long l = mesh2.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        Material material2 = null;
        if (material != null) {
            material2 = new Material(material, false);
            mesh2.setMaterial(material2);
            l2 = material2.getHandle();
        }
        if ((n = MeshesNative.jni_Add(this.getHandle(), l, l2)) != -1) {
            this.a.add(mesh2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(material2);
        return n;
    }

    public int addRange(Mesh[] meshes) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = meshes.length;
        for (n = 0; n < n3; ++n) {
            Mesh mesh = meshes[n];
            if (mesh == null) {
                String string = InternalResource.loadString("meshes[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (mesh.getHandle() != 0L) continue;
            String string = InternalResource.loadString("meshes[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(meshes[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(meshes);
        return n2;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MeshesNative.jni_Clear(this.getHandle());
        if (this.a != null) {
            this.a.clear();
        }
    }

    public Mesh get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insert(int index, Mesh mesh) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insert", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("insert", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index == this.getCount()) {
            return this.add(mesh) != -1;
        }
        Mesh mesh2 = new Mesh(mesh, false);
        long l = mesh2.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        Material material2 = null;
        if (material != null) {
            material2 = new Material(material, false);
            mesh2.setMaterial(material2);
            l2 = material2.getHandle();
        }
        if ((n = MeshesNative.jni_Insert(this.getHandle(), index, l, l2)) == -1) {
            InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
            InternalHandleDisposable.makeSureNativeObjectLive(material2);
            return false;
        }
        this.a.add(index, mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(material2);
        return true;
    }

    public int insertRange(int index, Mesh[] meshes) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insertRange", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = meshes.length;
        for (n = 0; n < n2; ++n) {
            Mesh mesh = meshes[n];
            if (mesh == null) {
                String string = InternalResource.loadString("meshes[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (mesh.getHandle() != 0L) continue;
            String string = InternalResource.loadString("meshes[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl = this.insert(index + n, meshes[i]);
            if (!bl) continue;
            ++n;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(meshes);
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (MeshesNative.jni_Remove(this.getHandle(), index)) {
            Mesh mesh = this.get(index);
            mesh.clearHandle();
            this.a.remove(index);
            return true;
        }
        return false;
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("removeRange", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (count < 0 || count > this.getCount() - index) {
            String string = InternalResource.loadString("removeRange", "Meshes_RemoveRange_Count_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = false;
        for (int i = index + count - 1; i >= index; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void set(int index, Mesh mesh) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mesh == null) {
            String string = InternalResource.loadString("set", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = mesh.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        if (material != null) {
            l2 = mesh.getHandle();
        }
        MeshesNative.jni_Set(this.getHandle(), index, l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive(mesh);
        this.a.set(index, mesh);
    }

    public Mesh[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toArray", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.a.size();
        Mesh[] meshArray = new Mesh[n];
        for (int i = 0; i < n; ++i) {
            meshArray[i] = new Mesh(this.get(i));
        }
        return meshArray;
    }
}

