/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.LinkItem;
import com.supermap.data.LinkItemsNative;
import java.util.ArrayList;

public class LinkItems
extends InternalHandleDisposable {
    private ArrayList<LinkItem> a = null;

    public LinkItems() {
        this.a = new ArrayList();
        this.setHandle(LinkItemsNative.jni_New(), true);
    }

    public LinkItems(LinkItem[] linkItems) {
        this();
        for (int i = 0; i < linkItems.length; ++i) {
            this.add(linkItems[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
    }

    public LinkItems(LinkItems linkItems) {
        if (linkItems == null) {
            String string = InternalResource.loadString("linkItems", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (linkItems.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = LinkItemsNative.jni_Clone(linkItems.getHandle());
        this.a = new ArrayList();
        this.setHandle(l, true);
        int n = linkItems.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(linkItems.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
    }

    LinkItems(long handle) {
        this.a = new ArrayList();
        this.setHandle(handle, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public LinkItem get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public void set(int index, LinkItem value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        LinkItemsNative.jni_Set(this.get(index).getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public LinkItems clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new LinkItems(this);
    }

    public int add(LinkItem linkItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItem", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = LinkItemsNative.jni_Add(this.getHandle(), linkItem.getHandle());
        if (n != -1) {
            long l = LinkItemsNative.jni_Get(this.getHandle(), n);
            LinkItem linkItem2 = new LinkItem(l);
            this.a.add(linkItem2);
            this.refreshHandle();
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return this.getCount() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
        return -1;
    }

    public int addRange(LinkItem[] linkItems) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = linkItems.length;
        for (n = 0; n < n3; ++n) {
            LinkItem linkItem = linkItems[n];
            if (linkItem == null) {
                String string = InternalResource.loadString("linkItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (linkItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("linkItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(linkItems[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
        return n2;
    }

    public boolean insert(int index, LinkItem linkItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, LinkItem linkItem)", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index == this.getCount()) {
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return this.add(linkItem) != -1;
        }
        long l = LinkItemsNative.jni_Insert(this.getHandle(), index, linkItem.getHandle());
        if (l == 0L) {
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return false;
        }
        LinkItem linkItem2 = new LinkItem(l);
        this.a.add(index, linkItem2);
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
        return true;
    }

    public int insertRange(int index, LinkItem[] linkItems) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = linkItems.length;
        for (n = 0; n < n2; ++n) {
            LinkItem linkItem = linkItems[n];
            if (linkItem == null) {
                String string = InternalResource.loadString("linkItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (linkItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("linkItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl = this.insert(index + n, linkItems[i]);
            if (!bl) continue;
            ++n;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        LinkItemsNative.jni_Remove(this.getHandle(), index);
        LinkItem linkItem = this.get(index);
        linkItem.clearHandle();
        this.a.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (count < 0 || count > this.getCount() - index) {
            String string = InternalResource.loadString("count", "LinkItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = false;
        for (int i = index + count - 1; i >= index; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public LinkItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.a.size();
        LinkItem[] linkItemArray = new LinkItem[n];
        for (int i = 0; i < n; ++i) {
            linkItemArray[i] = new LinkItem(this.get(i));
        }
        return linkItemArray;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            LinkItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                LinkItem linkItem = this.get(i);
                linkItem.clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected void refreshHandle() {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            LinkItem linkItem = this.a.get(i);
            linkItem.clearHandle();
            long l = LinkItemsNative.jni_Get(this.getHandle(), i);
            this.a.get(i).refreshHandle(l);
        }
    }
}

