/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AggregatePolygonParameter;
import com.supermap.data.CalibrateMode;
import com.supermap.data.DividePolygonParameter;
import com.supermap.data.Environment;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoCurvePolygon;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineM;
import com.supermap.data.GeoMultiSurface;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeodesicLineParameter;
import com.supermap.data.GeometristNative;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.PointM;
import com.supermap.data.PointMs;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.RegularizeParameter;
import com.supermap.data.ResampleType;
import com.supermap.data.SpatialRelationType;
import com.supermap.data.Unit;
import com.supermap.data.WhereToCalibrate;
import com.supermap.data.c;
import java.util.ArrayList;

public class Geometrist {
    private Geometrist() {
    }

    public static boolean isIdentical(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != geometryTarget.getType()) {
            String string = InternalResource.loadString("geometrySearch and geomettyTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsIdentical(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean isIdentical(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != geometryTarget.getType()) {
            String string = InternalResource.loadString("geometrySearch and geomettyTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsIdentical(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean isDisjointed(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsDisjointed(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean isDisjointed(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsDisjointed(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasIntersection(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != GeometryType.GEOREGION && geometryTarget.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasIntersection(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasIntersection(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != GeometryType.GEOREGION && geometryTarget.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasIntersection(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasTouch(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() == GeometryType.GEOPOINT && geometryTarget.getType() == GeometryType.GEOPOINT) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasTouch(geometrySearch.getHandle(), geometryTarget.getHandle(), 1.0E-9);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasTouch(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() == GeometryType.GEOPOINT && geometryTarget.getType() == GeometryType.GEOPOINT) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasTouch(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasOverlap(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != geometryTarget.getType()) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasOverlap(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasOverlap(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != geometryTarget.getType()) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasOverlap(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasCross(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCross(geometrySearch.getHandle(), geometryTarget.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean isWithin(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() == GeometryType.GEOPOINT) {
            if (geometryTarget.getType() != GeometryType.GEOPOINT && geometryTarget.getType() != GeometryType.GEOLINE && geometryTarget.getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (geometrySearch.getType() == GeometryType.GEOLINE) {
            if (geometryTarget.getType() != GeometryType.GEOLINE && geometryTarget.getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (geometryTarget.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsWithin(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean isWithin(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() == GeometryType.GEOPOINT) {
            if (geometryTarget.getType() != GeometryType.GEOPOINT && geometryTarget.getType() != GeometryType.GEOLINE && geometryTarget.getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (geometrySearch.getType() == GeometryType.GEOLINE) {
            if (geometryTarget.getType() != GeometryType.GEOLINE && geometryTarget.getType() != GeometryType.GEOREGION) {
                String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (geometryTarget.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsWithin(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean canContain(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_CanContain(geometrySearch.getHandle(), geometryTarget.getHandle(), 0.0);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean canContain(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_CanContain(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasCommonPoint(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCommonPoint(geometrySearch.getHandle(), geometryTarget.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static boolean hasCommonLine(Geometry geometrySearch, Geometry geometryTarget) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCommonLine(geometrySearch.getHandle(), geometryTarget.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static Geometry clip(Geometry geometry, Geometry clipGeometry) {
        return Geometrist.clip(geometry, clipGeometry, 1.0E-10);
    }

    public static Geometry clip(Geometry geometry, Geometry clipGeometry, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipGeometry == null || clipGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(clipGeometry, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Clip(geometry.getHandle(), clipGeometry.getHandle(), tolerance);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(clipGeometry);
        return geometry2;
    }

    public static Geometry clip(Geometry geometry, Rectangle2D clipRectangle) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipRectangle == null) {
            String string = InternalResource.loadString("clipRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipRectangle.isEmpty()) {
            String string = InternalResource.loadString("clipRectangle", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ClipRect(geometry.getHandle(), clipRectangle.getLeft(), clipRectangle.getTop(), clipRectangle.getRight(), clipRectangle.getBottom());
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static boolean hasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasHollow(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Deprecated
    public static boolean HasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasHollow(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public static Geometry intersect(Geometry geometry1, Geometry geometry2) {
        return Geometrist.intersect(geometry1, geometry2, 1.0E-10);
    }

    public static Geometry intersect(Geometry geometry1, Geometry geometry2, double tolerance) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Intersect(geometry1.getHandle(), geometry2.getHandle(), tolerance);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry;
    }

    public static Geometry erase(Geometry geometry, Geometry eraseGeometry) {
        return Geometrist.erase(geometry, eraseGeometry, 1.0E-10);
    }

    public static Geometry erase(Geometry geometry, Geometry eraseGeometry, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (eraseGeometry == null || eraseGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(eraseGeometry, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Erase(geometry.getHandle(), eraseGeometry.getHandle(), tolerance);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(eraseGeometry);
        return geometry2;
    }

    private static Geometry a(Geometry geometry) {
        if (geometry != null && geometry.getType() == GeometryType.GEOLINE) {
            int n = ((GeoLine)geometry).getPartCount();
            GeoLineM geoLineM = new GeoLineM();
            for (int i = 0; i < n; ++i) {
                Point2Ds point2Ds = ((GeoLine)geometry).getPart(i);
                PointM[] pointMArray = new PointM[point2Ds.getCount()];
                for (int j = 0; j < pointMArray.length; ++j) {
                    pointMArray[j] = new PointM();
                    pointMArray[j].setX(point2Ds.getItem((int)j).x);
                    pointMArray[j].setY(point2Ds.getItem((int)j).y);
                    pointMArray[j].setM(0.0);
                }
                geoLineM.addPart(new PointMs(pointMArray));
            }
            return geoLineM;
        }
        return null;
    }

    public static Geometry union(Geometry geometry1, Geometry geometry2) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry1, GeometryType.GEOREGION, GeometryType.GEOLINE, GeometryType.GEOLINEM, GeometryType.GEOLINE3D, GeometryType.GEOREGION3D)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry2, GeometryType.GEOREGION, GeometryType.GEOLINE, GeometryType.GEOLINEM, GeometryType.GEOLINE3D, GeometryType.GEOREGION3D)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry1.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometry1 and geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry1.getType() == GeometryType.GEOLINEM) {
            if (((GeoLineM)geometry1).getPartCount() > 1 || ((GeoLineM)geometry2).getPartCount() > 1) {
                String string = InternalResource.loadString("geometry1 or geometry2", "Only_Support_Simple_Object", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = GeometristNative.jni_Union(((GeoLineM)geometry1).convertToLine().getHandle(), ((GeoLineM)geometry2).convertToLine().getHandle());
            Geometry geometry = null;
            if (l != 0L) {
                geometry = Geometry.createInstance(l);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
            InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
            Geometry geometry3 = null;
            if (geometry != null && (geometry3 = Geometrist.a(geometry)) != null) {
                ((GeoLineM)geometry3).calibrateLineM(((GeoLineM)geometry1).getPart(0), CalibrateMode.BYDISTANCE, true);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
            InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
            return geometry3;
        }
        long l = GeometristNative.jni_Union(geometry1.getHandle(), geometry2.getHandle());
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry;
    }

    public static Geometry union(Geometry geometry1, Geometry geometry2, double tolerance) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry1, GeometryType.GEOREGION, GeometryType.GEOLINE, GeometryType.GEOLINEM, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION, GeometryType.GEOLINE3D, GeometryType.GEOREGION3D)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry2, GeometryType.GEOREGION, GeometryType.GEOLINE, GeometryType.GEOLINEM, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION, GeometryType.GEOLINE3D, GeometryType.GEOREGION3D)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry1.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometry1 and geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry1.getType() == GeometryType.GEOLINEM) {
            if (((GeoLineM)geometry1).getPartCount() > 1 || ((GeoLineM)geometry2).getPartCount() > 1) {
                String string = InternalResource.loadString("geometry1 or geometry2", "Only_Support_Simple_Object", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = GeometristNative.jni_Union(((GeoLineM)geometry1).convertToLine().getHandle(), ((GeoLineM)geometry2).convertToLine().getHandle());
            Geometry geometry = null;
            if (l != 0L) {
                geometry = Geometry.createInstance(l);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
            InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
            Geometry geometry3 = Geometrist.a(geometry);
            if (geometry3 != null) {
                ((GeoLineM)geometry3).calibrateLineM(((GeoLineM)geometry1).getPart(0), CalibrateMode.BYDISTANCE, true);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
            InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
            return geometry3;
        }
        long l = GeometristNative.jni_Union2(geometry1.getHandle(), geometry2.getHandle(), tolerance);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry;
    }

    public static Geometry xOR(Geometry geometry1, Geometry geometry2) {
        return Geometrist.xOR(geometry1, geometry2, 1.0E-10);
    }

    public static Geometry xOR(Geometry geometry1, Geometry geometry2, double tolerance) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry1, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry2, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_XOR(geometry1.getHandle(), geometry2.getHandle(), tolerance);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry;
    }

    public static Geometry update(Geometry geometry, Geometry updateGeometry) {
        return Geometrist.update(geometry, updateGeometry, 1.0E-10);
    }

    public static Geometry update(Geometry geometry, Geometry updateGeometry, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (updateGeometry == null || updateGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(updateGeometry, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Update(geometry.getHandle(), updateGeometry.getHandle(), tolerance);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(updateGeometry);
        return geometry2;
    }

    public static Geometry identity(Geometry geometry, Geometry identityGeometry) {
        return Geometrist.identity(geometry, identityGeometry, 1.0E-10);
    }

    public static Geometry identity(Geometry geometry, Geometry identityGeometry, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (identityGeometry == null || identityGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEEPS, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICLINE, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(identityGeometry, GeometryType.GEOREGION, GeometryType.GEOREGIONEPS, GeometryType.GEOPARAMETRICREGION)) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Identity(geometry.getHandle(), identityGeometry.getHandle(), tolerance);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(identityGeometry);
        return geometry2;
    }

    @Deprecated
    public static Geometry resample(Geometry geometry, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Resample(geometry.getHandle(), tolerance);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static Geometry resample(Geometry geometry, ResampleType resampleType, double tolerance) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOLINEM)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = resampleType.getUGCValue();
        Geometry geometry2 = null;
        if (geometry.getType() == GeometryType.GEOLINEM) {
            if (((GeoLineM)geometry).getPartCount() > 1) {
                String string = InternalResource.loadString("geometry", "Only_Support_Simple_Object", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = GeometristNative.jni_Resample1(((GeoLineM)geometry).convertToLine().getHandle(), n, tolerance);
            if (l != 0L) {
                geometry2 = Geometry.createInstance(l);
            }
            Geometry geometry3 = null;
            if (geometry2 != null && (geometry3 = Geometrist.a(geometry2)) != null) {
                PointMs pointMs = ((GeoLineM)geometry).getPart(0);
                int n2 = ((GeoLineM)geometry3).getPart(0).getCount();
                ((GeoLineM)geometry3).updateM(0, n2 - 1, pointMs.getItem(0).getM(), pointMs.getItem(pointMs.getCount() - 1).getM(), WhereToCalibrate.ALLLINE, CalibrateMode.BYDISTANCE);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(geometry);
            return geometry3;
        }
        long l = GeometristNative.jni_Resample1(geometry.getHandle(), n, tolerance);
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static double distance(Geometry geometry1, Geometry geometry2) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeometristNative.jni_Distance(geometry1.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return d2;
    }

    public static Point2Ds closestPoint(Geometry geometry1, Geometry geometry2) {
        if (geometry1 == null || geometry1.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = GeometristNative.jni_ClosestPoint(geometry1.getHandle(), geometry2.getHandle());
        Point2Ds point2Ds = new Point2Ds();
        InternalHandleDisposable.makeSureNativeObjectLive(geometry1);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        if (dArray == null) {
            String string = InternalResource.loadString("closestPoint", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string + "\uff0c\u672a\u627e\u5230\u6ee1\u8db3\u8981\u6c42\u7684\u6700\u8fd1\u70b9\u3002\u8bf7\u68c0\u67e5\u4e24\u5bf9\u8c61\u662f\u5426\u76f8\u4ea4/\u5305\u542b/\u88ab\u5305\u542b\u3002");
        }
        point2Ds.add(new Point2D(dArray[0], dArray[1]));
        point2Ds.add(new Point2D(dArray[2], dArray[3]));
        InternalHandleDisposable.makeSureNativeObjectLive(point2Ds);
        return point2Ds;
    }

    public static GeoRegion computeConvexHull(Point2Ds points) {
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        long l = GeometristNative.jni_ComputeConvexHullPoints(dArray, dArray2, n);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion computeConvexHull(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeConvexHull(geometry.getHandle());
        Geometry geometry2 = null;
        geometry2 = l != 0L ? Geometry.createInstance(l) : Geometry.createInstance(geometry.getType());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return (GeoRegion)geometry2;
    }

    public static boolean splitRegion(GeoRegion soureRegion, Geometry splitGeometry, GeoRegion targetGeoRegion1, GeoRegion targetGeoRegion2) {
        if (soureRegion == null || soureRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry == null || splitGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetGeoRegion1 == null || targetGeoRegion1.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetGeoRegion2 == null || targetGeoRegion2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(soureRegion, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(splitGeometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(targetGeoRegion1, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(targetGeoRegion2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry.getType().equals(GeometryType.GEOPOINT)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_SplitRegion(soureRegion.getHandle(), splitGeometry.getHandle(), targetGeoRegion1.getHandle(), targetGeoRegion2.getHandle());
        if (bl) {
            targetGeoRegion1.b();
            targetGeoRegion2.b();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(soureRegion);
        InternalHandleDisposable.makeSureNativeObjectLive(splitGeometry);
        InternalHandleDisposable.makeSureNativeObjectLive(targetGeoRegion1);
        InternalHandleDisposable.makeSureNativeObjectLive(targetGeoRegion2);
        return bl;
    }

    public static GeoArc computeFillet(Point2D startPoint1, Point2D endPoint1, Point2D startPoint2, Point2D endPoint2, double radius) {
        if (radius <= 0.0) {
            String string = InternalResource.loadString("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeFillet(startPoint1.getX(), startPoint1.getY(), endPoint1.getX(), endPoint1.getY(), startPoint2.getX(), startPoint2.getY(), endPoint2.getX(), endPoint2.getY(), radius);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoArc)geometry;
    }

    public static boolean isParallel(Point2D startPoint1, Point2D endPoint1, Point2D startPoint2, Point2D endPoint2) {
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsParallel(startPoint1.getX(), startPoint1.getY(), endPoint1.getX(), endPoint1.getY(), startPoint2.getX(), startPoint2.getY(), endPoint2.getX(), endPoint2.getY());
    }

    public static GeoLine computeParallel(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(startPoint);
        point2Ds.add(endPoint);
        GeoLine geoLine = new GeoLine(point2Ds);
        if (!Geometrist.isPointOnLine(point, startPoint, endPoint, true)) {
            geoLine = Geometrist.computePerpendicular(point, startPoint, endPoint);
            geoLine.rotate(point, -90.0);
        }
        return geoLine;
    }

    public static GeoLine computeParallel(GeoLine geoLine, double distance) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeParallel(geoLine.getHandle(), distance);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        return (GeoLine)geometry;
    }

    public static boolean isPerpendicular(Point2D startPoint1, Point2D endPoint1, Point2D startPoint2, Point2D endPoint2) {
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPerpendicular(startPoint1.getX(), startPoint1.getY(), endPoint1.getX(), endPoint1.getY(), startPoint2.getX(), startPoint2.getY(), endPoint2.getX(), endPoint2.getY());
    }

    public static GeoLine computePerpendicular(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (Geometrist.isPointOnLine(point, startPoint, endPoint, true)) {
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(startPoint);
            point2Ds.add(endPoint);
            GeoLine geoLine = new GeoLine(point2Ds);
            geoLine.rotate(point, 90.0);
            return geoLine;
        }
        Point2D point2D = Geometrist.computePerpendicularPosition(point, startPoint, endPoint);
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point);
        point2Ds.add(point2D);
        GeoLine geoLine = new GeoLine(point2Ds);
        return geoLine;
    }

    public static Point2D computePerpendicularPosition(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        GeometristNative.jni_ComputePerpendicularPosition(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public static boolean isPointOnLine(Point2D point, Point2D startPoint, Point2D endPoint, boolean isExtended) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLine(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY(), isExtended);
    }

    public static Point2D intersectLine(Point2D startPoint1, Point2D endPoint1, Point2D startPoint2, Point2D endPoint2, boolean isExtended) {
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl = GeometristNative.jni_IntersectLine(startPoint1.getX(), startPoint1.getY(), endPoint1.getX(), endPoint1.getY(), startPoint2.getX(), startPoint2.getY(), endPoint2.getX(), endPoint2.getY(), isExtended, dArray);
        if (bl) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public static double computeGeodesicDistance(Point2Ds points, double majorAxis, double flatten) {
        if (points.getCount() < 2) {
            String string = InternalResource.loadString("points", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (majorAxis <= 0.0) {
            String string = InternalResource.loadString("majorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (flatten < 0.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (flatten >= 1.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[points.getCount()];
        double[] dArray2 = new double[points.getCount()];
        if (points.b() == Point2Ds.a.c) {
            Point2D[] point2DArray = points.a();
            for (int i = 0; i < point2DArray.length; ++i) {
                dArray[i] = point2DArray[i].getX();
                dArray2[i] = point2DArray[i].getY();
            }
        } else {
            for (int i = 0; i < points.getCount(); ++i) {
                dArray[i] = points.getItem(i).getX();
                dArray2[i] = points.getItem(i).getY();
            }
        }
        return GeometristNative.jni_ComputeGeodesicDistance(dArray, dArray2, majorAxis, flatten);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double computeGeodesicArea(Geometry geometry, PrjCoordSys prjCoordSys) {
        long l;
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION) {
            Geometry geometry2;
            if (geometry.getType() == GeometryType.GEOCURVEPOLYGON) {
                geometry2 = new GeoCurvePolygon(geometry.getHandle());
                l = ((GeoCurvePolygon)geometry2).convertToRegion().getHandle();
            } else {
                if (geometry.getType() != GeometryType.GEOMULTISURFACE) {
                    String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                geometry2 = new GeoMultiSurface(geometry.getHandle());
                l = ((GeoMultiSurface)geometry2).convertToGeoRegion(0).getHandle();
            }
        } else {
            l = geometry.getHandle();
        }
        double d2 = GeometristNative.jni_ComputeGeodesicArea(l, prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d2;
    }

    public static double computeLength(GeoLine3D line3D, PrjCoordSys prjCoordSys) {
        if (line3D == null || line3D.getHandle() == 0L) {
            String string = InternalResource.loadString("line3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeometristNative.jni_ComputeLength(line3D.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(line3D);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d2;
    }

    public static Point2D[] intersectPolyLine(Point2Ds points1, Point2Ds points2) {
        int n = points1.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("points1", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = points2.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points2", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points1.getItem(i).getX();
            dArray2[i] = points1.getItem(i).getY();
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = points2.getItem(i).getX();
            dArray4[i] = points2.getItem(i).getY();
        }
        double[][] dArray5 = GeometristNative.jni_IntersectPolyLine(dArray, dArray2, n, dArray3, dArray4, n2);
        if (dArray5 == null) {
            return null;
        }
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        Point2D[] point2DArray = new Point2D[dArray6.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = new Point2D();
            point2D.setX(dArray6[i]);
            point2D.setY(dArray7[i]);
            point2DArray[i] = point2D;
        }
        return point2DArray;
    }

    public static Point2Ds smooth(Point2Ds points, int smoothness) {
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < 4) {
            String string = InternalResource.loadString("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (smoothness < 2) {
            String string = InternalResource.loadString("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(points);
        InternalHandleDisposable.setIsDisposable(geoLine, false);
        long l = geoLine.getHandle();
        long l2 = GeometristNative.jni_Smooth(l, smoothness);
        Point2Ds point2Ds = null;
        if (l2 != 0L) {
            GeoLine geoLine2 = new GeoLine(l2);
            int n = geoLine2.getPart(0).getCount();
            Point2D[] point2DArray = new Point2D[n];
            for (int i = 0; i < n; ++i) {
                Point2D point2D;
                point2DArray[i] = point2D = geoLine2.getPart(0).getItem(i);
            }
            point2Ds = new Point2Ds(point2DArray);
            InternalHandleDisposable.setIsDisposable(geoLine2, true);
            geoLine2.dispose();
        }
        return point2Ds;
    }

    public static PointMs smooth(PointMs points, int smoothness) {
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < 4) {
            String string = InternalResource.loadString("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (smoothness < 2) {
            String string = InternalResource.loadString("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points != null && points.getCount() != 0 && smoothness >= 0) {
            Point2Ds point2Ds = new Point2Ds();
            for (int i = 0; i < points.getCount(); ++i) {
                point2Ds.add(new Point2D(points.getItem(i).getX(), points.getItem(i).getY()));
            }
            Point2Ds point2Ds2 = Geometrist.smooth(point2Ds, smoothness);
            if (point2Ds2 != null) {
                PointM[] pointMArray = new PointM[point2Ds2.getCount()];
                for (int i = 0; i < point2Ds2.getCount(); ++i) {
                    pointMArray[i] = new PointM(point2Ds2.getItem((int)i).x, point2Ds2.getItem((int)i).y, 0.0);
                }
                GeoLineM geoLineM = new GeoLineM(new PointMs(pointMArray));
                geoLineM.updateM(0, pointMArray.length - 1, points.getItem(0).getM(), points.getItem(points.getCount() - 1).getM(), WhereToCalibrate.ALLLINE, CalibrateMode.BYDISTANCE);
                return geoLineM.getPart(0);
            }
        }
        return null;
    }

    public static GeoLine[] splitLine(GeoLine sourceLine, Geometry splitGeometry, double tolerance) {
        if (sourceLine == null || sourceLine.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry == null || splitGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(sourceLine, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(splitGeometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry.getType().equals(GeometryType.GEOPOINT) && tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeometristNative.jni_SplitLine(sourceLine.getHandle(), splitGeometry.getHandle(), tolerance);
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)Geometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(sourceLine);
        InternalHandleDisposable.makeSureNativeObjectLive(splitGeometry);
        return geoLineArray;
    }

    public static GeoLineM[] splitLineM(GeoLineM sourceLineM, Geometry splitGeometry, double tolerance) {
        int n;
        if (sourceLineM == null || sourceLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry == null || splitGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(splitGeometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitGeometry.getType().equals(GeometryType.GEOPOINT) && tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = sourceLineM.convertToLine();
        long[] lArray = GeometristNative.jni_SplitLine(geoLine.getHandle(), splitGeometry.getHandle(), tolerance);
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            geoLineArray[i] = (GeoLine)Geometry.createInstance(lArray[i]);
            n = geoLineArray[i].getPartCount();
            n3 += n;
        }
        GeoLineM[] geoLineMArray = new GeoLineM[n3];
        n = 0;
        int n4 = 0;
        PointMs pointMs = sourceLineM.getPart(0);
        for (int i = 0; i < n2; ++i) {
            int n5 = geoLineArray[i].getPartCount();
            for (int j = 0; j < n5; ++j) {
                GeoLineM geoLineM;
                PointM[] pointMArray;
                Point2Ds point2Ds = geoLineArray[i].getPart(j);
                ArrayList<PointM> arrayList = new ArrayList<PointM>();
                double d2 = sourceLineM.getMAtPoint(point2Ds.getItem(0), tolerance, true);
                PointM pointM = new PointM(point2Ds.getItem((int)0).x, point2Ds.getItem((int)0).y, d2);
                arrayList.add(pointM);
                boolean bl = false;
                boolean bl2 = false;
                for (n = 1; n < pointMs.getCount() - 1; ++n) {
                    if (!bl && point2Ds.getItem((int)1).x == pointMs.getItem(n).getX() && point2Ds.getItem((int)1).y == pointMs.getItem(n).getY()) {
                        arrayList.add(pointMs.getItem(n));
                        bl = true;
                        continue;
                    }
                    if (bl && point2Ds.getItem((int)(point2Ds.getCount() - 2)).x == pointMs.getItem(n).getX() && point2Ds.getItem((int)(point2Ds.getCount() - 2)).y == pointMs.getItem(n).getY()) {
                        arrayList.add(pointMs.getItem(n));
                        bl2 = true;
                        break;
                    }
                    if (!bl) continue;
                    arrayList.add(pointMs.getItem(n));
                }
                if (bl && !bl2) {
                    pointMArray = new ArrayList();
                    pointMArray.add(arrayList.get(0));
                    pointMArray.add(arrayList.get(1));
                    arrayList.clear();
                    arrayList = pointMArray;
                }
                if (arrayList.toArray().length < 3 && point2Ds.getItem((int)(point2Ds.getCount() - 1)).x == pointMs.getItem(pointMs.getCount() - 1).getX() && point2Ds.getItem((int)(point2Ds.getCount() - 1)).y == pointMs.getItem(pointMs.getCount() - 1).getY()) {
                    arrayList.add(pointMs.getItem(pointMs.getCount() - 1));
                } else if (bl2 && n + 1 < pointMs.getCount() && point2Ds.getItem((int)(point2Ds.getCount() - 1)).x == pointMs.getItem(n + 1).getX() && point2Ds.getItem((int)(point2Ds.getCount() - 1)).y == pointMs.getItem(n + 1).getY()) {
                    arrayList.add(pointMs.getItem(n + 1));
                } else {
                    double d3 = sourceLineM.getMAtPoint(point2Ds.getItem(point2Ds.getCount() - 1), tolerance, true);
                    PointM pointM2 = new PointM(point2Ds.getItem((int)(point2Ds.getCount() - 1)).x, point2Ds.getItem((int)(point2Ds.getCount() - 1)).y, d3);
                    arrayList.add(pointM2);
                }
                pointMArray = new PointM[arrayList.toArray().length];
                for (int k = 0; k < pointMArray.length; ++k) {
                    pointMArray[k] = (PointM)arrayList.get(k);
                }
                geoLineMArray[n4] = geoLineM = new GeoLineM(new PointMs(pointMArray));
                ++n4;
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive(sourceLineM);
        InternalHandleDisposable.makeSureNativeObjectLive(splitGeometry);
        return geoLineMArray;
    }

    public static boolean isLeft(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsLeft(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    public static boolean isRight(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsRight(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    public static boolean isOnSameSide(Point2D point1, Point2D point2, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsOnSameSide(point1.getX(), point1.getY(), point2.getX(), point2.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY()) == 1;
    }

    public static boolean isProjectOnLineSegment(Point2D point, Point2D startPoint, Point2D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsProjectOnLineSegment(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    public static double distanceToLineSegment(Point2D point, Point2D startPoint, Point2D endPoint) {
        return GeometristNative.jni_DistanceToLineSegment(point.getX(), point.getY(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
    }

    public static Point2D nearestPointToVertex(Point2D vertex, Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl = GeometristNative.jni_NearestPointToVertex(vertex.getX(), vertex.getY(), geometry.getHandle(), dArray);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (!bl) {
            return Point2D.getEMPTY();
        }
        return new Point2D(dArray[0], dArray[1]);
    }

    public static Point3D intersectLineSegment(Point3D startPoint1, Point3D endPoint1, Point3D startPoint2, Point3D endPoint2, double tolerance) {
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[]{startPoint1.getX(), startPoint1.getY(), startPoint1.getZ()};
        double[] dArray3 = new double[]{endPoint1.getX(), endPoint1.getY(), endPoint1.getZ()};
        double[] dArray4 = new double[]{startPoint2.getX(), startPoint2.getY(), startPoint2.getZ()};
        double[] dArray5 = new double[]{endPoint2.getX(), endPoint2.getY(), endPoint2.getZ()};
        boolean bl = GeometristNative.jni_IntersectLineSegment3D(dArray2, dArray3, dArray4, dArray5, dArray, tolerance);
        if (!bl) {
            return Point3D.getEMPTY();
        }
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static boolean isPointOnLineSegment(Point3D point, Point3D startPoint, Point3D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLineSegment3D(point.getX(), point.getY(), point.getZ(), startPoint.getX(), startPoint.getY(), startPoint.getZ(), endPoint.getX(), endPoint.getY(), endPoint.getZ());
    }

    public static boolean isProjectOnLineSegment(Point3D point, Point3D startPoint, Point3D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsProjectOnLineSegment3D(point.getX(), point.getY(), point.getZ(), startPoint.getX(), startPoint.getY(), startPoint.getZ(), endPoint.getX(), endPoint.getY(), endPoint.getZ());
    }

    public static Point3D computePerpendicularPosition(Point3D point, Point3D startPoint, Point3D endPoint) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        GeometristNative.jni_ComputePerpendicularPosition3D(point.getX(), point.getY(), point.getZ(), startPoint.getX(), startPoint.getY(), startPoint.getZ(), endPoint.getX(), endPoint.getY(), endPoint.getZ(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static double distanceToLineSegment(Point3D point, Point3D startPoint, Point3D endPoint) {
        return GeometristNative.jni_DistanceToLineSegment3D(point.getX(), point.getY(), point.getZ(), startPoint.getX(), startPoint.getY(), startPoint.getZ(), endPoint.getX(), endPoint.getY(), endPoint.getZ());
    }

    private static boolean a(Geometry geometry, GeometryType ... geometryTypeArray) {
        boolean bl = false;
        for (GeometryType geometryType : geometryTypeArray) {
            bl = bl || geometry.getType() == geometryType;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public static GeoRegion computeConcaveHull(Point2Ds points, double angle) {
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (angle <= 0.0 || angle >= 180.0) {
            String string = InternalResource.loadString("angle", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        long l = GeometristNative.jni_ComputeConcaveHullPoints(dArray, dArray2, n, angle);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion[] aggregatePointsToRegions(Point2Ds points, PrjCoordSys prjCoordSys, double distance, Unit unit, int minPilePointCount) {
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (minPilePointCount < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < minPilePointCount) {
            String string = InternalResource.loadString("minPilePointCount", "PointsCountMustLargerThanMinPilePointCount", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (distance <= 0.0) {
            String string = InternalResource.loadString("distance", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (prjCoordSys != null && prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys != null) {
            l = prjCoordSys.getHandle();
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        long[] lArray = GeometristNative.jni_AggregatePoints(dArray, dArray2, n, distance, l, unit.value(), minPilePointCount);
        if (lArray != null) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = (GeoRegion)GeoRegion.createInstance(lArray[i]);
            }
            return geoRegionArray;
        }
        return null;
    }

    public static int[] aggregatePoints(Point2Ds points, PrjCoordSys prjCoordSys, double distance, Unit unit, int minPilePointCount) {
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (minPilePointCount < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < minPilePointCount) {
            String string = InternalResource.loadString("minPilePointCount", "PointsCountMustLargerThanMinPilePointCount", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (distance <= 0.0) {
            String string = InternalResource.loadString("distance", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (prjCoordSys != null && prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys != null) {
            l = prjCoordSys.getHandle();
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        int[] nArray = GeometristNative.jni_AggregatePoints2(dArray, dArray2, n, distance, l, unit.value(), minPilePointCount);
        return nArray;
    }

    public static GeoRegion[] dividePolygon(GeoRegion dividedPolygon, DividePolygonParameter parameter, PrjCoordSys prjCoordSys) {
        if (dividedPolygon == null || dividedPolygon.getHandle() == 0L) {
            String string = InternalResource.loadString("dividedPolygon", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        c c2 = new c(parameter);
        long l = 0L;
        if (prjCoordSys != null) {
            l = prjCoordSys.getHandle();
        }
        long l2 = c2.getHandle();
        long[] lArray = null;
        String[] stringArray = new String[1];
        lArray = GeometristNative.jni_DivideRegion(dividedPolygon.getHandle(), l2, l, stringArray);
        c2.dispose();
        if (lArray != null && lArray.length > 0) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = (GeoRegion)GeoRegion.createInstance(lArray[i]);
            }
            return geoRegionArray;
        }
        if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return null;
    }

    public static GeoLine computeGeodesicLine(Point2D startPoint, Point2D endPoint, GeodesicLineParameter parameter) {
        if (startPoint.equals(endPoint)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = parameter.getLineType().value();
        int n2 = parameter.getSemicircleSegment();
        if (n2 < 1) {
            String string = InternalResource.loadString("parameter.getSemicircleSegment", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (parameter.getPrjCoordSys() != null) {
            l = parameter.getPrjCoordSys().getHandle();
        }
        String[] stringArray = new String[1];
        long l2 = GeometristNative.jni_ComputeGeodesicLine(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY(), n, n2, l, stringArray);
        if (l2 != 0L) {
            GeoLine geoLine = (GeoLine)GeoLine.createInstance(l2);
            return geoLine;
        }
        if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return null;
    }

    public static GeoLine computeGeodesicLine(Point2D startPoint, double angle, double distance, GeodesicLineParameter parameter) {
        if (distance <= 0.0) {
            String string = InternalResource.loadString("distance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = parameter.getLineType().value();
        int n2 = parameter.getSemicircleSegment();
        if (n2 < 1) {
            String string = InternalResource.loadString("parameter.getSemicircleSegment", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (parameter.getPrjCoordSys() != null) {
            l = parameter.getPrjCoordSys().getHandle();
        }
        String[] stringArray = new String[1];
        long l2 = GeometristNative.jni_ComputeGeodesicLine2(startPoint.getX(), startPoint.getY(), angle, distance, n, n2, l, stringArray);
        if (l2 != 0L) {
            GeoLine geoLine = (GeoLine)GeoLine.createInstance(l2);
            return geoLine;
        }
        if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return null;
    }

    public static boolean isSegmentIntersect(Point2D startPoint1, Point2D endPoint1, Point2D startPoint2, Point2D endPoint2) {
        if (startPoint1 == null) {
            String string = InternalResource.loadString("startPoint1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (endPoint1 == null) {
            String string = InternalResource.loadString("startPoint1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2 == null) {
            String string = InternalResource.loadString("startPoint1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (endPoint2 == null) {
            String string = InternalResource.loadString("startPoint1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint1.equals(endPoint1)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint2.equals(endPoint2)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsSegmentIntersect(startPoint1.getX(), startPoint1.getY(), endPoint1.getX(), endPoint1.getY(), startPoint2.getX(), startPoint2.getY(), endPoint2.getX(), endPoint2.getY());
        return bl;
    }

    public static int[] geometriesContain(Geometry[] sourceGeometries, Geometry[] targetGeometries, boolean isBorderInside, double dTolerance, boolean isInverseIndexs) {
        if (isInverseIndexs) {
            return Geometrist.a(sourceGeometries, targetGeometries, SpatialRelationType.CONTAIN, isBorderInside, dTolerance);
        }
        return Geometrist.a(targetGeometries, sourceGeometries, SpatialRelationType.WITHIN, isBorderInside, dTolerance);
    }

    public static int[] geometriesWithin(Geometry[] sourceGeometries, Geometry[] targetGeometries, boolean isBorderInside, double dTolerance, boolean isInverseIndexs) {
        if (isInverseIndexs) {
            return Geometrist.a(sourceGeometries, targetGeometries, SpatialRelationType.WITHIN, isBorderInside, dTolerance);
        }
        return Geometrist.a(targetGeometries, sourceGeometries, SpatialRelationType.CONTAIN, isBorderInside, dTolerance);
    }

    public static int[] geometriesIntersect(Geometry[] sourceGeometries, Geometry[] targetGeometries, boolean isBorderInside, double dTolerance, boolean isInverseIndexs) {
        if (isInverseIndexs) {
            return Geometrist.a(sourceGeometries, targetGeometries, SpatialRelationType.INTERSECT, isBorderInside, dTolerance);
        }
        return Geometrist.a(targetGeometries, sourceGeometries, SpatialRelationType.INTERSECT, isBorderInside, dTolerance);
    }

    private static int[] a(Geometry[] geometryArray, Geometry[] geometryArray2, SpatialRelationType spatialRelationType, boolean bl, double d2) {
        if (geometryArray == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray2 == null) {
            String string = InternalResource.loadString("targetGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray.length == 0) {
            String string = InternalResource.loadString("sourceGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray2.length == 0) {
            String string = InternalResource.loadString("targetGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray[0] == null) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray2[0] == null) {
            String string = InternalResource.loadString("targetGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometryArray[0].getType();
        if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType2 = geometryArray2[0].getType();
        if (geometryType2 != GeometryType.GEOPOINT && geometryType2 != GeometryType.GEOLINE && geometryType2 != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("targetGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[geometryArray.length];
        for (int i = 0; i < geometryArray.length; ++i) {
            Geometry geometry = geometryArray[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
        }
        long[] lArray2 = new long[geometryArray2.length];
        for (int i = 0; i < geometryArray2.length; ++i) {
            Geometry geometry = geometryArray2[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("targetGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType2) {
                String string = InternalResource.loadString(String.format("targetGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray2[i] = geometry.getHandle();
        }
        int[] nArray = GeometristNative.jni_GetIndexsByGeoRelation(lArray, lArray2, spatialRelationType.value(), bl, d2);
        return nArray;
    }

    public static int isIntersectRegionWithRect(Geometry geometry, Rectangle2D rectClipper, double dInterval) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectClipper == null) {
            String string = InternalResource.loadString("rectClipper", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectClipper.isEmpty()) {
            String string = InternalResource.loadString("rectClipper", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GeometristNative.jni_isIntersectRegionWithRect(geometry.getHandle(), rectClipper.getLeft(), rectClipper.getTop(), rectClipper.getRight(), rectClipper.getBottom(), dInterval);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return n;
    }

    public static GeoRegion[] resample(GeoRegion[] sourceRegions, ResampleType resampleType, double tolerance) {
        if (sourceRegions == null) {
            String string = InternalResource.loadString("sourceRegions", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRegions.length == 0) {
            String string = InternalResource.loadString("sourceRegions.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRegions[0] == null) {
            String string = InternalResource.loadString("sourceRegions[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[sourceRegions.length];
        for (int i = 0; i < sourceRegions.length; ++i) {
            GeoRegion geoRegion = sourceRegions[i];
            if (geoRegion == null) {
                String string = InternalResource.loadString(String.format("sourceRegions[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geoRegion.getHandle();
        }
        long[] lArray2 = null;
        int n = resampleType.getUGCValue();
        lArray2 = GeometristNative.jni_Resample2(lArray, n, tolerance);
        if (lArray2 != null && lArray2.length > 0) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray2.length];
            for (int i = 0; i < lArray2.length; ++i) {
                geoRegionArray[i] = (GeoRegion)GeoRegion.createInstance(lArray2[i]);
            }
            return geoRegionArray;
        }
        return null;
    }

    public static double getTolerance(PrjCoordSys prjCoordSys) {
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeometristNative.jni_getTolerance(prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d2;
    }

    public static boolean hasAreaIntersection(Geometry geometrySearch, Geometry geometryTarget, double tolerance) {
        if (geometrySearch == null || geometrySearch.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null || geometryTarget.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometrySearch, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(geometryTarget, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometrySearch.getType() != GeometryType.GEOREGION && geometryTarget.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasAreaIntersection(geometrySearch.getHandle(), geometryTarget.getHandle(), tolerance);
        InternalHandleDisposable.makeSureNativeObjectLive(geometrySearch);
        InternalHandleDisposable.makeSureNativeObjectLive(geometryTarget);
        return bl;
    }

    public static Geometry zoom(Geometry sourceGeometry, Point2D centerPoint, double scaleX, double scaleY) {
        if (sourceGeometry == null || sourceGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(sourceGeometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_zoom(sourceGeometry.getHandle(), centerPoint.getX(), centerPoint.y, scaleX, scaleY);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return geometry;
    }

    public static Geometry orthogonalPolygonFitting(Geometry sourceGeometry, double widthThreshold, double heightThreshold) {
        if (sourceGeometry == null || sourceGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(sourceGeometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (widthThreshold <= 0.0) {
            String string = InternalResource.loadString("widthThreshold", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (heightThreshold <= 0.0) {
            String string = InternalResource.loadString("heightThreshold", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_orthogonalPolygonFitting(sourceGeometry.getHandle(), widthThreshold, heightThreshold);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return geometry;
    }

    public static GeoRegion regularizeBuildingFootprint(GeoRegion srcRegion, RegularizeParameter regularizeParameter, PrjCoordSys prjCoordSys) {
        if (srcRegion == null || srcRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(srcRegion, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (regularizeParameter == null || regularizeParameter.getOffsetDistanceUnit() == null) {
            String string = InternalResource.loadString("simplifyParam", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (regularizeParameter.getOffsetDistanceUnit() == null) {
            String string = InternalResource.loadString("offsetDistanceUnit", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = prjCoordSys == null ? GeometristNative.jni_RegularizeBuildingFootprint(srcRegion.getHandle(), regularizeParameter.getOffsetDistance(), regularizeParameter.getOffsetDistanceUnit().value(), regularizeParameter.getMinArea(), regularizeParameter.getMinHoleArea(), regularizeParameter.getRegularizeMethod().value(), 0L) : GeometristNative.jni_RegularizeBuildingFootprint(srcRegion.getHandle(), regularizeParameter.getOffsetDistance(), regularizeParameter.getOffsetDistanceUnit().value(), regularizeParameter.getMinArea(), regularizeParameter.getMinHoleArea(), regularizeParameter.getRegularizeMethod().value(), prjCoordSys.getHandle());
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = (GeoRegion)GeoRegion.createInstance(l);
        }
        return geoRegion;
    }

    public static Point2D[] createRandomPoints(Geometry sourceGeometry, int randomNumber, double minDistance) {
        if (sourceGeometry == null || sourceGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(sourceGeometry, GeometryType.GEOREGION, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("sourceGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (randomNumber <= 0) {
            String string = InternalResource.loadString("randomNumber", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (minDistance < 0.0) {
            String string = InternalResource.loadString("minDistance", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[][] dArray = GeometristNative.jni_CreateRandomPoints(sourceGeometry.getHandle(), randomNumber, minDistance);
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        Point2D[] point2DArray = new Point2D[dArray2.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = new Point2D();
            point2D.setX(dArray2[i]);
            point2D.setY(dArray3[i]);
            point2DArray[i] = point2D;
        }
        return point2DArray;
    }

    public static GeoRegion[] aggregatePolygons(GeoRegion[] sourceRegions, AggregatePolygonParameter param, PrjCoordSys prjCoordSys) {
        GeoRegion[] geoRegionArray;
        if (sourceRegions == null) {
            String string = InternalResource.loadString("sourceRegions", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRegions.length == 0) {
            String string = InternalResource.loadString("sourceRegions.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRegions[0] == null) {
            String string = InternalResource.loadString("sourceRegions[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[sourceRegions.length];
        for (int i = 0; i < sourceRegions.length; ++i) {
            geoRegionArray = sourceRegions[i];
            if (geoRegionArray == null) {
                String string = InternalResource.loadString(String.format("sourceRegions[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geoRegionArray.getHandle();
        }
        long[] lArray2 = null;
        lArray2 = prjCoordSys == null ? GeometristNative.jni_aggregatePolygons(lArray, param.getDistance(), param.getDistanceUnit().value(), param.getMinArea(), param.getMinHoleArea(), 0L) : GeometristNative.jni_aggregatePolygons(lArray, param.getDistance(), param.getDistanceUnit().value(), param.getMinArea(), param.getMinHoleArea(), prjCoordSys.getHandle());
        if (lArray2 != null && lArray2.length > 0) {
            geoRegionArray = new GeoRegion[lArray2.length];
            for (int i = 0; i < lArray2.length; ++i) {
                geoRegionArray[i] = (GeoRegion)GeoRegion.createInstance(lArray2[i]);
            }
            return geoRegionArray;
        }
        return null;
    }

    public static double[] linearFitting(Point2Ds points, int degree) {
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (points.getCount() < 2) {
            String string = InternalResource.loadString("points", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (degree != 1 && degree != 2) {
            String string = InternalResource.loadString("degree", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        double[] dArray3 = GeometristNative.jni_LinearFitting(dArray, dArray2, n, degree);
        return dArray3;
    }

    public static Point2D getCentroid(GeoRegion geoRegion) {
        if (geoRegion == null || geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("getCentroid", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl = GeometristNative.jni_getCentroid(geoRegion.getHandle(), dArray);
        if (bl) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public static GeoRegion[] createStripMapPages(GeoLine srcLine, Geometry[] barrierGeos, double aLengthAlongTheLine, double aLengthPerpendicularToTheLine) {
        int n;
        Object[] objectArray;
        if (srcLine == null || srcLine.getHandle() == 0L) {
            String string = InternalResource.loadString("srcLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.a(srcLine, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("srcLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (aLengthAlongTheLine <= 0.0) {
            throw new IllegalArgumentException("dLengthAlongTheLine :it has to be greater than zero");
        }
        if (aLengthPerpendicularToTheLine <= 0.0) {
            throw new IllegalArgumentException("dLengthPerpendicularToTheLine :it has to be greater than zero");
        }
        long l = srcLine.getHandle();
        long[] lArray = null;
        if (barrierGeos != null && barrierGeos.length > 0) {
            objectArray = new long[barrierGeos.length];
            for (n = 0; n < barrierGeos.length; ++n) {
                Geometry geometry = barrierGeos[n];
                if (geometry == null) {
                    String string = InternalResource.loadString(String.format("sourceRegions[%d]", n), "Global_ArgumentNull", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                objectArray[n] = geometry.getHandle();
            }
            lArray = GeometristNative.jni_createStripMapPages(l, objectArray, aLengthAlongTheLine, aLengthPerpendicularToTheLine);
        } else {
            lArray = GeometristNative.jni_createStripMapPages(l, aLengthAlongTheLine, aLengthPerpendicularToTheLine);
        }
        if (lArray != null && lArray.length > 0) {
            objectArray = new GeoRegion[lArray.length];
            for (n = 0; n < lArray.length; ++n) {
                objectArray[n] = (long)((GeoRegion)GeoRegion.createInstance(lArray[n]));
            }
            return objectArray;
        }
        return null;
    }

    static {
        Environment.LoadWrapJ();
    }
}

