/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoTorusNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoTorus
extends Geometry3D {
    public GeoTorus() {
        long l = GeoTorusNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoTorus(GeoTorus geoTorus) {
        if (geoTorus == null) {
            String string = InternalResource.loadString("GeoTorus", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoTorus.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoTorus", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoTorusNative.jni_Clone(geoTorus.getHandle(), this.getHandle());
    }

    public GeoTorus(Point3D position, double ringRaDius, double pipeRadius) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoTorusNative.jni_New3(dArray, ringRaDius, pipeRadius);
        this.setHandle(l, true);
    }

    @Override
    public GeoTorus clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoTorus(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoTorus", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTorusNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getRingRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRingRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTorusNative.jni_GetRingRadius(this.getHandle());
    }

    public void setRingRadius(double ringRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRingRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTorusNative.jni_SetRingRadius(this.getHandle(), ringRadius);
    }

    public double getPipeRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTorusNative.jni_GetPipeRadius(this.getHandle());
    }

    public void setPipeRadius(double pipeRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTorusNative.jni_SetPipeRadius(this.getHandle(), pipeRadius);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoTorusNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

