/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCircle3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoCircle3D
extends Geometry3D {
    public GeoCircle3D() {
        this.setHandle(GeoCircle3DNative.jni_New(), true);
        this.setRadius(1.0);
    }

    public GeoCircle3D(GeoCircle3D geoCircle) {
        if (geoCircle == null) {
            String string = InternalResource.loadString("GeoCircle3D", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoCircle);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoCircle3D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCircle3DNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCircle);
    }

    public GeoCircle3D(Point3D position, double radius) {
        this();
        this.setPosition(position);
        this.setRadius(radius);
    }

    GeoCircle3D(long handle) {
        this.setHandle(handle, false);
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCircle3DNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("setRadius()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCircle3DNative.jni_SetRadius(this.getHandle(), value);
    }

    @Override
    public GeoCircle3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCircle3D(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCircle3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

