/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetCreatedEvent;
import com.supermap.data.DatasetCreatedListener;
import com.supermap.data.DatasetDeletedAllEvent;
import com.supermap.data.DatasetDeletedAllListener;
import com.supermap.data.DatasetDeletedEvent;
import com.supermap.data.DatasetDeletedListener;
import com.supermap.data.DatasetDeletingAllEvent;
import com.supermap.data.DatasetDeletingAllListener;
import com.supermap.data.DatasetDeletingEvent;
import com.supermap.data.DatasetDeletingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetGridCollectionInfo;
import com.supermap.data.DatasetGridInfo;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageCollectionInfo;
import com.supermap.data.DatasetImageInfo;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetRenamedEvent;
import com.supermap.data.DatasetRenamedListener;
import com.supermap.data.DatasetRenamingEvent;
import com.supermap.data.DatasetRenamingListener;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetTopologyInfo;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.DatasetVectorNative;
import com.supermap.data.DatasetVolume;
import com.supermap.data.DatasetVolumeInfo;
import com.supermap.data.DatasetsNative;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceRefreshedEvent;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class Datasets {
    private transient ReentrantLock h = new ReentrantLock();
    private transient Datasource i = null;
    transient CopyOnWriteArrayList<DatasetRenamingListener> a;
    transient CopyOnWriteArrayList<DatasetRenamedListener> b;
    transient CopyOnWriteArrayList<DatasetDeletingListener> c;
    transient CopyOnWriteArrayList<DatasetDeletedListener> d;
    transient CopyOnWriteArrayList<DatasetDeletingAllListener> e;
    transient CopyOnWriteArrayList<DatasetDeletedAllListener> f;
    transient CopyOnWriteArrayList<DatasetCreatedListener> g;

    protected Datasets() {
    }

    Datasets(Datasource datasource) {
        this.i = datasource;
    }

    public int getCount() {
        if (!this.a()) {
            String string = InternalResource.loadString("getCount()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetsNative.jni_GetSize(this.i.getHandle());
    }

    public Dataset get(String name) {
        if (!this.a()) {
            String string = InternalResource.loadString("get(String name)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetsNative.jni_GetDatasetByName(this.i.getHandle(), name);
        if (l == 0L) {
            return null;
        }
        int n = DatasetNative.jni_GetType(l);
        DatasetType datasetType = this.getJavaDatasetType(n);
        return Dataset.createInstance(l, datasetType, this.i);
    }

    public Dataset get(int index) {
        if (!this.a()) {
            String string = InternalResource.loadString("get(int index)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetsNative.jni_GetDatasetByIndex(this.i.getHandle(), index);
        if (l == 0L) {
            return null;
        }
        int n = DatasetNative.jni_GetType(l);
        DatasetType datasetType = this.getJavaDatasetType(n);
        return Dataset.createInstance(l, datasetType, this.i);
    }

    public Datasource getDatasource() {
        if (!this.a()) {
            String string = InternalResource.loadString("getDatasource()", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector createAndAppendWithSmid(String name, Recordset recordset) {
        this.h.lock();
        try {
            InternalHandle internalHandle;
            if (!this.a()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.i.isReadOnly()) {
                String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (recordset == null) {
                String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            if (recordset.getHandle() == 0L) {
                String string = InternalResource.loadString("recordset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(name, recordset.getDataset());
            if (!Datasets.a(datasetVectorInfo.getType())) {
                String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (!Datasets.a(datasetVectorInfo.getType(), datasetVectorInfo.getEncodeType())) {
                String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVector datasetVector = null;
            if (datasetVectorInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetVectorInfo.getName())) {
                String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
                throw new IllegalArgumentException(string);
            }
            long l = DatasetsNative.jni_CreateDatasetVector(this.i.getHandle(), datasetVectorInfo.getHandle());
            if (l != 0L) {
                datasetVector = new DatasetVector(l, this.i);
                datasetVector.setPrjCoordSys(recordset.getDataset().getPrjCoordSys());
                internalHandle = recordset.getFieldInfos();
                for (int i = 0; i < ((FieldInfos)internalHandle).getCount(); ++i) {
                    if (((FieldInfos)internalHandle).get(i).isSystemField() || ((FieldInfos)internalHandle).get(i).getName().equalsIgnoreCase("SmUserID")) continue;
                    datasetVector.getFieldInfos().add(((FieldInfos)internalHandle).get(i));
                }
                DatasetVectorNative.jni_AppendWithSmID(datasetVector.getHandle(), recordset.getHandle());
                this.a(datasetVector);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(datasetVectorInfo);
            internalHandle = datasetVector;
            return internalHandle;
        }
        finally {
            this.h.unlock();
        }
    }

    public DatasetVector create(DatasetVectorInfo datasetInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType(), datasetInfo.getEncodeType())) {
            String string = InternalResource.loadString("value", "DatasetVectorInfo_IllegalEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType())) {
            String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType(), datasetInfo.getEncodeType())) {
            String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = null;
        if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetVector(this.i.getHandle(), datasetInfo.getHandle());
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.i);
            this.a(datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
        return datasetVector;
    }

    public DatasetVector create(DatasetVectorInfo datasetInfo, PrjCoordSys prj) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType(), datasetInfo.getEncodeType())) {
            String string = InternalResource.loadString("value", "DatasetVectorInfo_IllegalEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType())) {
            String string = InternalResource.loadString("type", "Datasets_FailToCreateBecauseOfType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(datasetInfo.getType(), datasetInfo.getEncodeType())) {
            String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = null;
        if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetVectorWithPrj(this.i.getHandle(), datasetInfo.getHandle(), prj.getHandle());
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.i);
            this.a(datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
        InternalHandleDisposable.makeSureNativeObjectLive(prj);
        return datasetVector;
    }

    public DatasetGrid create(DatasetGridInfo datasetInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetGridInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetInfo.getWidth() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo.getHeight() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Datasets.a(DatasetType.GRID, datasetInfo.getEncodeType())) {
            String string = InternalResource.loadString("encodeType", "Datasets_FailToCreateBecauseOfEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = null;
        if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("datasetInfo.name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetRaster(this.i.getHandle(), datasetInfo.getHandle(), false);
        if (l != 0L) {
            datasetGrid = new DatasetGrid(l, this.i);
            this.a(datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
        return datasetGrid;
    }

    public DatasetVolume create(DatasetVolumeInfo datasetInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetGridInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetInfo.getWidth() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo.getHeight() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVolume datasetVolume = null;
        if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("datasetInfo.name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetRaster(this.i.getHandle(), datasetInfo.getHandle(), true);
        if (l != 0L) {
            datasetVolume = new DatasetVolume(l, this.i);
            this.a(datasetVolume);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
        return datasetVolume;
    }

    public DatasetImage create(DatasetImageInfo datasetInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetImageInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetInfo.getWidth() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetInfo.getHeight() <= 0) {
            String string = InternalResource.loadString("datasetInfo", "DatasetImage_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImage datasetImage = null;
        if (datasetInfo.getName().trim().equals("") || !this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetRaster(this.i.getHandle(), datasetInfo.getHandle(), true);
        if (l != 0L) {
            datasetImage = new DatasetImage(l, this.i);
            this.a(datasetImage);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(datasetInfo);
        return datasetImage;
    }

    public DatasetTopology create(DatasetTopologyInfo datasetInfo) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("create(DatasetTopologyInfo datasetInfo)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (datasetInfo == null) {
            String string = InternalResource.loadString("datasetInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetTopology datasetTopology = null;
        if (!this.isAvailableDatasetName(datasetInfo.getName())) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetsNative.jni_CreateDatasetTopology(this.i.getHandle(), datasetInfo.getName());
        if (l != 0L) {
            datasetTopology = new DatasetTopology(l, this.i);
            this.a(datasetTopology);
        }
        return datasetTopology;
    }

    public DatasetGridCollection createGridCollection(String name, PixelFormat pixFormat) {
        if (!this.a()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetGridCollection datasetGridCollection = null;
        if (name.equals("") || !this.isAvailableDatasetName(name)) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridCollectionInfo datasetGridCollectionInfo = new DatasetGridCollectionInfo();
        datasetGridCollectionInfo.setName(name);
        datasetGridCollectionInfo.setPixelFormat(pixFormat);
        long l = DatasetsNative.jni_CreateCollection(this.i.getHandle(), datasetGridCollectionInfo.getHandle());
        if (l != 0L) {
            datasetGridCollection = new DatasetGridCollection(l, this.i);
            this.a(datasetGridCollection);
        }
        datasetGridCollectionInfo.dispose();
        return datasetGridCollection;
    }

    public DatasetGridCollection createGridCollection(DatasetGridCollectionInfo info) {
        if (!this.a()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("createGridCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetGridCollection datasetGridCollection = null;
        long l = DatasetsNative.jni_CreateCollection(this.i.getHandle(), info.getHandle());
        if (l != 0L) {
            datasetGridCollection = new DatasetGridCollection(l, this.i);
            this.a(datasetGridCollection);
        }
        return datasetGridCollection;
    }

    public DatasetImageCollection createImageCollection(String name) {
        if (!this.a()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetImageCollection datasetImageCollection = null;
        if (name.equals("") || !this.isAvailableDatasetName(name)) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImageCollectionInfo datasetImageCollectionInfo = new DatasetImageCollectionInfo();
        datasetImageCollectionInfo.setName(name);
        long l = DatasetsNative.jni_CreateCollection(this.i.getHandle(), datasetImageCollectionInfo.getHandle());
        if (l != 0L) {
            datasetImageCollection = new DatasetImageCollection(l, this.i);
            this.a(datasetImageCollection);
        }
        datasetImageCollectionInfo.dispose();
        return datasetImageCollection;
    }

    public DatasetImageCollection createImageCollection(DatasetImageCollectionInfo info) {
        if (!this.a()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("createImageCollection(String name,PixelFormat pixFormat)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetImageCollection datasetImageCollection = null;
        long l = DatasetsNative.jni_CreateCollection(this.i.getHandle(), info.getHandle());
        if (l != 0L) {
            datasetImageCollection = new DatasetImageCollection(l, this.i);
            this.a(datasetImageCollection);
        }
        return datasetImageCollection;
    }

    public Dataset createFromTemplate(String name, Dataset templateDataset) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("createFromTemplate(String name, Dataset templateDataset)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isAvailableDatasetName(name)) {
            String string = InternalResource.loadString("name", "Datasets_NameIsOccupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (templateDataset.getHandle() == 0L) {
            String string = InternalResource.loadString("templateDataset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        long l = DatasetsNative.jni_CreateDatasetFromTemplate(this.i.getHandle(), name, templateDataset.getHandle());
        if (l != 0L) {
            dataset = Dataset.createInstance(l, templateDataset.getType(), this.i);
            this.a(dataset);
        }
        return dataset;
    }

    public boolean delete(String name) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("delete(String name)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, name);
        this.fireDeleting(datasetDeletingEvent);
        if (datasetDeletingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = DatasetsNative.jni_DeleteDataset2(this.i.getHandle(), name);
        if (bl) {
            DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, name);
            this.fireDeleted(datasetDeletedEvent);
        }
        return bl;
    }

    public boolean delete(int index) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("delete(int index)", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        DatasetDeletingEvent datasetDeletingEvent = new DatasetDeletingEvent(this, String.valueOf(index));
        this.fireDeleting(datasetDeletingEvent);
        if (datasetDeletingEvent.getCancel()) {
            return false;
        }
        String string = DatasetsNative.jni_DeleteDataset(this.i.getHandle(), index);
        if (string != null) {
            DatasetDeletedEvent datasetDeletedEvent = new DatasetDeletedEvent(this, string);
            this.fireDeleted(datasetDeletedEvent);
        }
        return true;
    }

    public void deleteAll() {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.i.isReadOnly()) {
            String string = InternalResource.loadString("deleteAll()", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasetDeletingAllEvent datasetDeletingAllEvent = new DatasetDeletingAllEvent(this);
        this.fireDeletingAll(datasetDeletingAllEvent);
        if (datasetDeletingAllEvent.getCancel()) {
            return;
        }
        int n = this.getCount();
        DatasetsNative.jni_DeleteAll(this.i.getHandle());
        DatasetDeletedAllEvent datasetDeletedAllEvent = new DatasetDeletedAllEvent(this, n);
        this.fireDeletedAll(datasetDeletedAllEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableDatasetName(String name) {
        this.h.lock();
        try {
            if (!this.a()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = false;
            if (name != null && name.trim().length() != 0) {
                bl = DatasetsNative.jni_IsAvailableDatasetName(this.i.getHandle(), name);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableDatasetName(String name, DatasetType datasetType) {
        this.h.lock();
        try {
            if (!this.a()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (datasetType == null) {
                String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
                throw new NullPointerException(string);
            }
            boolean bl = false;
            if (name != null && name.trim().length() != 0) {
                bl = DatasetsNative.jni_IsAvailableDatasetName2(this.i.getHandle(), name, datasetType.getUGCValue());
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.h.unlock();
        }
    }

    public String getAvailableDatasetName(String name) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return DatasetsNative.jni_GetUnoccupiedDatasetName(this.i.getHandle(), name);
    }

    public String getAvailableDatasetName(String name, DatasetType datasetType) {
        if (!this.a()) {
            String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        if (datasetType == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        return DatasetsNative.jni_GetUnoccupiedDatasetName2(this.i.getHandle(), name, datasetType.getUGCValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String oldName, String newName) {
        this.h.lock();
        try {
            if (!this.a()) {
                String string = InternalResource.loadString("", "Datasets_ParentIsNotValid", "data_resources");
                throw new IllegalStateException(string);
            }
            if (this.i.isReadOnly()) {
                String string = InternalResource.loadString("rename(String oldName, String newName)", "Datasets_DatasourceIsReadOnly", "data_resources");
                throw new UnsupportedOperationException(string);
            }
            if (oldName == null || oldName.trim().length() == 0) {
                String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (newName == null || newName.trim().length() == 0) {
                String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (oldName.equalsIgnoreCase(newName)) {
                boolean bl = false;
                return bl;
            }
            Dataset dataset = this.get(oldName);
            if (dataset == null) {
                String string = InternalResource.loadString("oldName", "Global_SpecifiedNameNotExist", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.contains(newName)) {
                String string = InternalResource.loadString("newName", "Global_SpecifiedNameAlreadyExist", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetRenamingEvent datasetRenamingEvent = new DatasetRenamingEvent(this, oldName, newName);
            this.fireRenaming(datasetRenamingEvent);
            boolean bl = false;
            if (datasetRenamingEvent.getCancel()) {
                boolean bl2 = false;
                return bl2;
            }
            bl = dataset.a(newName);
            if (bl) {
                DatasetRenamedEvent datasetRenamedEvent = new DatasetRenamedEvent(this, oldName, newName);
                this.fireRenamed(datasetRenamedEvent);
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.h.unlock();
        }
    }

    public boolean contains(String name) {
        return DatasetsNative.jni_Contains(this.i.getHandle(), name);
    }

    @Deprecated
    public int indexOf(String name) {
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            return DatasetsNative.jni_IndexOf(this.i.getHandle(), name);
        }
        return n;
    }

    static boolean a(DatasetType datasetType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.LINKTABLE) || datasetType.equals(DatasetType.NETWORK) || datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.IMAGE) || datasetType.equals(DatasetType.WCS) || datasetType.equals(DatasetType.WMS) || datasetType.equals(DatasetType.TOPOLOGY)) {
            bl = false;
        }
        return bl;
    }

    static boolean a(DatasetType datasetType, EncodeType encodeType) {
        boolean bl = true;
        if (datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.POINT)) {
            bl = encodeType.equals(EncodeType.NONE);
        } else if (Datasets.a(datasetType)) {
            bl = !encodeType.equals(EncodeType.DCT);
            bl = bl && !encodeType.equals(EncodeType.SGL);
            bl = bl && !encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.WCS) || datasetType.equals(DatasetType.WMS)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW);
        } else if (datasetType.equals(DatasetType.IMAGE)) {
            bl = encodeType.equals(EncodeType.NONE) || encodeType.equals(EncodeType.DCT) || encodeType.equals(EncodeType.SGL) || encodeType.equals(EncodeType.LZW) || encodeType.equals(EncodeType.COMPOUND);
        }
        return bl;
    }

    void a(Dataset dataset) {
        DatasetCreatedEvent datasetCreatedEvent = new DatasetCreatedEvent(this, dataset.getName());
        this.fireCreated(datasetCreatedEvent);
    }

    protected static void add(Datasets datasets, Dataset dataset) {
        if (datasets != null) {
            datasets.a(dataset);
        }
    }

    private boolean a() {
        boolean bl = true;
        if (this.i == null || this.i.getHandle() == 0L) {
            bl = false;
        }
        return bl;
    }

    public void addRenamingListener(DatasetRenamingListener l) {
        this.h.lock();
        try {
            if (this.a == null) {
                this.a = new CopyOnWriteArrayList();
            }
            if (!this.a.contains(l)) {
                this.a.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeRenamingListener(DatasetRenamingListener l) {
        this.h.lock();
        try {
            if (this.a != null && this.a.contains(l)) {
                this.a.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRenaming(DatasetRenamingEvent event) {
        this.h.lock();
        try {
            if (this.a != null) {
                CopyOnWriteArrayList<DatasetRenamingListener> copyOnWriteArrayList = this.a;
                int n = copyOnWriteArrayList.size();
                for (int i = 0; i < n; ++i) {
                    copyOnWriteArrayList.get(i).datasetRenaming(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addRenamedListener(DatasetRenamedListener l) {
        this.h.lock();
        try {
            if (this.b == null) {
                this.b = new CopyOnWriteArrayList();
            }
            if (!this.b.contains(l)) {
                this.b.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeRenamedListener(DatasetRenamedListener l) {
        this.h.lock();
        try {
            if (this.b != null && this.b.contains(l)) {
                this.b.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRenamed(DatasetRenamedEvent event) {
        this.h.lock();
        try {
            if (this.b != null) {
                CopyOnWriteArrayList<DatasetRenamedListener> copyOnWriteArrayList = this.b;
                for (DatasetRenamedListener datasetRenamedListener : copyOnWriteArrayList) {
                    datasetRenamedListener.datasetRenamed(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addDeletingListener(DatasetDeletingListener l) {
        this.h.lock();
        try {
            if (this.c == null) {
                this.c = new CopyOnWriteArrayList();
            }
            if (!this.c.contains(l)) {
                this.c.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeDeletingListener(DatasetDeletingListener l) {
        this.h.lock();
        try {
            if (this.c != null && this.c.contains(l)) {
                this.c.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeleting(DatasetDeletingEvent event) {
        this.h.lock();
        try {
            if (this.c != null) {
                CopyOnWriteArrayList<DatasetDeletingListener> copyOnWriteArrayList = this.c;
                for (DatasetDeletingListener datasetDeletingListener : copyOnWriteArrayList) {
                    datasetDeletingListener.datasetDeleting(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addDeletedListener(DatasetDeletedListener l) {
        this.h.lock();
        try {
            if (this.d == null) {
                this.d = new CopyOnWriteArrayList();
            }
            if (!this.d.contains(l)) {
                this.d.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeDeletedListener(DatasetDeletedListener l) {
        this.h.lock();
        try {
            if (this.d != null && this.d.contains(l)) {
                this.d.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeleted(DatasetDeletedEvent event) {
        this.h.lock();
        try {
            if (this.d != null) {
                CopyOnWriteArrayList<DatasetDeletedListener> copyOnWriteArrayList = this.d;
                for (DatasetDeletedListener datasetDeletedListener : copyOnWriteArrayList) {
                    datasetDeletedListener.DatasetDeleted(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addDeletingAllListener(DatasetDeletingAllListener l) {
        this.h.lock();
        try {
            if (this.e == null) {
                this.e = new CopyOnWriteArrayList();
            }
            if (!this.e.contains(l)) {
                this.e.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeDeletingAllListener(DatasetDeletingAllListener l) {
        this.h.lock();
        try {
            if (this.e != null && this.e.contains(l)) {
                this.e.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeletingAll(DatasetDeletingAllEvent event) {
        this.h.lock();
        try {
            if (this.e != null) {
                CopyOnWriteArrayList<DatasetDeletingAllListener> copyOnWriteArrayList = this.e;
                for (DatasetDeletingAllListener datasetDeletingAllListener : copyOnWriteArrayList) {
                    datasetDeletingAllListener.datasetDeletingAll(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addDeletedAllListener(DatasetDeletedAllListener l) {
        this.h.lock();
        try {
            if (this.f == null) {
                this.f = new CopyOnWriteArrayList();
            }
            if (!this.f.contains(l)) {
                this.f.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeDeletedAllListener(DatasetDeletedAllListener l) {
        this.h.lock();
        try {
            if (this.f != null && this.f.contains(l)) {
                this.f.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDeletedAll(DatasetDeletedAllEvent event) {
        this.h.lock();
        try {
            if (this.f != null) {
                CopyOnWriteArrayList<DatasetDeletedAllListener> copyOnWriteArrayList = this.f;
                for (DatasetDeletedAllListener datasetDeletedAllListener : copyOnWriteArrayList) {
                    datasetDeletedAllListener.datasetDeletedAll(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void addCreatedListener(DatasetCreatedListener l) {
        this.h.lock();
        try {
            if (this.g == null) {
                this.g = new CopyOnWriteArrayList();
            }
            if (!this.g.contains(l)) {
                this.g.add(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void removeCreatedListener(DatasetCreatedListener l) {
        this.h.lock();
        try {
            if (this.g != null && this.g.contains(l)) {
                this.g.remove(l);
            }
        }
        finally {
            this.h.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreated(DatasetCreatedEvent event) {
        this.h.lock();
        try {
            if (this.g != null) {
                CopyOnWriteArrayList<DatasetCreatedListener> copyOnWriteArrayList = this.g;
                for (DatasetCreatedListener datasetCreatedListener : copyOnWriteArrayList) {
                    datasetCreatedListener.datasetCreated(event);
                }
            }
        }
        finally {
            this.h.unlock();
        }
    }

    public void refresh() {
        DatasourceRefreshedEvent datasourceRefreshedEvent = new DatasourceRefreshedEvent(this.i, this.i);
        this.i.fireRefreshed(datasourceRefreshedEvent);
    }

    Dataset a(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        long l = DatasetsNative.jni_GetDatasetByTableName(this.i.getHandle(), string);
        if (l == 0L) {
            return null;
        }
        int n = DatasetNative.jni_GetType(l);
        DatasetType datasetType = this.getJavaDatasetType(n);
        if (datasetType == DatasetType.UNKNOWN) {
            return null;
        }
        return Dataset.createInstance(l, datasetType, this.i);
    }

    protected DatasetType getJavaDatasetType(int ugcType) {
        DatasetType datasetType;
        try {
            datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, ugcType);
        }
        catch (RuntimeException runtimeException) {
            datasetType = ugcType == 88 ? DatasetType.IMAGE : (ugcType == 89 ? DatasetType.GRID : (ugcType == 90 ? DatasetType.a : (ugcType == DatasetType.a.getUGCValue() ? DatasetType.a : DatasetType.UNKNOWN)));
        }
        return datasetType;
    }

    public DatasetVector SetExpTable(String strName) {
        if (!this.a()) {
            String string = InternalResource.loadString("create(DatasetVectorInfo datasetInfo)", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVector datasetVector = null;
        long l = DatasetsNative.jni_SetExpTable(this.i.getHandle(), strName);
        if (l != 0L) {
            datasetVector = new DatasetVector(l, this.i);
            this.a(datasetVector);
        }
        return datasetVector;
    }

    public String[] getDatasetNames() {
        if (!this.a()) {
            String string = InternalResource.loadString("getDatasetNames(String[] names))", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetsNative.jni_GetDatasetNames(this.i.getHandle());
    }

    public DatasetMosaic createDatasetMosaic(String name, PrjCoordSys prjCoordSys) {
        return this.a(name, prjCoordSys, "", "");
    }

    public DatasetMosaic createDatasetMosaic(String name, PrjCoordSys prjCoordSys, String productName) {
        return this.a(name, prjCoordSys, productName, (String)null);
    }

    @Deprecated
    public DatasetMosaic createDatasetMosaic(String name, PrjCoordSys prjCoordSys, String satelliteType, String extraFieldFilePath) {
        return this.a(name, prjCoordSys, satelliteType, extraFieldFilePath);
    }

    @Deprecated
    public DatasetMosaic createDatasetMosaic4Satellite(String name, PrjCoordSys prjCoordSys, String satelliteType, Map<String, String> extendAttributes) {
        return this.a(name, prjCoordSys, satelliteType, extendAttributes);
    }

    private DatasetMosaic a(String string, PrjCoordSys prjCoordSys, String string2, String string3) {
        long l;
        if (string == null) {
            string = "";
        }
        this.b(string);
        long l2 = 0L;
        if (prjCoordSys != null) {
            l2 = prjCoordSys.getHandle();
        }
        if ((l = DatasetsNative.jni_CreateDatasetMosaic2(this.i.getHandle(), string, l2, string2, string3)) == 0L) {
            return null;
        }
        DatasetMosaic datasetMosaic = new DatasetMosaic(l, this.i);
        this.a(datasetMosaic);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetMosaic);
        return datasetMosaic;
    }

    @Deprecated
    private DatasetMosaic a(String string3, PrjCoordSys prjCoordSys, String string4, Map<String, String> map) {
        long l;
        if (string3 == null) {
            string3 = "";
        }
        this.b(string3);
        long l2 = 0L;
        if (prjCoordSys != null) {
            l2 = prjCoordSys.getHandle();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (map != null && map.size() > 0) {
            map.forEach((string, string2) -> {
                arrayList.add(string);
                arrayList2.add(string2);
            });
        }
        if ((l = DatasetsNative.jni_CreateDatasetMosaic3(this.i.getHandle(), string3, l2, string4, arrayList.toArray(new String[0]), arrayList2.toArray(new String[0]))) == 0L) {
            return null;
        }
        DatasetMosaic datasetMosaic = new DatasetMosaic(l, this.i);
        this.a(datasetMosaic);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetMosaic);
        return datasetMosaic;
    }

    private void b(String string) {
        if (!this.a()) {
            String string2 = InternalResource.loadString("createDatasetMosaic", "Datasets_ParentIsNotValid", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.i.getHandle() == 0L) {
            String string3 = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.i.isReadOnly()) {
            String string4 = InternalResource.loadString("readOnly", "Datasets_DatasourceIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this.contains(string)) {
            String string5 = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string5);
        }
    }

    public void lock() {
        this.h.lock();
    }

    public void unlock() {
        this.h.unlock();
    }
}

