/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandle;

public class InterpolationRBFParameter
extends InterpolationParameter {
    private DatasetVector a = null;

    public InterpolationRBFParameter() {
        super(InterpolationAlgorithmType.RBF);
    }

    public InterpolationRBFParameter(double tension, double smooth, double resolution) {
        super(InterpolationAlgorithmType.RBF, resolution);
        this.setTension(tension);
        this.setSmooth(smooth);
    }

    public InterpolationRBFParameter(double tension, double smooth, double resolution, SearchMode mode, double searchRadius, int expectedCount) {
        super(InterpolationAlgorithmType.RBF, resolution, mode, searchRadius, expectedCount);
        this.setTension(tension);
        this.setSmooth(smooth);
    }

    public double getTension() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getTension()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetTension(this.getHandle());
    }

    public void setTension(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setTension(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetTension(this.getHandle(), value);
    }

    public double getSmooth() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getSmooth()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetSmooth(this.getHandle());
    }

    public void setSmooth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setSmooth(double value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameterNative.jni_SetSmooth(this.getHandle(), value);
    }

    public DatasetVector getBarrierDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getBarrierDataset()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setBarrierDataset(DatasetVector barrierDataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setBarrierDataset(DatasetVector barrierDataset)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (barrierDataset == null || InternalDatasetVector.getHandle((InternalHandle)barrierDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("barrierDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (barrierDataset.getType() != DatasetType.LINE) {
            String string = InternalResourceSpatialanalyst.loadString("barrierDataset", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        InterpolationParameterNative.jni_SetBreakLine(this.getHandle(), InternalDatasetVector.getHandle((InternalHandle)barrierDataset));
        this.a = barrierDataset;
    }

    @Override
    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationAlgorithmType.RBF;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Smooth=");
        stringBuffer.append(this.getSmooth());
        stringBuffer.append(",Tension=");
        stringBuffer.append(this.getTension());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

