/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import java.util.ArrayList;

public class ANNParameter {
    private int a;
    private double b;
    private int c;
    private boolean d;
    private ArrayList[] e;

    public ANNParameter() {
        this.a = 7;
        this.b = 0.2;
        this.c = 1000;
        this.d = false;
        this.e = null;
    }

    public ANNParameter(ANNParameter para) {
        this.a = para.a;
        this.b = para.b;
        this.c = para.c;
    }

    public boolean isCustomNeighborhood() {
        return this.d;
    }

    public void setCustomNeighborhood(boolean value) {
        this.d = value;
    }

    public int getNeighborhoodNumber() {
        return this.a;
    }

    public void setNeighborhoodNumber(int value) {
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("NeighborhoodNumber", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = value;
    }

    public boolean[][] getCustomNeighborhoods() {
        if (this.e == null) {
            return null;
        }
        int n = this.e.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = new boolean[n];
            for (int j = 0; j < n; ++j) {
                blArray[j] = (Boolean)this.e[i].get(j);
            }
            blArrayArray[i] = blArray;
        }
        return blArrayArray;
    }

    public void setCustomNeighborhoods(boolean[][] value) {
        int n;
        int n2;
        if (value == null || value.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("CustomNeighborhoods", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < value.length; ++n2) {
            if (value[n2] == null) {
                String string = InternalResourceSpatialanalyst.loadString("CustomNeighborhoods[" + n2 + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (value.length == value[n2].length) continue;
            String string = InternalResourceSpatialanalyst.loadString("CustomNeighborhoods[" + n2 + "].length and CustomNeighborhoods.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = value.length;
        if (this.e != null) {
            for (n = 0; n < this.e.length; ++n) {
                this.e[n].clear();
            }
        } else {
            this.e = new ArrayList[n2];
            for (n = 0; n < n2; ++n) {
                this.e[n] = new ArrayList();
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.e[n].add(value[n][i]);
            }
        }
    }

    public double getLearningRate() {
        return this.b;
    }

    public void setLearningRate(double value) {
        if (value <= 0.0 || value > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("LearningRate", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.b = value;
    }

    public int getSampleCount() {
        return this.c;
    }

    public void setSampleCount(int value) {
        if (value < 100) {
            String string = InternalResourceSpatialanalyst.loadString("SampleCount", "GlobalGreaterThanHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.c = value;
    }
}

