/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.JTS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ScreenMap {
    double[] point = new double[2];
    int[] pixels;
    int width;
    int height;
    private int minx;
    private int miny;
    MathTransform mt;
    double spanX;
    double spanY;

    public ScreenMap(int x, int y, int width, int height, MathTransform mt) {
        this.width = width;
        this.height = height;
        this.minx = x;
        this.miny = y;
        int arraySize = width * height / 32 + 1;
        this.pixels = new int[arraySize];
        this.mt = mt;
    }

    public ScreenMap(ScreenMap original, int expandBy) {
        this(original.minx - expandBy, original.miny - expandBy, original.width + expandBy * 2, original.height + expandBy * 2);
    }

    public ScreenMap(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public void setTransform(MathTransform mt) {
        this.mt = mt;
    }

    public boolean checkAndSet(Envelope envelope) throws TransformException {
        if (!this.canSimplify(envelope)) {
            return false;
        }
        this.point[0] = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        this.point[1] = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        this.mt.transform(this.point, 0, this.point, 0, 1);
        int r = (int)this.point[0];
        int c = (int)this.point[1];
        return this.checkAndSet(r, c);
    }

    public boolean canSimplify(Envelope envelope) {
        return envelope.getWidth() < this.spanX && envelope.getHeight() < this.spanY;
    }

    public void setSpans(double spanX, double spanY) {
        this.spanX = spanX;
        this.spanY = spanY;
    }

    public boolean checkAndSet(int x, int y) {
        if (x - this.minx < 0 || x - this.minx > this.width - 1 || y - this.miny < 0 || y - this.miny > this.height - 1) {
            return false;
        }
        int bit = this.bit(x - this.minx, y - this.miny);
        int index = bit / 32;
        int offset = bit % 32;
        int mask = 1 << offset;
        try {
            if ((this.pixels[index] & mask) != 0) {
                return true;
            }
            this.pixels[index] = this.pixels[index] | mask;
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean get(Envelope envelope) throws TransformException {
        if (!this.canSimplify(envelope)) {
            return false;
        }
        this.point[0] = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        this.point[1] = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        this.mt.transform(this.point, 0, this.point, 0, 1);
        int r = (int)this.point[0];
        int c = (int)this.point[1];
        return this.get(r, c);
    }

    public boolean get(int x, int y) {
        if (x - this.minx < 0 || x - this.minx > this.width - 1 || y - this.miny < 0 || y - this.miny > this.height - 1) {
            return false;
        }
        int bit = this.bit(x - this.minx, y - this.miny);
        int index = bit / 32;
        int offset = bit % 32;
        int mask = 1 << offset;
        try {
            return (this.pixels[index] & mask) != 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    private int bit(int x, int y) {
        return this.width * y + x;
    }

    public Geometry getSimplifiedShape(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        return this.getSimplifiedShape(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), geometry.getFactory(), geometry.getClass());
    }

    public Geometry getSimplifiedShape(double minx, double miny, double maxx, double maxy, GeometryFactory geometryFactory, Class geometryType) {
        CoordinateSequenceFactory csf = geometryFactory.getCoordinateSequenceFactory();
        double midx = (minx + maxx) / 2.0;
        double midy = (miny + maxy) / 2.0;
        double x0 = midx - this.spanX / 2.0;
        double x1 = midx + this.spanX / 2.0;
        double y0 = midy - this.spanY / 2.0;
        double y1 = midy + this.spanY / 2.0;
        if (Point.class.isAssignableFrom(geometryType) || MultiPoint.class.isAssignableFrom(geometryType)) {
            CoordinateSequence cs = JTS.createCS((CoordinateSequenceFactory)csf, (int)1, (int)2);
            cs.setOrdinate(0, 0, midx);
            cs.setOrdinate(0, 1, midy);
            if (Point.class.isAssignableFrom(geometryType)) {
                return geometryFactory.createPoint(cs);
            }
            return geometryFactory.createMultiPoint(new Point[]{geometryFactory.createPoint(cs)});
        }
        if (LineString.class.isAssignableFrom(geometryType) || MultiLineString.class.isAssignableFrom(geometryType)) {
            CoordinateSequence cs = JTS.createCS((CoordinateSequenceFactory)csf, (int)2, (int)2);
            cs.setOrdinate(0, 0, x0);
            cs.setOrdinate(0, 1, y0);
            cs.setOrdinate(1, 0, x1);
            cs.setOrdinate(1, 1, y1);
            if (MultiLineString.class.isAssignableFrom(geometryType)) {
                return geometryFactory.createMultiLineString(new LineString[]{geometryFactory.createLineString(cs)});
            }
            return geometryFactory.createLineString(cs);
        }
        CoordinateSequence cs = JTS.createCS((CoordinateSequenceFactory)csf, (int)5, (int)2);
        cs.setOrdinate(0, 0, x0);
        cs.setOrdinate(0, 1, y0);
        cs.setOrdinate(1, 0, x0);
        cs.setOrdinate(1, 1, y1);
        cs.setOrdinate(2, 0, x1);
        cs.setOrdinate(2, 1, y1);
        cs.setOrdinate(3, 0, x1);
        cs.setOrdinate(3, 1, y0);
        cs.setOrdinate(4, 0, x0);
        cs.setOrdinate(4, 1, y0);
        LinearRing ring = geometryFactory.createLinearRing(cs);
        if (MultiPolygon.class.isAssignableFrom(geometryType)) {
            return geometryFactory.createMultiPolygon(new Polygon[]{geometryFactory.createPolygon(ring, null)});
        }
        return geometryFactory.createPolygon(ring, null);
    }

    public void set(int x, int y, boolean value) {
        if (x - this.minx < 0 || x - this.minx > this.width - 1 || y - this.miny < 0 || y - this.miny > this.height - 1) {
            return;
        }
        int bit = this.bit(x - this.minx, y - this.miny);
        int index = bit / 32;
        int offset = bit % 32;
        int mask = 1;
        mask <<= offset;
        if (value) {
            this.pixels[index] = this.pixels[index] | mask;
        } else {
            int tmp = this.pixels[index];
            tmp ^= 0xFFFFFFFF;
            tmp |= mask;
            this.pixels[index] = tmp ^= 0xFFFFFFFF;
        }
    }
}

