/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import org.geotools.geometry.jts.JTS;

public class GeometryBuilder {
    private GeometryFactory geomFact;
    private CoordinateSequenceFactory csFact;

    public GeometryBuilder() {
        this(new GeometryFactory());
    }

    public GeometryBuilder(GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.csFact = geomFact.getCoordinateSequenceFactory();
    }

    public Point point() {
        return this.geomFact.createPoint(this.createCS(new double[0], 2));
    }

    public Point pointZ() {
        return this.geomFact.createPoint(this.createCS(new double[0], 3));
    }

    public Point point(double x) {
        return this.geomFact.createPoint(this.createCS(new double[]{x}, 1));
    }

    public Point point(double x, double y) {
        return this.geomFact.createPoint(this.createCS(new double[]{x, y}, 2));
    }

    public Point pointZ(double x, double y, double z) {
        return this.geomFact.createPoint(this.createCS(new double[]{x, y, z}, 3));
    }

    public LineString lineString() {
        return this.geomFact.createLineString(this.createCS(new double[0], 2));
    }

    public LineString lineStringZ() {
        return this.geomFact.createLineString(this.createCS(new double[0], 3));
    }

    public LineString lineString(double ... ord) {
        return this.geomFact.createLineString(this.createCS(ord, 2));
    }

    public LineString lineStringZ(double ... ord) {
        return this.geomFact.createLineString(this.createCS(ord, 3));
    }

    public LinearRing linearRing() {
        return this.geomFact.createLinearRing(this.createRingCS(new double[0], 2));
    }

    public LinearRing linearRingZ() {
        return this.geomFact.createLinearRing(this.createRingCS(new double[0], 3));
    }

    public LinearRing linearRing(double ... ord) {
        return this.geomFact.createLinearRing(this.createRingCS(ord, 2));
    }

    public LinearRing linearRingZ(double ... ord) {
        return this.geomFact.createLinearRing(this.createRingCS(ord, 3));
    }

    public Polygon polygon() {
        return this.geomFact.createPolygon(this.linearRing(), null);
    }

    public Polygon polygonZ() {
        return this.geomFact.createPolygon(this.linearRingZ(), null);
    }

    public Polygon polygon(double ... ord) {
        return this.geomFact.createPolygon(this.linearRing(ord), null);
    }

    public Polygon polygonZ(double ... ord) {
        return this.geomFact.createPolygon(this.linearRingZ(ord), null);
    }

    public Polygon polygon(LinearRing shell) {
        return this.geomFact.createPolygon(shell, null);
    }

    public Polygon polygon(LinearRing shell, LinearRing hole) {
        return this.geomFact.createPolygon(shell, new LinearRing[]{hole});
    }

    public Polygon polygon(Polygon shell, Polygon hole) {
        return this.geomFact.createPolygon((LinearRing)shell.getExteriorRing(), new LinearRing[]{(LinearRing)hole.getExteriorRing()});
    }

    public Polygon box(double x1, double y1, double x2, double y2) {
        double[] ord = new double[]{x1, y1, x1, y2, x2, y2, x2, y1, x1, y1};
        return this.polygon(ord);
    }

    public Polygon boxZ(double x1, double y1, double x2, double y2, double z) {
        double[] ord = new double[]{x1, y1, z, x1, y2, z, x2, y2, z, x2, y1, z, x1, y1, z};
        return this.polygonZ(ord);
    }

    public Polygon ellipse(double x1, double y1, double x2, double y2, int nsides) {
        double rx = Math.abs(x2 - x1) / 2.0;
        double ry = Math.abs(y2 - y1) / 2.0;
        double cx = Math.min(x1, x2) + rx;
        double cy = Math.min(y1, y2) + ry;
        double[] ord = new double[2 * nsides + 2];
        double angInc = Math.PI * 2 / (double)nsides;
        for (int i = 0; i < nsides; ++i) {
            double ang = -((double)i * angInc);
            ord[2 * i] = cx + rx * Math.cos(ang);
            ord[2 * i + 1] = cy + ry * Math.sin(ang);
        }
        ord[2 * nsides] = ord[0];
        ord[2 * nsides + 1] = ord[1];
        return this.polygon(ord);
    }

    public Polygon circle(double x, double y, double radius, int nsides) {
        return this.ellipse(x - radius, y - radius, x + radius, y + radius, nsides);
    }

    public MultiPoint multiPoint(double x1, double y1, double x2, double y2) {
        return this.geomFact.createMultiPoint(new Point[]{this.point(x1, y1), this.point(x2, y2)});
    }

    public MultiPoint multiPointZ(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.geomFact.createMultiPoint(new Point[]{this.pointZ(x1, y1, z1), this.pointZ(x2, y2, z2)});
    }

    public MultiLineString multiLineString(LineString ... lines) {
        return this.geomFact.createMultiLineString(lines);
    }

    public MultiPolygon multiPolygon(Polygon ... polys) {
        return this.geomFact.createMultiPolygon(polys);
    }

    public GeometryCollection geometryCollection(Geometry ... geoms) {
        return this.geomFact.createGeometryCollection(geoms);
    }

    private boolean isClosed(double[] ord, int dim) {
        int n = ord.length / dim;
        if (n == 0) {
            return true;
        }
        int lastPos = dim * (n - 1);
        double lastx = ord[lastPos];
        double lasty = ord[lastPos + 1];
        boolean isClosed = lastx == ord[0] && lasty == ord[1];
        return isClosed;
    }

    private CoordinateSequence createRingCS(double[] ord, int dim) {
        if (this.isClosed(ord, dim)) {
            return this.createCS(ord, dim);
        }
        double[] ord2 = new double[ord.length + dim];
        System.arraycopy(ord, 0, ord2, 0, ord.length);
        int lastPos = ord.length;
        for (int i = 0; i < dim; ++i) {
            ord2[lastPos + i] = ord2[i];
        }
        return this.createCS(ord2, dim);
    }

    private CoordinateSequence createCS(double[] ord, int dim) {
        if (ord.length % dim != 0) {
            throw new IllegalArgumentException("Ordinate array length " + ord.length + " is not a multiple of dimension " + dim);
        }
        int n = ord.length / dim;
        Object cs = this.csFact instanceof CoordinateArraySequenceFactory && dim == 1 ? new CoordinateArraySequence(n, dim) : JTS.createCS((CoordinateSequenceFactory)this.csFact, (int)n, (int)dim);
        if (cs.getDimension() != dim) {
            throw new IllegalStateException("Unable to use" + this.csFact + " to produce CoordinateSequence with dimension " + dim);
        }
        for (int i = 0; i < n; ++i) {
            for (int d = 0; d < dim; ++d) {
                cs.setOrdinate(i, d, ord[dim * i + d]);
            }
        }
        return cs;
    }
}

