/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import java.util.Collections;
import java.util.List;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class ModuloFunction
implements Function {
    static FunctionName NAME = new FunctionNameImpl("modulo", Integer.class, FunctionNameImpl.parameter("dividend", Integer.class), FunctionNameImpl.parameter("divisor", Integer.class));
    private final FunctionName functionName;
    private final List<Expression> parameters;
    private final Literal fallback;

    public ModuloFunction() {
        this.functionName = NAME;
        this.parameters = Collections.emptyList();
        this.fallback = null;
    }

    public ModuloFunction(List<Expression> parameters, Literal fallback) {
        if (parameters == null) {
            throw new NullPointerException("parameters must be provided");
        }
        if (parameters.size() != NAME.getArguments().size()) {
            throw new IllegalArgumentException(NAME.getArguments().size() + " function parameters are required");
        }
        this.functionName = NAME;
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, this.functionName.getReturn().getType());
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression dividendExpression = this.parameters.get(0);
        int dividend = (Integer)dividendExpression.evaluate(object, Integer.class);
        Expression divisorExpression = this.parameters.get(1);
        int divisor = (Integer)divisorExpression.evaluate(object, Integer.class);
        if (divisor == 0) {
            throw new IllegalArgumentException("divisor cannot be 0");
        }
        int modulo = dividend - divisor * (int)Math.floor((double)dividend / (double)divisor);
        return (T)Converters.convert((Object)modulo, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return this.functionName.getName();
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }
}

