/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.InternalHandle;

public class InterpolationIDWParameter
extends InterpolationParameter {
    private DatasetVector a = null;

    public InterpolationIDWParameter() {
        super(InterpolationAlgorithmType.IDW);
    }

    public InterpolationIDWParameter(double resolution, SearchMode mode, double searchRadius, int expectedCount) {
        super(InterpolationAlgorithmType.IDW, resolution, mode, searchRadius, expectedCount);
    }

    public InterpolationIDWParameter(double resolution, SearchMode mode, double searchRadius, int expectedCount, int power) {
        this(resolution, mode, searchRadius, expectedCount);
        this.setPower(power);
    }

    @Override
    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationAlgorithmType.IDW;
    }

    public int getPower() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getPower()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetPower(this.getHandle());
    }

    public void setPower(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setPower(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (value <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        InterpolationParameterNative.jni_SetPower(this.getHandle(), value);
    }

    @Override
    public void setSearchMode(SearchMode searchMode) {
        if (searchMode.equals((Object)SearchMode.QUADTREE)) {
            String string = InternalResourceSpatialanalyst.loadString("searchMode", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        super.setSearchMode(searchMode);
    }

    public DatasetVector getBreakDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("getBreakDataset()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setBreakDataset(DatasetVector breakDataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("setBreakDataset", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (breakDataset == null) {
            String string = InternalResourceSpatialanalyst.loadString("setBreakDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (breakDataset.getType() != DatasetType.LINE) {
            String string = InternalResourceSpatialanalyst.loadString("setBreakDataset", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)breakDataset);
        InterpolationParameterNative.jni_SetBreakLine(this.getHandle(), l);
        this.a = breakDataset;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Power=");
        stringBuffer.append(this.getPower());
        stringBuffer.append(",BreakDataset=");
        stringBuffer.append(this.getBreakDataset());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

