/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.Description;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.OtherText;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Halo;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

public class TextSymbolizerImpl
extends AbstractSymbolizer
implements TextSymbolizer2,
Cloneable {
    private List<Font> fonts = new ArrayList<Font>(1);
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private HaloImpl halo;
    private LabelPlacement placement;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private Expression abxtract = null;
    private Expression description = null;
    private OtherText otherText = null;

    protected TextSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
    }

    protected TextSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    protected TextSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom) {
        super(name, desc, (Expression)null, uom);
        this.filterFactory = factory;
        this.fill = new FillImpl(factory);
        this.fill.setColor((Expression)this.filterFactory.literal((Object)"#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    public FillImpl getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    public List<Font> fonts() {
        return this.fonts;
    }

    public Font getFont() {
        return this.fonts.isEmpty() ? null : this.fonts.get(0);
    }

    public void setFont(org.opengis.style.Font font) {
        if (this.fonts.size() == 1 && this.fonts.get(0) == font) {
            return;
        }
        if (font != null) {
            if (this.fonts.isEmpty()) {
                this.fonts.add(FontImpl.cast(font));
            } else {
                this.fonts.set(0, FontImpl.cast(font));
            }
        }
    }

    @Deprecated
    public Font[] getFonts() {
        return this.fonts.toArray(new Font[this.fonts.size()]);
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    @Deprecated
    public void setFonts(Font[] fonts) {
        this.fonts.clear();
        if (fonts != null) {
            for (Font font : fonts) {
                if (font == null) continue;
                this.fonts.add(font);
            }
        }
    }

    public HaloImpl getHalo() {
        return this.halo;
    }

    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        this.halo = HaloImpl.cast(halo);
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression label) {
        this.label = label;
    }

    @Deprecated
    public LabelPlacement getPlacement() {
        return this.getLabelPlacement();
    }

    public void setPlacement(LabelPlacement labelPlacement) {
        this.setLabelPlacement((org.opengis.style.LabelPlacement)labelPlacement);
    }

    public LabelPlacement getLabelPlacement() {
        return this.placement;
    }

    public void setLabelPlacement(org.opengis.style.LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        this.placement = labelPlacement instanceof LinePlacement ? LinePlacementImpl.cast(labelPlacement) : PointPlacementImpl.cast(labelPlacement);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.TextSymbolizer)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((TextSymbolizer)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
    }

    public Expression getPriority() {
        return this.priority;
    }

    public void addToOptions(String key, String value) {
        this.getOptions().put(key, value.trim());
    }

    public String getOption(String key) {
        if (this.options == null) {
            return null;
        }
        return (String)this.options.get(key);
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = graphic;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<TextSymbolizerImp property=");
        buf.append(this.getGeometryPropertyName());
        buf.append(" label=");
        buf.append(this.label);
        buf.append(">");
        buf.append(this.fonts);
        return buf.toString();
    }

    public Expression getSnippet() {
        return this.abxtract;
    }

    public void setSnippet(Expression abxtract) {
        this.abxtract = abxtract;
    }

    public Expression getFeatureDescription() {
        return this.description;
    }

    public void setFeatureDescription(Expression description) {
        this.description = description;
    }

    public OtherText getOtherText() {
        return this.otherText;
    }

    public void setOtherText(OtherText otherText) {
        this.otherText = otherText;
    }

    static TextSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof TextSymbolizerImpl) {
            return (TextSymbolizerImpl)symbolizer;
        }
        org.opengis.style.TextSymbolizer textSymbolizer = (org.opengis.style.TextSymbolizer)symbolizer;
        TextSymbolizerImpl copy = new TextSymbolizerImpl();
        copy.setDescription(textSymbolizer.getDescription());
        copy.setFill(textSymbolizer.getFill());
        copy.setFont(textSymbolizer.getFont());
        copy.setGeometryPropertyName(textSymbolizer.getGeometryPropertyName());
        copy.setHalo(textSymbolizer.getHalo());
        copy.setLabel(textSymbolizer.getLabel());
        copy.setLabelPlacement(textSymbolizer.getLabelPlacement());
        copy.setName(textSymbolizer.getName());
        copy.setUnitOfMeasure((Unit<Length>)textSymbolizer.getUnitOfMeasure());
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abxtract == null ? 0 : this.abxtract.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fill == null ? 0 : this.fill.hashCode());
        result = 31 * result + (this.filterFactory == null ? 0 : this.filterFactory.hashCode());
        result = 31 * result + (this.fonts == null ? 0 : this.fonts.hashCode());
        result = 31 * result + (this.graphic == null ? 0 : this.graphic.hashCode());
        result = 31 * result + (this.halo == null ? 0 : this.halo.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.otherText == null ? 0 : this.otherText.hashCode());
        result = 31 * result + (this.placement == null ? 0 : this.placement.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextSymbolizerImpl other = (TextSymbolizerImpl)obj;
        if (this.abxtract == null ? other.abxtract != null : !this.abxtract.equals(other.abxtract)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        if (this.filterFactory == null ? other.filterFactory != null : !this.filterFactory.equals(other.filterFactory)) {
            return false;
        }
        if (this.fonts == null ? other.fonts != null : !this.fonts.equals(other.fonts)) {
            return false;
        }
        if (this.graphic == null ? other.graphic != null : !this.graphic.equals(other.graphic)) {
            return false;
        }
        if (this.halo == null ? other.halo != null : !this.halo.equals(other.halo)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.otherText == null ? other.otherText != null : !this.otherText.equals(other.otherText)) {
            return false;
        }
        if (this.placement == null ? other.placement != null : !this.placement.equals(other.placement)) {
            return false;
        }
        return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
    }
}

