/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;

public class LiteralExpressionImpl
extends DefaultExpression
implements Literal {
    private Object literal = null;

    protected LiteralExpressionImpl() {
    }

    public LiteralExpressionImpl(Object literal) throws IllegalFilterException {
        this.setValue(literal);
    }

    protected LiteralExpressionImpl(int value) {
        try {
            this.setValue(new Integer(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Integers");
        }
    }

    protected LiteralExpressionImpl(long value) {
        try {
            this.setValue(new Long(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Longs");
        }
    }

    protected LiteralExpressionImpl(double value) {
        try {
            this.setValue(new Double(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Doubles");
        }
    }

    protected LiteralExpressionImpl(String value) {
        try {
            this.setValue(value);
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Strings");
        }
    }

    public Object getValue() {
        return this.literal;
    }

    public final void setValue(Object literal) {
        this.literal = literal;
    }

    @Override
    public Object evaluate(Object feature) {
        return this.literal;
    }

    @Override
    public <T> T evaluate(Object feature, Class<T> context) {
        return (T)Converters.convert((Object)this.literal, context);
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl expLit = (LiteralExpressionImpl)obj;
            if (this.literal == null) {
                return expLit.literal == null;
            }
            if (expLit.literal == null) {
                return false;
            }
            if (Filters.getExpressionType(this) == Filters.getExpressionType(expLit) && this.literal.equals(expLit.literal)) {
                return true;
            }
            short expressionType = Filters.getExpressionType(this);
            if (expressionType == 104) {
                return ((Geometry)this.literal).equalsExact(expLit.evaluate(null, Geometry.class));
            }
            if (expressionType == 102) {
                return ((Integer)this.literal).equals(expLit.evaluate(null, Integer.class));
            }
            if (expressionType == 103) {
                return ((String)this.literal).equals(expLit.evaluate(null, String.class));
            }
            if (expressionType == 101) {
                return ((Double)this.literal).equals(expLit.evaluate(null, Double.class));
            }
            if (expressionType == 99) {
                return ((Long)this.literal).equals(expLit.evaluate(null, Long.class));
            }
            Object other = expLit.evaluate(null, this.literal.getClass());
            if (other != null) {
                return other.equals(this.literal);
            }
            other = expLit.getValue();
            Object converted = this.evaluate(null, other.getClass());
            if (converted != null) {
                return converted.equals(other);
            }
            String str1 = this.evaluate(null, String.class);
            String str2 = expLit.evaluate(null, String.class);
            return str1 != null && str2 != null && str1.equals(str2);
        }
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            return this.equals(new LiteralExpressionImpl(other.getValue()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 37 * result + Filters.getExpressionType(this);
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Literal)this, extraData);
    }
}

