/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material3DNative;
import com.supermap.data.Material3DPBR;
import com.supermap.data.MaterialType;
import com.supermap.data.ModelEntityManager;
import com.supermap.data.Point3D;
import com.supermap.data.TextureData;
import com.supermap.data.TextureWrapMode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public class Material3D
extends InternalHandleDisposable {
    ArrayList<TextureData> a = new ArrayList();

    protected Material3D(long handle) {
        this.setHandle(handle, true);
    }

    protected Material3D(long srcHandle, long modelHandle) {
        long l = Material3DNative.jni_New2(srcHandle);
        this.setHandle(l, true);
        long[] lArray = Material3DNative.jni_GetTextureData(srcHandle, modelHandle);
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 0L) continue;
                this.a.add(new TextureData(lArray[i]));
            }
        }
    }

    protected Material3D(long pMaterial, ModelEntityManager pEM) {
        long l = Material3DNative.jni_New2(pMaterial);
        this.setHandle(l, true);
        long[] lArray = Material3DNative.jni_GetTextureData2(pMaterial, pEM.getHandle());
        this.resetTexureData(lArray);
    }

    protected void resetTexureData(long[] textureHandle) {
        this.a();
        if (textureHandle != null && textureHandle.length > 0) {
            this.a = new ArrayList();
            for (int i = 0; i < textureHandle.length; ++i) {
                if (textureHandle[i] == 0L) continue;
                this.a.add(new TextureData(textureHandle[i]));
            }
        }
    }

    void a() {
        if (this.a == null) {
            return;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            this.a.get(i).dispose();
        }
        this.a.clear();
    }

    public Material3D() {
        long l = Material3DNative.jni_New();
        this.setHandle(l, true);
    }

    public Material3D(Material3D materialSrc) {
        ArrayList<TextureData> arrayList;
        if (materialSrc == null) {
            String string = InternalResource.loadString("materialSrc", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = materialSrc.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("materialSrc", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = Material3DNative.jni_New2(l);
        this.setHandle(l2, true);
        this.a();
        if (materialSrc.a != null && (arrayList = materialSrc.a).size() > 0) {
            this.a = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                TextureData textureData = new TextureData(arrayList.get(i).getHandle());
                textureData.setExternal(arrayList.get(i).isExternal());
                this.a.add(textureData);
            }
        }
    }

    public Material3D(String name) {
        long l = Material3DNative.jni_New();
        Material3DNative.jni_setName(l, name);
        this.setHandle(l, true);
    }

    @Override
    public void dispose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        Material3DNative.jni_Delete(this.getHandle());
        this.a();
        this.clearHandle();
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_setName(this.getHandle(), value);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return Material3DNative.jni_GetName(this.getHandle());
    }

    public ArrayList<TextureData> getTextures() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<TextureData> arrayList = new ArrayList<TextureData>();
        if (this.a != null) {
            for (int i = 0; i < this.a.size(); ++i) {
                long l = this.a.get(i).getHandle();
                TextureData textureData = null;
                if (l != 0L) {
                    textureData = new TextureData(this.a.get(i).getHandle());
                } else if (this.a.get(i).isExternal()) {
                    textureData = new TextureData(true);
                }
                textureData.setName(this.a.get(i).getName());
                arrayList.add(textureData);
            }
        }
        return arrayList;
    }

    protected ArrayList<TextureData> getTextureDatas() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setTextures(ArrayList<TextureData> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a();
        String[] stringArray = null;
        if (value.size() > 0) {
            stringArray = new String[value.size()];
            this.a = new ArrayList();
            for (int i = 0; i < value.size(); ++i) {
                TextureData textureData = null;
                textureData = value.get(i).isExternal() ? new TextureData(true) : new TextureData(value.get(i).getHandle());
                textureData.setName(value.get(i).getName());
                this.a.add(i, textureData);
                stringArray[i] = value.get(i).getName();
            }
        }
        Material3DNative.jni_SetTextureName(this.getHandle(), stringArray);
    }

    @Deprecated
    public TextureData getTexture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextureData textureData = null;
        if (this.a != null && this.a.size() > 0) {
            textureData = new TextureData(this.a.get(0).getHandle());
        }
        return textureData;
    }

    @Deprecated
    public void setTexture(TextureData value) throws IOException {
        if (value == null || value.getHandle() == 0L || value.getData() == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = value.getData();
        if (bufferedImage.getWidth() == 0 || bufferedImage.getHeight() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a();
        String[] stringArray = null;
        stringArray = new String[1];
        this.a = new ArrayList();
        TextureData textureData = new TextureData(value.getHandle());
        this.a.add(textureData);
        stringArray[0] = textureData.getName();
        Material3DNative.jni_SetTextureName(this.getHandle(), stringArray);
    }

    public void setMaterialColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetMaterialColor(this.getHandle(), value.getAlpha(), value.getRed(), value.getGreen(), value.getBlue());
    }

    public Color getMaterialColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = Material3DNative.jni_GetMaterialColor(this.getHandle());
        Color color = new Color(nArray[1], nArray[2], nArray[3], nArray[0]);
        nArray = null;
        return color;
    }

    public boolean check() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        if (this.a != null) {
            lArray = new long[this.a.size()];
            for (n = 0; n < this.a.size(); ++n) {
                lArray[n] = this.a.get(n).getHandle();
            }
        }
        n = Material3DNative.jni_Check(this.getHandle(), lArray);
        lArray = null;
        return n != 0;
    }

    public void setPosition(int iTexture, Point3D pnt) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetPosition(this.getHandle(), iTexture, pnt.getX(), pnt.getY(), pnt.getZ());
    }

    public void setRotate(int iTexture, double dbX, double dbY, double dbZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetRotate(this.getHandle(), iTexture, dbX, dbY, dbZ);
    }

    public void setScale(int iTexture, double dbX, double dbY, double dbZ) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetScale(this.getHandle(), iTexture, dbX, dbY, dbZ);
    }

    public void setTextureWrapMode(int iTexture, TextureWrapMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Material3DNative.jni_SetTextureWrapMode(this.getHandle(), iTexture, mode.value());
    }

    public TextureWrapMode getTextureWrapMode(int iTexture) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Material3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Material3DNative.jni_GetTextureWrapMode(this.getHandle(), iTexture);
        return (TextureWrapMode)Enum.parseUGCValue(TextureWrapMode.class, n);
    }

    public void removeTextures() {
        this.a();
        Material3DNative.jni_SetTextureName(this.getHandle(), null);
    }

    public MaterialType getMaterialType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaterialType", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = Material3DNative.jni_GetMaterialType(this.getHandle());
        switch (n) {
            case 3: {
                return MaterialType.COMMON;
            }
        }
        return MaterialType.PBR;
    }

    public int addTexture(String imagePath) {
        if (imagePath.isEmpty()) {
            return -1;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addTexture", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextureData textureData = new TextureData(imagePath);
        if (!this.a.contains(textureData)) {
            this.a.add(textureData);
        }
        return Material3DNative.jni_AddTexture(this.getHandle(), imagePath);
    }

    public int getTextureCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return Material3DNative.jni_GetTextureCount(this.getHandle());
    }

    public static Material3D fromJSON(String jsonFile) {
        if (jsonFile == null || jsonFile.isEmpty()) {
            return null;
        }
        long l = Material3DNative.jni_FromJSON(jsonFile);
        if (Objects.isNull(l)) {
            return null;
        }
        Material3D material3D = null;
        int n = Material3DNative.jni_GetMaterialType(l);
        switch (n) {
            case 3: {
                material3D = new Material3D(l);
                break;
            }
            default: {
                material3D = new Material3DPBR(l);
            }
        }
        int n2 = material3D.getTextureCount();
        material3D.a = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = Material3DNative.jni_GetTextureState(l, i);
            if (stringArray == null || stringArray.length != 2) continue;
            boolean bl = Boolean.parseBoolean(stringArray[0]);
            String string = stringArray[1];
            TextureData textureData = null;
            if (bl) {
                textureData = new TextureData(bl);
                textureData.setName(string);
                material3D.a.add(textureData);
                continue;
            }
            textureData = new TextureData(string);
            if (textureData.fromFile(string)) {
                material3D.a.add(textureData);
                continue;
            }
            textureData.dispose();
        }
        return material3D;
    }

    public boolean toJSON(String jsonFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toJSON", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (jsonFile == null || jsonFile.isEmpty()) {
            return false;
        }
        long[] lArray = new long[this.a.size()];
        for (int i = 0; i < this.a.size(); ++i) {
            lArray[i] = this.a.get(i).isExternal() ? 0L : this.a.get(i).getHandle();
        }
        return Material3DNative.jni_ToJSON(this.getHandle(), jsonFile, lArray);
    }
}

