/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoRectangularRingNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoRectangularRing
extends Geometry3D {
    public GeoRectangularRing() {
        long l = GeoRectangularRingNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoRectangularRing(GeoRectangularRing geoRectangularRing) {
        if (geoRectangularRing == null) {
            String string = InternalResource.loadString("GeoRectangularRing", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRectangularRing.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoRectangularRing", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRectangularRingNative.jni_Clone(geoRectangularRing.getHandle(), this.getHandle());
    }

    public GeoRectangularRing(Point3D position, double length, double width, double pipeRadius, double chamferRadius) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoRectangularRingNative.jni_New3(dArray, length, width, pipeRadius, chamferRadius);
        this.setHandle(l, true);
    }

    @Override
    public GeoRectangularRing clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRectangularRing(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoRectangularRing", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRectangularRingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangularRingNative.jni_GetLength(this.getHandle());
    }

    public void setLength(double length) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLength", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangularRingNative.jni_SetLength(this.getHandle(), length);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangularRingNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangularRingNative.jni_SetWidth(this.getHandle(), width);
    }

    public double getPipeRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangularRingNative.jni_GetPipeRadius(this.getHandle());
    }

    public void setPipeRadius(double pipeRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangularRingNative.jni_SetPipeRadius(this.getHandle(), pipeRadius);
    }

    public double getChamferRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChamferRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangularRingNative.jni_GetChamferRadius(this.getHandle());
    }

    public void setChamferRadius(double chamferRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setChamferRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangularRingNative.jni_SetChamferRadius(this.getHandle(), chamferRadius);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoRectangularRingNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

