/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridStatisticsMode;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;

public class ZonalStatisticsAnalystParameter {
    private Dataset a;
    private Dataset b;
    private Datasource c;
    private GridStatisticsMode d;
    private PixelFormat e;
    private String f;
    private String g;
    private String h;
    private boolean i;

    public ZonalStatisticsAnalystParameter() {
        this.a = null;
        this.b = null;
        this.i = true;
        this.e = PixelFormat.SINGLE;
        this.d = GridStatisticsMode.SUM;
        this.f = "SmID";
        this.g = "";
        this.h = "";
        this.c = null;
    }

    public ZonalStatisticsAnalystParameter(ZonalStatisticsAnalystParameter zonalStatisticsAnalystParameter) {
        this.a = zonalStatisticsAnalystParameter.a;
        this.b = zonalStatisticsAnalystParameter.b;
        this.c = zonalStatisticsAnalystParameter.c;
        this.d = zonalStatisticsAnalystParameter.d;
        this.e = zonalStatisticsAnalystParameter.e;
        this.f = zonalStatisticsAnalystParameter.f;
        this.g = zonalStatisticsAnalystParameter.g;
        this.h = zonalStatisticsAnalystParameter.h;
        this.i = zonalStatisticsAnalystParameter.i;
    }

    public Dataset getZonalDataset() {
        return this.a;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setZonalDataset(Dataset zonalDataset) {
        if (zonalDataset.getType() == DatasetType.REGION) {
            this.a = zonalDataset;
            return;
        }
        if (zonalDataset.getType() != DatasetType.GRID) {
            String string = InternalResourceSpatialanalyst.loadString("Only support REGION or GRID", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = (DatasetGrid)zonalDataset;
        if (datasetGrid.getPixelFormat() != PixelFormat.UBIT1 && datasetGrid.getPixelFormat() != PixelFormat.UBIT4 && datasetGrid.getPixelFormat() != PixelFormat.UBIT8 && datasetGrid.getPixelFormat() != PixelFormat.UBIT16) {
            String string = InternalResourceSpatialanalyst.loadString("Only support UBIT1 or UBIT4 or UBIT8 or UBIT16", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = zonalDataset;
    }

    public Dataset getValueDataset() {
        return this.b;
    }

    public void setValueDataset(Dataset valueDataset) {
        this.b = valueDataset;
    }

    public Datasource getTargetDatasource() {
        return this.c;
    }

    public void setTargetDatasource(Datasource targetDatasource) {
        this.c = targetDatasource;
    }

    public GridStatisticsMode getStatisticsMode() {
        return this.d;
    }

    public void setStatisticsMode(GridStatisticsMode value) {
        this.d = value;
    }

    @Deprecated
    public PixelFormat getPixelFormat() {
        return this.e;
    }

    @Deprecated
    public void setPixelFormat(PixelFormat pixelFormat) {
        this.e = pixelFormat;
    }

    public String getZonalFieldName() {
        return this.f;
    }

    public void setZonalFieldName(String zonalFieldName) {
        this.f = zonalFieldName;
    }

    public String getTargetDatasetName() {
        return this.g;
    }

    public void setTargetDatasetName(String outputDatasetName) {
        this.g = outputDatasetName;
    }

    public String getTargetTableName() {
        return this.h;
    }

    public void setTargetTableName(String outputTableName) {
        this.h = outputTableName;
    }

    public boolean isIgnoreNoValue() {
        return this.i;
    }

    public void setIgnoreNoValue(boolean isIgnoreNoValue) {
        this.i = isIgnoreNoValue;
    }
}

