/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ComputeDistanceResult;
import com.supermap.analyst.spatialanalyst.Generalization;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProximityAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsField;
import com.supermap.analyst.spatialanalyst.StatisticsPoint;
import com.supermap.analyst.spatialanalyst.StatisticsType;
import com.supermap.analyst.spatialanalyst.a;
import com.supermap.analyst.spatialanalyst.b;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.Vector;

public class ProximityAnalyst {
    private static transient Vector<SteppedListener> a;
    private static License b;

    private ProximityAnalyst() {
    }

    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePoint, outputDatasource, outputDatasetName, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePoint);
            if (sourcePoint == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (outputDatasource == null || l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l3 = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            long l4 = ProximityAnalystNative.jni_CreateThiessenPolygon(l, l2, outputDatasetName, l3);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePointRecordset, outputDatasource, outputDatasetName, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePointRecordset);
            if (sourcePointRecordset == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (outputDatasource == null || l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l3 = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            long l4 = ProximityAnalystNative.jni_CreateThiessenPolygonByRecordset(l, l2, outputDatasetName, l3);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)sourcePointRecordset);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector createThiessenPolygon(Point2Ds sourcePoints, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePoints, outputDatasource, outputDatasetName, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createThiessenPolygon(Point2Ds sourcePoints, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            if (sourcePoints == null || sourcePoints.getCount() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (outputDatasource == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            int n = sourcePoints.getCount();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = sourcePoints.getItem(i).getX();
                dArray2[i] = sourcePoints.getItem(i).getY();
            }
            long l3 = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2Ds(dArray, dArray2, l, outputDatasetName, l2);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            DatasetVector datasetVector = null;
            if (l3 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion[] createThiessenPolygon(DatasetVector sourcePoint, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePoint, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoRegion[] createThiessenPolygon(DatasetVector sourcePoint, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePoint);
            if (sourcePoint == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            Recordset recordset = sourcePoint.getRecordset(false, CursorType.STATIC);
            GeoRegion[] geoRegionArray = ProximityAnalyst.createThiessenPolygon(recordset, clipRegion);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            recordset.dispose();
            GeoRegion[] geoRegionArray2 = geoRegionArray;
            return geoRegionArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion[] createThiessenPolygon(Recordset sourcePointRecordset, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePointRecordset, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoRegion[] createThiessenPolygon(Recordset sourcePointRecordset, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            String string;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePointRecordset);
            if (sourcePointRecordset == null || l == 0L) {
                String string2 = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
                String string3 = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            Datasource datasource = sourcePointRecordset.getDataset().getDatasource();
            DatasetVector datasetVector = ProximityAnalyst.createThiessenPolygon(sourcePointRecordset, datasource, string = datasource.getDatasets().getAvailableDatasetName("name"), clipRegion);
            if (datasetVector == null) {
                GeoRegion[] geoRegionArray = new GeoRegion[]{};
                return geoRegionArray;
            }
            ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
            Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                GeoRegion geoRegion = (GeoRegion)recordset.getGeometry();
                arrayList.add(geoRegion);
                recordset.moveNext();
            }
            int n = arrayList.size();
            GeoRegion[] geoRegionArray = new GeoRegion[n];
            for (int i = 0; i < n; ++i) {
                geoRegionArray[i] = (GeoRegion)arrayList.get(i);
            }
            recordset.dispose();
            datasource.getDatasets().delete(datasetVector.getName());
            GeoRegion[] geoRegionArray2 = geoRegionArray;
            return geoRegionArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static GeoRegion[] createThiessenPolygon(Point2Ds sourcePoints, GeoRegion clipRegion) {
        return ProximityAnalyst.createThiessenPolygon(sourcePoints, clipRegion, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoRegion[] createThiessenPolygon(Point2Ds sourcePoints, GeoRegion clipRegion, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            if (sourcePoints == null || sourcePoints.getCount() < 3) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            int n = sourcePoints.getCount();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = sourcePoints.getItem(i).getX();
                dArray2[i] = sourcePoints.getItem(i).getY();
            }
            long[] lArray = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2DsSecond(dArray, dArray2, l);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            GeoRegion[] geoRegionArray = null;
            if (lArray == null) {
                geoRegionArray = new GeoRegion[]{};
            } else {
                int n2 = lArray.length;
                geoRegionArray = new GeoRegion[n2];
                for (int i = 0; i < n2; ++i) {
                    geoRegionArray[i] = (GeoRegion)InternalGeometrySpatialanalyst.createInstance(lArray[i]);
                }
            }
            GeoRegion[] geoRegionArray2 = geoRegionArray;
            return geoRegionArray2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeMinDistance(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            boolean bl = ProximityAnalyst.a(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, com.supermap.analyst.spatialanalyst.b.a);
            return bl;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeMinDistance(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            boolean bl = ProximityAnalyst.a(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, com.supermap.analyst.spatialanalyst.b.a);
            return bl;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static ComputeDistanceResult[] computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeMinDistance(sourceRecordset, referenceRecordset, minDistance, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputeDistanceResult[] computeMinDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ComputeDistanceResult[] computeDistanceResultArray = ProximityAnalyst.a(sourceRecordset, referenceRecordset, minDistance, maxDistance, com.supermap.analyst.spatialanalyst.b.a);
            return computeDistanceResultArray;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static ComputeDistanceResult[] computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeMinDistance(sourceGeometries, referenceRecordset, minDistance, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputeDistanceResult[] computeMinDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ComputeDistanceResult[] computeDistanceResultArray = ProximityAnalyst.a(sourceGeometries, referenceRecordset, minDistance, maxDistance, com.supermap.analyst.spatialanalyst.b.a);
            return computeDistanceResultArray;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeRangeDistance(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            boolean bl = ProximityAnalyst.a(sourceRecordset, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, com.supermap.analyst.spatialanalyst.b.b);
            return bl;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static boolean computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.computeRangeDistance(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            boolean bl = ProximityAnalyst.a(sourceGeometries, referenceRecordset, minDistance, maxDistance, outputDatasource, outputDatasetName, com.supermap.analyst.spatialanalyst.b.b);
            return bl;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static ComputeDistanceResult[] computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeRangeDistance(sourceRecordset, referenceRecordset, minDistance, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputeDistanceResult[] computeRangeDistance(Recordset sourceRecordset, Recordset referenceRecordset, double minDistance, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ComputeDistanceResult[] computeDistanceResultArray = ProximityAnalyst.a(sourceRecordset, referenceRecordset, minDistance, maxDistance, com.supermap.analyst.spatialanalyst.b.b);
            return computeDistanceResultArray;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static ComputeDistanceResult[] computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance) {
        return ProximityAnalyst.computeRangeDistance(sourceGeometries, referenceRecordset, minDistance, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputeDistanceResult[] computeRangeDistance(Geometry[] sourceGeometries, Recordset referenceRecordset, double minDistance, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ComputeDistanceResult[] computeDistanceResultArray = ProximityAnalyst.a(sourceGeometries, referenceRecordset, minDistance, maxDistance, com.supermap.analyst.spatialanalyst.b.b);
            return computeDistanceResultArray;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static boolean a(Recordset recordset, Recordset recordset2, double d, double d2, Datasource datasource, String string, b b2) {
        ProximityAnalyst.b(recordset, recordset2, d, d2, b2);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset)};
        if (datasource == null) {
            String string2 = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        if (l == 0L) {
            String string3 = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string == null) {
            String string4 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(string);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset2);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n, bl, l3, l2, d, d2, b2.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset2);
        if (!bl2) {
            datasource.getDatasets().delete(string);
        }
        return bl2;
    }

    private static boolean a(Geometry[] geometryArray, Recordset recordset, double d, double d2, Datasource datasource, String string, b b2) {
        boolean bl;
        ProximityAnalyst.b(geometryArray, recordset, d, d2, b2);
        int n = 0;
        for (bl = false; bl < geometryArray.length; bl += 1) {
            if (geometryArray[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string2 = InternalResourceSpatialanalyst.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i] == null) continue;
            if (geometryArray[i].getType() != GeometryType.GEOPOINT) {
                String string3 = InternalResourceSpatialanalyst.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            lArray[n3++] = InternalHandleSpatialanalyst.getHandle((InternalHandle)geometryArray[i]);
        }
        if (datasource == null) {
            String string4 = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
        if (l == 0L) {
            String string5 = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (string == null) {
            String string6 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(string);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n2, bl, l3, l2, d, d2, b2.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometryArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        if (!bl2) {
            datasource.getDatasets().delete(string);
        }
        return bl2;
    }

    private static ComputeDistanceResult[] a(Recordset recordset, Recordset recordset2, double d, double d2, b b2) {
        ProximityAnalyst.b(recordset, recordset2, d, d2, b2);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset)};
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset2);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n, bl, l, d, d2, b2.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset2);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            a a2 = new a(lArray2[i]);
            if (a2.a() < 0) {
                a2.dispose();
                continue;
            }
            double d3 = a2.b();
            int[] nArray = a2.c();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(a2.a());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d3);
            computeDistanceResultArray[i] = computeDistanceResult;
            a2.dispose();
        }
        return computeDistanceResultArray;
    }

    private static ComputeDistanceResult[] a(Geometry[] geometryArray, Recordset recordset, double d, double d2, b b2) {
        boolean bl;
        ProximityAnalyst.b(geometryArray, recordset, d, d2, b2);
        int n = 0;
        for (bl = false; bl < geometryArray.length; bl += 1) {
            if (geometryArray[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string = InternalResourceSpatialanalyst.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i] == null) continue;
            if (geometryArray[i].getType() != GeometryType.GEOPOINT) {
                String string = InternalResourceSpatialanalyst.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[n3++] = InternalHandleSpatialanalyst.getHandle((InternalHandle)geometryArray[i]);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n2, bl, l, d, d2, b2.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometryArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            a a2 = new a(lArray2[i]);
            if (a2.a() < 0) {
                a2.dispose();
                continue;
            }
            double d3 = a2.b();
            int[] nArray = a2.c();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(a2.a());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d3);
            computeDistanceResultArray[i] = computeDistanceResult;
            a2.dispose();
        }
        return computeDistanceResultArray;
    }

    private static boolean b(Geometry[] geometryArray, Recordset recordset, double d, double d2, b b2) {
        if (recordset == null) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = recordset.getDataset().getType();
        if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.NETWORK) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType == DatasetType.NETWORK && recordset.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            d2 = -1.0;
        }
        if (b2 == com.supermap.analyst.spatialanalyst.b.a && d2 == 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (b2 == com.supermap.analyst.spatialanalyst.b.b && d2 <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 > 0.0 && d2 < d) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray == null) {
            String string = InternalResourceSpatialanalyst.loadString("sourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        return true;
    }

    private static boolean b(Recordset recordset, Recordset recordset2, double d, double d2, b b2) {
        PrjCoordSys prjCoordSys;
        if (recordset2 == null) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset2);
        if (l == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            d2 = -1.0;
        }
        if (b2 == com.supermap.analyst.spatialanalyst.b.a && d2 == 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (b2 == com.supermap.analyst.spatialanalyst.b.b && d2 <= 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 > 0.0 && d2 < d) {
            String string = InternalResourceSpatialanalyst.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = recordset.getDataset().getType();
        if (datasetType != DatasetType.POINT) {
            String string = InternalResourceSpatialanalyst.loadString("sourceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType2 = recordset2.getDataset().getType();
        if (datasetType2 != DatasetType.POINT && datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.REGION && datasetType2 != DatasetType.NETWORK) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType2 == DatasetType.NETWORK && recordset2.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResourceSpatialanalyst.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSys prjCoordSys2 = recordset.getDataset().getPrjCoordSys();
        if (!Generalization.isPrjCoordSysIdentical(prjCoordSys2, prjCoordSys = recordset2.getDataset().getPrjCoordSys())) {
            String string = InternalResourceSpatialanalyst.loadString("sourceRecordset and referenceRecordset", "Projection_Not_Same", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public static DatasetVector rarefyPoints(DatasetVector sourceDataset, double radius, String resultDatasetName, Datasource outputDatasource, boolean isSaveAttributes) {
        return ProximityAnalyst.rarefyPoints(sourceDataset, radius, resultDatasetName, outputDatasource, isSaveAttributes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector rarefyPoints(DatasetVector sourceDataset, double radius, String resultDatasetName, Datasource outputDatasource, boolean isSaveAttributes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (outputDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (resultDatasetName == null || resultDatasetName.isEmpty()) {
                String string = InternalResourceSpatialanalyst.loadString("resultDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (radius < 0.0 || radius == 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getType() != DatasetType.POINT) {
                String string = InternalResourceSpatialanalyst.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(outputDatasource.getDatasets().getAvailableDatasetName(resultDatasetName));
            datasetVectorInfo.setType(sourceDataset.getType());
            DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
            if (datasetVector == null) {
                DatasetVector datasetVector2 = null;
                return datasetVector2;
            }
            datasetVector.open();
            datasetVector.setPrjCoordSys(sourceDataset.getPrjCoordSys());
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            boolean bl = false;
            bl = ProximityAnalystNative.jni_RarefyDt(l, l3, radius, isSaveAttributes);
            if (bl) {
                DatasetVector datasetVector3 = datasetVector;
                return datasetVector3;
            }
            outputDatasource.getDatasets().delete(datasetVector.getName());
            DatasetVector datasetVector4 = null;
            return datasetVector4;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector summaryPoints(DatasetVector sourceDataset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes) {
        return ProximityAnalyst.summaryPoints(sourceDataset, radius, unit, statisticFields, outputDatasource, resultDatasetName, isRandomSavePnt, isSaveAttributes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector summaryPoints(DatasetVector sourceDataset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            QueryParameter queryParameter = new QueryParameter();
            queryParameter.setCursorType(CursorType.STATIC);
            Recordset recordset = sourceDataset.query(queryParameter);
            DatasetVector datasetVector = null;
            datasetVector = ProximityAnalyst.summaryPoints(recordset, radius, unit, statisticFields, outputDatasource, resultDatasetName, isRandomSavePnt, isSaveAttributes);
            if (recordset != null) {
                recordset.dispose();
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector summaryPoints(Recordset recordset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes) {
        return ProximityAnalyst.summaryPoints(recordset, radius, unit, statisticFields, outputDatasource, resultDatasetName, isRandomSavePnt, isSaveAttributes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector summaryPoints(Recordset recordset, double radius, Unit unit, StatisticsField[] statisticFields, Datasource outputDatasource, String resultDatasetName, boolean isRandomSavePnt, boolean isSaveAttributes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (recordset == null) {
                String string = InternalResourceSpatialanalyst.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)recordset);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("recordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (outputDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (resultDatasetName == null || resultDatasetName.isEmpty()) {
                String string = InternalResourceSpatialanalyst.loadString("resultDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (radius < 0.0 || radius == 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (recordset.getDataset().getType() != DatasetType.POINT) {
                String string = InternalResourceSpatialanalyst.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(resultDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("resultDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            int n = statisticFields.length;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int[] nArray = new int[n];
            FieldInfos fieldInfos = recordset.getFieldInfos();
            DatasetVector datasetVector = recordset.getDataset();
            for (int i = 0; i < statisticFields.length; ++i) {
                int n2 = fieldInfos.indexOf(statisticFields[i].getSourceField());
                if (n2 == -1) {
                    String string = InternalResourceSpatialanalyst.loadString("SourceField", "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                stringArray[i] = statisticFields[i].getSourceField();
                if (isSaveAttributes) {
                    if (!datasetVector.isAvailableFieldName(statisticFields[i].getResultField())) {
                        String string = InternalResourceSpatialanalyst.loadString("ResultField", "FieldInfo_NameIsNotAvaliable", "spatialanalyst_resources");
                        throw new IllegalArgumentException(string);
                    }
                } else if (statisticFields[i].getResultField() == null || statisticFields[i].getResultField().startsWith("sm")) {
                    String string = InternalResourceSpatialanalyst.loadString("ResultField", "FieldInfo_NameIsNotAvaliable", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                stringArray2[i] = statisticFields[i].getResultField();
                nArray[i] = statisticFields[i].getMode().value();
            }
            long l3 = ProximityAnalystNative.jni_summaryPoints(l, radius, unit.value(), stringArray, stringArray2, nArray, l2, resultDatasetName, isSaveAttributes, isRandomSavePnt);
            DatasetVector datasetVector2 = null;
            if (l3 != 0L) {
                datasetVector2 = InternalDatasetVector.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector2);
            }
            DatasetVector datasetVector3 = datasetVector2;
            return datasetVector3;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static StatisticsPoint[] rarefyPoints(StatisticsPoint[] sourcePoints, double radius) {
        return ProximityAnalyst.rarefyPoints(sourcePoints, radius, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticsPoint[] rarefyPoints(StatisticsPoint[] sourcePoints, double radius, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourcePoints == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourcePoints.length == 0) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoints", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (radius < 0.0 || radius == 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            int n = sourcePoints.length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                if (sourcePoints[i].getPoint() != null) {
                    dArray[i] = sourcePoints[i].getPoint().getX();
                    dArray2[i] = sourcePoints[i].getPoint().getY();
                    nArray[i] = sourcePoints[i].getStatisticsCount();
                    continue;
                }
                nArray[i] = 0;
            }
            double[] dArray3 = new double[n];
            double[] dArray4 = new double[n];
            int[] nArray2 = new int[n];
            int n2 = ProximityAnalystNative.jni_RarefyDt2(dArray, dArray2, nArray, n, radius, dArray3, dArray4, nArray2);
            if (n2 > 0) {
                StatisticsPoint[] statisticsPointArray = new StatisticsPoint[n2];
                for (int i = 0; i < n2; ++i) {
                    statisticsPointArray[i] = new StatisticsPoint(new Point2D(dArray3[i], dArray4[i]), nArray2[i]);
                }
                StatisticsPoint[] statisticsPointArray2 = statisticsPointArray;
                return statisticsPointArray2;
            }
            StatisticsPoint[] statisticsPointArray = null;
            return statisticsPointArray;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = b;
        synchronized (object) {
            n = b.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (a == null) {
            a = new Vector();
        }
        if (!a.contains(l)) {
            a.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (a != null && a.contains(l)) {
            a.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (a != null) {
            Vector<SteppedListener> vector = a;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "ProximityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire(a, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes) {
        return ProximityAnalyst.createThiessenPolygon(sourcePoint, outputDatasource, outputDatasetName, clipRegion, statisticsFields, statisticsTypes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createThiessenPolygon(DatasetVector sourcePoint, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePoint);
            if (sourcePoint == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!sourcePoint.getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (outputDatasource == null || l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            ProximityAnalyst.a(sourcePoint, statisticsFields, statisticsTypes);
            int[] nArray = new int[statisticsTypes.length];
            for (int i = 0; i < statisticsTypes.length; ++i) {
                nArray[i] = statisticsTypes[i].value();
            }
            long l3 = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            long l4 = ProximityAnalystNative.jni_CreateThiessenPolygon2(l, l2, outputDatasetName, l3, statisticsFields, nArray);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes) {
        return ProximityAnalyst.createThiessenPolygon(sourcePointRecordset, outputDatasource, outputDatasetName, clipRegion, statisticsFields, statisticsTypes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetVector createThiessenPolygon(Recordset sourcePointRecordset, Datasource outputDatasource, String outputDatasetName, GeoRegion clipRegion, String[] statisticsFields, StatisticsType[] statisticsTypes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            ProximityAnalyst.a();
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourcePointRecordset);
            if (sourcePointRecordset == null || l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!sourcePointRecordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (outputDatasource == null || l2 == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            ProximityAnalyst.a(sourcePointRecordset.getDataset(), statisticsFields, statisticsTypes);
            long l3 = 0L;
            if (clipRegion != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion) != 0L) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)clipRegion);
            }
            int[] nArray = new int[statisticsTypes.length];
            for (int i = 0; i < statisticsTypes.length; ++i) {
                nArray[i] = statisticsTypes[i].value();
            }
            long l4 = ProximityAnalystNative.jni_CreateThiessenPolygonByRecordset2(l, l2, outputDatasetName, l3, statisticsFields, nArray);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)sourcePointRecordset);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)clipRegion);
            DatasetVector datasetVector = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
            }
            DatasetVector datasetVector2 = datasetVector;
            return datasetVector2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    private static void a(DatasetVector datasetVector, String[] stringArray, StatisticsType[] statisticsTypeArray) {
        if (stringArray == null || statisticsTypeArray == null) {
            return;
        }
        if (datasetVector == null) {
            return;
        }
        if (stringArray == null && statisticsTypeArray != null || stringArray != null && statisticsTypeArray == null) {
            String string = InternalResourceSpatialanalyst.loadString("statisticFields && statisticTypes", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (stringArray.length != statisticsTypeArray.length) {
            String string = InternalResourceSpatialanalyst.loadString("statisticFields && statisticTypes", "StatisticsFieldAndStaticsTypeCountMustEqual", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && !stringArray[i].isEmpty()) continue;
            String string = InternalResourceSpatialanalyst.loadString(String.format("statisticFields[%d]", i), "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public static boolean autoComputeProjectPoint(Recordset sourceRecordset, Recordset referenceRecordset, double maxDistance, Datasource outputDatasource, String outputDatasetName) {
        return ProximityAnalyst.autoComputeProjectPoint(sourceRecordset, referenceRecordset, maxDistance, outputDatasource, outputDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean autoComputeProjectPoint(Recordset sourceRecordset, Recordset referenceRecordset, double maxDistance, Datasource outputDatasource, String outputDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            double d = 0.0;
            b b2 = com.supermap.analyst.spatialanalyst.b.a;
            ProximityAnalyst.b(sourceRecordset, referenceRecordset, d, maxDistance, b2);
            int n = 1;
            boolean bl = false;
            long[] lArray = new long[]{InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceRecordset)};
            if (outputDatasource == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            if (l == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (outputDatasetName == null) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(outputDatasetName);
            datasetVectorInfo.setType(DatasetType.TABULAR);
            DatasetVector datasetVector = outputDatasource.getDatasets().create(datasetVectorInfo);
            if (datasetVector == null) {
                boolean bl2 = false;
                return bl2;
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetVector);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)referenceRecordset);
            boolean bl3 = ProximityAnalystNative.jni_autoComputeProjectPoint(lArray, n, bl, l3, l2, d, maxDistance, b2.value());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)referenceRecordset);
            if (!bl3) {
                outputDatasource.getDatasets().delete(outputDatasetName);
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        b = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

