/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.BinaryLogicAbstract;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public abstract class LogicFilterImpl
extends BinaryLogicAbstract {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");
    int cachedHash = 0;

    @Deprecated
    protected LogicFilterImpl() {
        this(new ArrayList<Filter>());
    }

    protected LogicFilterImpl(List<Filter> children) {
        super(children);
    }

    @Deprecated
    protected LogicFilterImpl(Filter filter) throws IllegalFilterException {
        this();
        this.children.add(filter);
    }

    protected LogicFilterImpl(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        this();
        this.children.add(filter1);
        this.addFilter(filter2);
    }

    public final void addFilter(Filter filter) throws IllegalFilterException {
        this.cachedHash = 0;
        short filterType = Filters.getFilterType(this);
        if (filterType == 3 && this.children.size() != 0) {
            throw new IllegalFilterException("Attempted to add an more than one filter to a NOT filter.");
        }
        this.children.add(filter);
    }

    public Iterator getFilterIterator() {
        return this.children.iterator();
    }

    List getSubFilters() {
        return this.children;
    }

    public String toString() {
        String returnString = "[";
        String operator = "";
        Iterator iterator = this.children.iterator();
        short filterType = Filters.getFilterType(this);
        if (filterType == 1) {
            operator = " OR ";
        } else if (filterType == 2) {
            operator = " AND ";
        } else if (filterType == 3) {
            return "[ NOT " + iterator.next().toString() + " ]";
        }
        while (iterator.hasNext()) {
            returnString = returnString + iterator.next().toString();
            if (!iterator.hasNext()) continue;
            returnString = returnString + operator;
        }
        return returnString + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            LogicFilterImpl logFilter = (LogicFilterImpl)obj;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + (Filters.getFilterType(logFilter) == Filters.getFilterType(this)));
                LOGGER.finest("same size:" + (logFilter.getSubFilters().size() == this.children.size()) + "; inner size: " + logFilter.getSubFilters().size() + "; outer size: " + this.children.size());
                LOGGER.finest("contains:" + logFilter.getSubFilters().containsAll(this.children));
            }
            return Filters.getFilterType(logFilter) == Filters.getFilterType(this) && logFilter.getSubFilters().size() == this.children.size() && logFilter.getSubFilters().containsAll(this.children);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHash == 0) {
            int result = 17;
            short filterType = Filters.getFilterType(this);
            result = 37 * result + filterType;
            this.cachedHash = result = 37 * result + this.children.hashCode();
        }
        return this.cachedHash;
    }

    public abstract Object accept(FilterVisitor var1, Object var2);
}

