/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.sort.FeatureBlockReader;
import org.geotools.data.sort.SimpleFeatureIO;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class MergeSortReader
implements SimpleFeatureReader {
    List<FeatureBlockReader> readers;
    SimpleFeatureIO io;
    SimpleFeatureType schema;
    Comparator<SimpleFeature> comparator;

    public MergeSortReader(SimpleFeatureType schema, SimpleFeatureIO io, List<FeatureBlockReader> readers, Comparator<SimpleFeature> comparator) {
        this.schema = schema;
        this.comparator = comparator;
        this.readers = readers;
        this.io = io;
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature sf;
        if (this.readers.size() == 0) {
            throw new NoSuchElementException();
        }
        int selected = 0;
        for (int i = 1; i < this.readers.size(); ++i) {
            SimpleFeature cf;
            sf = this.readers.get(selected).feature();
            if (this.comparator.compare(sf, cf = this.readers.get(i).feature()) <= 0) continue;
            selected = i;
        }
        FeatureBlockReader reader = this.readers.get(selected);
        sf = reader.feature();
        if (reader.next() == null) {
            this.readers.remove(selected);
        }
        return sf;
    }

    public boolean hasNext() throws IOException {
        return this.readers.size() > 0;
    }

    public void close() throws IOException {
        this.io.close(true);
    }
}

