/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TractionLineNative;
import com.supermap.data.TractionLineType;
import java.awt.Color;

public class TractionLine
extends InternalHandleDisposable {
    public TractionLine() {
        long l = TractionLineNative.jni_New();
        this.setHandle(l, true);
    }

    TractionLine(long handle) {
        this.setHandle(handle, false);
    }

    public TractionLine(TractionLine tractionLine) {
        if (tractionLine == null) {
            String string = InternalResource.loadString("TractionLine(TractionLine tractionLine)", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (tractionLine.getHandle() == 0L) {
            String string = InternalResource.loadString("TractionLine(TractionLine tractionLine)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TractionLineNative.jni_Clone(tractionLine.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(tractionLine);
    }

    public TractionLine clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TractionLine(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TractionLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public void setEnable(boolean enable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEnable(boolean enable)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetEnable(this.getHandle(), enable);
    }

    public boolean isEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEnable()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TractionLineNative.jni_IsEnable(this.getHandle());
    }

    public void setType(TractionLineType type) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(TractionLineType type)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetType(this.getHandle(), type.value());
    }

    public TractionLineType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TractionLineNative.jni_GetType(this.getHandle());
        return new TractionLineType(n, n);
    }

    public void setOffsetX(double offsetX) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(double offsetX)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetOffsetX(this.getHandle(), offsetX);
    }

    public double getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TractionLineNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetY(double offsetY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(double offsetY)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetOffsetY(this.getHandle(), offsetY);
    }

    public double getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TractionLineNative.jni_GetOffsetY(this.getHandle());
    }

    public void setLineStyle(int lineStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineStyle(int lineType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetLineStyle(this.getHandle(), lineStyle);
    }

    public int getLineStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TractionLineNative.jni_GetLineStyle(this.getHandle());
    }

    public void setLineWidth(double lineWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineWidth(double lineWidth)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetLineWidth(this.getHandle(), lineWidth);
    }

    public double getLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TractionLineNative.jni_GetLineWidth(this.getHandle());
    }

    public void setLineColor(Color lineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor(Color lineColor)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TractionLineNative.jni_SetLineColor(this.getHandle(), lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), lineColor.getAlpha());
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = TractionLineNative.jni_GetLineColor(this.getHandle());
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }
}

