/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.SteppedDispatcher;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelperNative;
import com.supermap.data.SteppedListener;
import java.util.Collection;
import javax.swing.event.EventListenerList;

public class SteppedHelper {
    private static final ThreadLocal<SteppedHelper> a = new ThreadLocal();
    private long b = SteppedHelperNative.jni_GetNativeThreadID();
    private final SteppedDispatcher c = new SteppedDispatcher(new SteppedListener[0]);

    public long getNativeThreadID() {
        return this.b;
    }

    public void setNativeThreadID(int nativeThreadID) {
        this.b = nativeThreadID;
    }

    public SteppedDispatcher getDispatcher() {
        return this.c;
    }

    public void cancel() {
        if (this.b != 0L) {
            SteppedHelperNative.jni_SetCancel(this.b, true);
        }
    }

    public static SteppedHelper addListeners(SteppedListener ... listeners) {
        SteppedHelper steppedHelper = SteppedHelper.a();
        if (listeners != null) {
            steppedHelper.getDispatcher().addListeners(listeners);
        }
        return steppedHelper;
    }

    private static SteppedHelper a() {
        SteppedHelper steppedHelper = a.get();
        if (steppedHelper == null) {
            a.set(new SteppedHelper());
        }
        return a.get();
    }

    public static void removeListeners(SteppedListener ... listeners) {
        if (listeners == null) {
            return;
        }
        SteppedHelper steppedHelper = a.get();
        if (steppedHelper != null) {
            steppedHelper.getDispatcher().removeListeners(listeners);
            steppedHelper.setNativeThreadID(0);
            a.remove();
        }
    }

    public static void fire(Collection<SteppedListener> listeners, SteppedEvent event) {
        SteppedHelper.fire(listeners == null ? null : listeners.toArray(new SteppedListener[0]), event);
    }

    public static void fire(EventListenerList listenerList, SteppedEvent event) {
        SteppedListener[] steppedListenerArray = listenerList == null ? null : (SteppedListener[])listenerList.getListeners(SteppedListener.class);
        SteppedHelper.fire(steppedListenerArray, event);
    }

    public static void fire(SteppedListener[] listeners, SteppedEvent event) {
        SteppedHelper steppedHelper = a.get();
        if (steppedHelper != null && !steppedHelper.getDispatcher().isEmpty()) {
            steppedHelper.getDispatcher().stepped(event);
        } else if (listeners != null) {
            for (SteppedListener steppedListener : listeners) {
                if (event.getCancel()) break;
                steppedListener.stepped(event);
            }
        }
    }
}

