/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.SceneAddedEvent;
import com.supermap.data.SceneAddedListener;
import com.supermap.data.SceneClearedEvent;
import com.supermap.data.SceneClearedListener;
import com.supermap.data.SceneClearingEvent;
import com.supermap.data.SceneClearingListener;
import com.supermap.data.SceneRemovedEvent;
import com.supermap.data.SceneRemovedListener;
import com.supermap.data.SceneRemovingEvent;
import com.supermap.data.SceneRemovingListener;
import com.supermap.data.SceneRenamedEvent;
import com.supermap.data.SceneRenamedListener;
import com.supermap.data.SceneRenamingEvent;
import com.supermap.data.SceneRenamingListener;
import com.supermap.data.ScenesNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Scenes {
    private Workspace h;
    transient CopyOnWriteArrayList<SceneAddedListener> a;
    transient CopyOnWriteArrayList<SceneRemovingListener> b;
    transient CopyOnWriteArrayList<SceneRemovedListener> c;
    transient CopyOnWriteArrayList<SceneClearingListener> d;
    transient CopyOnWriteArrayList<SceneClearedListener> e;
    transient CopyOnWriteArrayList<SceneRenamingListener> f;
    transient CopyOnWriteArrayList<SceneRenamedListener> g;

    Scenes(Workspace workspace) {
        this.h = workspace;
    }

    public String get(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetItem(this.h.getHandle(), index);
    }

    public int getCount() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ScenesNative.jni_GetCount(this.h.getHandle());
    }

    public int add(String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = ScenesNative.jni_Add(this.h.getHandle(), name, xml);
        if (n > -1) {
            SceneAddedEvent sceneAddedEvent = new SceneAddedEvent(this, name);
            this.fireAdded(sceneAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ScenesNative.jni_Insert(this.h.getHandle(), index, name, xml);
    }

    public boolean setSceneXML(int index, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return ScenesNative.jni_SetSceneXML(this.h.getHandle(), index, xml);
    }

    public boolean setSceneXML(String name, String xml) {
        int n;
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setSceneXML(n, xml);
    }

    public String getSceneXML(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetSceneXML(this.h.getHandle(), index);
    }

    public String getSceneXML(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return ScenesNative.jni_GetSceneXML(this.h.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        SceneRemovingEvent sceneRemovingEvent = new SceneRemovingEvent(this, string);
        this.fireRemoving(sceneRemovingEvent);
        if (sceneRemovingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Remove(this.h.getHandle(), index);
        if (bl) {
            SceneRemovedEvent sceneRemovedEvent = new SceneRemovedEvent(this, string);
            this.fireRemoved(sceneRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SceneClearingEvent sceneClearingEvent = new SceneClearingEvent(this);
        this.fireClearing(sceneClearingEvent);
        if (sceneClearingEvent.getCancel()) {
            return;
        }
        int n = this.getCount();
        ScenesNative.jni_Clear(this.h.getHandle());
        SceneClearedEvent sceneClearedEvent = new SceneClearedEvent(this, n);
        this.fireCleared(sceneClearedEvent);
    }

    public int indexOf(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = ScenesNative.jni_IndexOf(this.h.getHandle(), name);
        }
        return n;
    }

    public String getAvailableSceneName(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return ScenesNative.jni_GetAvailableSceneName(this.h.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SceneRenamingEvent sceneRenamingEvent = new SceneRenamingEvent(this, oldName, newName);
        this.fireRenaming(sceneRenamingEvent);
        if (sceneRenamingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Rename(this.h.getHandle(), oldName, newName);
        if (bl) {
            SceneRenamedEvent sceneRenamedEvent = new SceneRenamedEvent(this, oldName, newName);
            this.fireRenamed(sceneRenamedEvent);
        }
        return bl;
    }

    public synchronized void addAddedListener(SceneAddedListener l) {
        if (this.a == null) {
            this.a = new CopyOnWriteArrayList();
        }
        if (!this.a.contains(l)) {
            this.a.add(l);
        }
    }

    public void removeAddedListener(SceneAddedListener l) {
        if (this.a != null && this.a.contains(l)) {
            this.a.remove(l);
        }
    }

    protected void fireAdded(SceneAddedEvent event) {
        if (this.a != null) {
            CopyOnWriteArrayList<SceneAddedListener> copyOnWriteArrayList = this.a;
            for (SceneAddedListener sceneAddedListener : copyOnWriteArrayList) {
                sceneAddedListener.sceneAdded(event);
            }
        }
    }

    public synchronized void addRemovingListener(SceneRemovingListener l) {
        if (this.b == null) {
            this.b = new CopyOnWriteArrayList();
        }
        if (!this.b.contains(l)) {
            this.b.add(l);
        }
    }

    public void removeRemovingListener(SceneRemovingListener l) {
        if (this.b != null && this.b.contains(l)) {
            this.b.remove(l);
        }
    }

    protected void fireRemoving(SceneRemovingEvent event) {
        if (this.b != null) {
            CopyOnWriteArrayList<SceneRemovingListener> copyOnWriteArrayList = this.b;
            for (SceneRemovingListener sceneRemovingListener : copyOnWriteArrayList) {
                sceneRemovingListener.sceneRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(SceneRemovedListener l) {
        if (this.c == null) {
            this.c = new CopyOnWriteArrayList();
        }
        if (!this.c.contains(l)) {
            this.c.add(l);
        }
    }

    public void removeRemovedListener(SceneRemovedListener l) {
        if (this.c != null && this.c.contains(l)) {
            this.c.remove(l);
        }
    }

    protected void fireRemoved(SceneRemovedEvent event) {
        if (this.c != null) {
            CopyOnWriteArrayList<SceneRemovedListener> copyOnWriteArrayList = this.c;
            for (SceneRemovedListener sceneRemovedListener : copyOnWriteArrayList) {
                sceneRemovedListener.sceneRemoved(event);
            }
        }
    }

    public synchronized void addClearingListener(SceneClearingListener l) {
        if (this.d == null) {
            this.d = new CopyOnWriteArrayList();
        }
        if (!this.d.contains(l)) {
            this.d.add(l);
        }
    }

    public void removeClearingListener(SceneClearingListener l) {
        if (this.d != null && this.d.contains(l)) {
            this.d.remove(l);
        }
    }

    protected void fireClearing(SceneClearingEvent event) {
        if (this.d != null) {
            CopyOnWriteArrayList<SceneClearingListener> copyOnWriteArrayList = this.d;
            for (SceneClearingListener sceneClearingListener : copyOnWriteArrayList) {
                sceneClearingListener.sceneClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(SceneClearedListener l) {
        if (this.e == null) {
            this.e = new CopyOnWriteArrayList();
        }
        if (!this.e.contains(l)) {
            this.e.add(l);
        }
    }

    public void removeClearedListener(SceneClearedListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireCleared(SceneClearedEvent event) {
        if (this.e != null) {
            CopyOnWriteArrayList<SceneClearedListener> copyOnWriteArrayList = this.e;
            for (SceneClearedListener sceneClearedListener : copyOnWriteArrayList) {
                sceneClearedListener.sceneCleared(event);
            }
        }
    }

    public synchronized void addRenamingListener(SceneRenamingListener l) {
        if (this.f == null) {
            this.f = new CopyOnWriteArrayList();
        }
        if (!this.f.contains(l)) {
            this.f.add(l);
        }
    }

    public void removeRenamingListener(SceneRenamingListener l) {
        if (this.f != null && this.f.contains(l)) {
            this.f.remove(l);
        }
    }

    protected void fireRenaming(SceneRenamingEvent event) {
        if (this.f != null) {
            CopyOnWriteArrayList<SceneRenamingListener> copyOnWriteArrayList = this.f;
            for (SceneRenamingListener sceneRenamingListener : copyOnWriteArrayList) {
                sceneRenamingListener.sceneRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(SceneRenamedListener l) {
        if (this.g == null) {
            this.g = new CopyOnWriteArrayList();
        }
        if (!this.g.contains(l)) {
            this.g.add(l);
        }
    }

    public void removeRenamedListener(SceneRenamedListener l) {
        if (this.g != null && this.g.contains(l)) {
            this.g.remove(l);
        }
    }

    protected void fireRenamed(SceneRenamedEvent event) {
        if (this.g != null) {
            CopyOnWriteArrayList<SceneRenamedListener> copyOnWriteArrayList = this.g;
            for (SceneRenamedListener sceneRenamedListener : copyOnWriteArrayList) {
                sceneRenamedListener.sceneRenamed(event);
            }
        }
    }

    protected void clearHandle() {
        this.h = null;
    }
}

