/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ProjectionNative;
import com.supermap.data.ProjectionType;
import java.io.File;

public class Projection
extends InternalHandleDisposable {
    public Projection() {
        long l = ProjectionNative.jni_New();
        this.setHandle(l, true);
    }

    public Projection(ProjectionType type) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        long l = ProjectionNative.jni_New2(n);
        this.setHandle(l, true);
    }

    public Projection(ProjectionType type, String name) {
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(type);
        long l = ProjectionNative.jni_New2(n);
        this.setHandle(l, true);
        this.setName(name);
    }

    public Projection(Projection projection) {
        if (projection == null || projection.getHandle() == 0L) {
            String string = InternalResource.loadString("projection", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ProjectionNative.jni_Clone(projection.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(projection);
    }

    Projection(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    public Projection clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new Projection(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ProjectionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ProjectionNative.jni_SetName(this.getHandle(), value);
    }

    public ProjectionType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = ProjectionNative.jni_GetType(this.getHandle());
        return (ProjectionType)Enum.parseUGCValue(ProjectionType.class, n);
    }

    public void setType(ProjectionType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setType(ProjectionType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = Enum.internalGetUGCValue(value);
        ProjectionNative.jni_SetType(this.getHandle(), n);
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = ProjectionNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionNative.jni_ToXML(this.getHandle());
    }

    public static String translateWKTFile2Proj(String filePath) {
        File file = new File(filePath);
        if (file == null) {
            String string = InternalResource.loadString("filePath", "GeoModel_TheFileIsNotExist", "data_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionNative.jni_TranslateWKTFile2Proj(filePath);
    }

    public static String translateWKT2Proj(String strWKT) {
        return ProjectionNative.jni_TranslateWKT2Proj(strWKT);
    }
}

