/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.Feature;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoPoint;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryNative;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariant;
import com.supermap.data.MemRecordsetNative;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysNative;
import com.supermap.data.Recordset;
import com.supermap.data.RecordsetNative;
import java.util.ArrayList;
import java.util.Map;

public class MemRecordset
extends Recordset {
    ArrayList<Geometry> a = new ArrayList();

    public MemRecordset(FieldInfos infos) {
        long l = MemRecordsetNative.jni_New(infos.getHandle());
        this.setHandle(l, true);
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = MemRecordsetNative.jni_GetPrjCoordSys(this.getHandle());
        if (l == 0L) {
            return null;
        }
        PrjCoordSys prjCoordSys = new PrjCoordSys();
        String string = PrjCoordSysNative.jni_ToXML(l, 0);
        PrjCoordSysNative.jni_FromXML(prjCoordSys.getHandle(), string, 0);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return prjCoordSys;
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MemRecordsetNative.jni_SetPrjCoordSys(this.getHandle(), value.getHandle());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean addNew(Geometry geometry) {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addNew(Geometry geometry) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("addNew(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        bl = MemRecordsetNative.jni_AddNew(this.getHandle(), geometry.getHandle());
        if (bl) {
            this.a.add(geometry);
            geometry.setIsDisposable(false);
        }
        return bl;
    }

    @Override
    public boolean addNew(Geometry geometry, Map<String, Object> map) {
        int n;
        if (map == null) {
            return this.addNew(geometry);
        }
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        long l = geometry2.getHandle();
        if (geometry2 == null || l == 0L) {
            String string = InternalResource.loadString("addNew(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry2.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Object[] objectArray = map.keySet().toArray();
        int n2 = objectArray.length;
        String[] stringArray = new String[n2];
        long[] lArray = new long[n2];
        InternalVariant[] internalVariantArray = new InternalVariant[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        n = MemRecordsetNative.jni_AddNew(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
        if (n != 0) {
            this.a.add(geometry);
            geometry.setIsDisposable(false);
        }
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        MemRecordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    @Override
    public Geometry getGeometry() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = MemRecordsetNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            String string = InternalResource.loadString("getGeometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeometryNative.jni_GetType(l);
        GeometryType geometryType = (GeometryType)Enum.parseUGCValue(GeometryType.class, n);
        GeoPoint geoPoint = null;
        if (geometryType.equals(GeometryType.GEOPOINT)) {
            geoPoint = new GeoPoint(l);
        }
        if (null != geoPoint) {
            geoPoint.setIsDisposable(true);
        }
        return geoPoint;
    }

    public boolean addFeature(Feature feature) {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addFeature(Feature feature) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (feature.getHandle() == 0L) {
            String string = InternalResource.loadString("addFeature(Feature feature)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        bl = MemRecordsetNative.jni_AddFeature(this.getHandle(), feature.getHandle());
        if (RecordsetNative.jni_GetRecordCount(this.getHandle()) == 1) {
            this.getFieldInfos();
        }
        return bl;
    }

    @Override
    public Feature getFeature() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = MemRecordsetNative.jni_GetFeature(this.getHandle());
        Feature feature = new Feature(l);
        if (null != feature) {
            feature.setIsDisposable(true);
        }
        return feature;
    }

    @Override
    public FieldInfos getFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldInfos", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.m_fieldInfos = new FieldInfos(RecordsetNative.jni_GetFieldInfos(this.getHandle()));
        this.m_fieldCount = this.m_fieldInfos.getCount();
        return this.m_fieldInfos;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MemRecordsetNative.jni_Dispose(this.getHandle());
            this.clearHandle();
            for (Geometry geometry : this.a) {
                geometry.setIsDisposable(true);
                geometry.clearHandle();
            }
            this.a.clear();
        }
    }

    @Override
    public void close() {
    }
}

