/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FeatureNative;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SerializeConverterType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Feature
extends InternalHandleDisposable {
    private int a = 0;
    private ArrayList<FieldType> b = null;
    private boolean[] c = new boolean[]{false};

    public Feature() {
        long l = FeatureNative.jni_New();
        this.setHandle(l, true);
        this.b = new ArrayList();
    }

    public Feature(long handle) {
        this.setHandle(handle, true);
        this.a = FeatureNative.jni_GetFieldCount(this.getHandle());
        this.b = new ArrayList();
        for (int i = 0; i < this.a; ++i) {
            int n = FeatureNative.jni_GetFieldType(this.getHandle(), i);
            FieldType fieldType = (FieldType)Enum.parseUGCValue(FieldType.class, n);
            this.b.add(fieldType);
        }
    }

    public Feature(FieldInfos fieldinfos) {
        long l = FeatureNative.jni_FieldsNew(fieldinfos.getHandle());
        this.setHandle(l, true);
        this.a = fieldinfos.getCount();
        this.b = new ArrayList();
        for (int i = 0; i < fieldinfos.getCount(); ++i) {
            this.b.add(fieldinfos.get(i).getType());
        }
    }

    public Feature(Feature ft) {
        if (ft.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = FeatureNative.jni_Clone(ft.getHandle());
        this.setHandle(l, true);
        this.a = FeatureNative.jni_GetFieldCount(this.getHandle());
        this.b = new ArrayList();
        this.b.addAll(ft.b);
        InternalHandleDisposable.makeSureNativeObjectLive(ft);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FeatureNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    private void a(int n) {
        if (n < 0 || n >= this.a) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean getBoolean(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = FeatureNative.jni_GetValueBoolByIndex(this.getHandle(), Index, this.c);
        return bl;
    }

    public byte[] getLongBinary(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = FeatureNative.jni_GetValueLongBinaryByIndex(this.getHandle(), Index);
        return byArray;
    }

    public byte getByte(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        byte by = FeatureNative.jni_GetValueByteByIndex(this.getHandle(), Index, this.c);
        return by;
    }

    public int getInt32(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetValueIntByIndex(this.getHandle(), Index, this.c);
        return n;
    }

    public float getFloat(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        float f2 = FeatureNative.jni_GetValueFloatByIndex(this.getHandle(), Index, this.c);
        return f2;
    }

    public double getDouble(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = FeatureNative.jni_GetValueDoubleByIndex(this.getHandle(), Index, this.c);
        return d2;
    }

    public short getInt16(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        short s = FeatureNative.jni_GetValueShortByIndex(this.getHandle(), Index, this.c);
        return s;
    }

    public String getString(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = FeatureNative.jni_GetValueStringByIndex(this.getHandle(), Index, this.c);
        return string;
    }

    public long getInt64(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = FeatureNative.jni_GetValueLongByIndex(this.getHandle(), Index, this.c);
        return l;
    }

    public Date getDateTime(int Index) {
        this.a(Index);
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = FeatureNative.jni_GetValueDateByIndex(this.getHandle(), Index, this.c);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.equals("aix")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                try {
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                    date = simpleDateFormat2.parse(string);
                }
                catch (ParseException parseException2) {}
            }
        } else {
            try {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                ((SimpleDateFormat)dateFormat).applyPattern("yyyy-MM-dd HH:mm:ss");
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                try {
                    date = DateFormat.getDateInstance().parse(string);
                }
                catch (ParseException parseException3) {
                    // empty catch block
                }
            }
        }
        return date;
    }

    public int getID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetID(this.getHandle());
        return n;
    }

    public Geometry getGeometry() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = FeatureNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance(l);
        return geometry;
    }

    public String FeatureSerialize(SerializeConverterType type) {
        String string = "";
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (type.equals(SerializeConverterType.SerializeGeojson)) {
            string = FeatureNative.jni_FeatureSerialize(this.getHandle());
            return string;
        }
        return string;
    }

    public boolean FeatureDeSerialize(String Serial, SerializeConverterType type) {
        long l = 0L;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (type.equals(SerializeConverterType.SerializeGeojson)) {
            l = FeatureNative.jni_FeatureDeSerialize(Serial, this.getHandle());
        }
        if (l == 0L) {
            return false;
        }
        this.a = FeatureNative.jni_GetFieldCount(l);
        this.b = new ArrayList();
        for (int i = 0; i < this.a; ++i) {
            int n = FeatureNative.jni_GetFieldType(l, i);
            FieldType fieldType = (FieldType)Enum.parseUGCValue(FieldType.class, n);
            this.b.add(fieldType);
        }
        return true;
    }

    public boolean hasTheSameFields(Feature obj) {
        if (obj == null) {
            return false;
        }
        if (0L == obj.getHandle()) {
            return false;
        }
        return FeatureNative.jni_IsLike(obj.getHandle());
    }

    public boolean getBoolean(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getBoolean(n);
    }

    public byte[] getLongBinary(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getLongBinary(n);
    }

    public byte getByte(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getByte(n);
    }

    public int getInt32(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getInt32(n);
    }

    public float getFloat(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getFloat(n);
    }

    public double getDouble(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getDouble(n);
    }

    public short getInt16(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getInt16(n);
    }

    public String getString(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getString(n);
    }

    public long getInt64(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getInt64(n);
    }

    public Date getDateTime(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getDateTime(n);
    }

    public Object getValue(int index) {
        this.a(index);
        FieldType fieldType = this.b.get(index);
        if (fieldType.equals(FieldType.INT32)) {
            Integer n = this.getInt32(index);
            if (this.c[0]) {
                return null;
            }
            return n;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l = this.getInt64(index);
            if (this.c[0]) {
                return null;
            }
            return l;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16(index);
            if (this.c[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(index);
            if (this.c[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getByte(index);
            if (this.c[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(index);
            if (this.c[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(index);
            if (this.c[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d2 = this.getDouble(index);
            if (this.c[0]) {
                return null;
            }
            return d2;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(index);
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f2 = Float.valueOf(this.getFloat(index));
            if (this.c[0]) {
                return null;
            }
            return f2;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString(index);
            if (this.c[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public Object getValue(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("feature", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = FeatureNative.jni_GetIndex(this.getHandle(), name);
        return this.getValue(n);
    }

    public boolean wasNull() {
        return this.c[0];
    }
}

