/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetIDType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Domain;
import com.supermap.data.DomainManagerNative;
import com.supermap.data.DomainNative;
import com.supermap.data.DomainType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Recordset;
import java.util.ArrayList;

public class DomainManager
extends InternalHandle {
    private Datasource a;
    private ArrayList<Domain> b;

    protected DomainManager(long handle, Datasource datasource) {
        this.setHandle(handle);
        this.a = datasource;
        this.b = new ArrayList();
        long[] lArray = DomainManagerNative.jni_GetAllDomain(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            int n = DomainNative.jni_GetType(lArray[i]);
            DomainType domainType = (DomainType)Enum.parseUGCValue(DomainType.class, n);
            Domain domain = Domain.CreateInstance(lArray[i], domainType);
            if (null == domain) continue;
            this.b.add(domain);
        }
    }

    public Domain getDomain(DatasetVector dataset, String fieldname) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldname.isEmpty()) {
            String string = InternalResource.loadString(fieldname, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == dataset) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DomainManagerNative.jni_GetDomain(this.getHandle(), dataset.getHandle(), fieldname);
        if (l == 0L) {
            return null;
        }
        int n = DomainNative.jni_GetType(l);
        DomainType domainType = (DomainType)Enum.parseUGCValue(DomainType.class, n);
        Domain domain = Domain.CreateInstance(l, domainType);
        return domain;
    }

    public boolean setDomain(DatasetVector dataset, String fieldname, Domain domain) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fieldname.isEmpty()) {
            String string = InternalResource.loadString(fieldname, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == dataset) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (domain != null) {
            l = domain.getHandle();
        }
        return DomainManagerNative.jni_SetDomain(this.getHandle(), dataset.getHandle(), fieldname, l);
    }

    public boolean isFieldDomainValid(DatasetVector dataset, String fieldname) {
        if (fieldname.isEmpty()) {
            String string = InternalResource.loadString(fieldname, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == dataset) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Domain domain = this.getDomain(dataset, fieldname);
        if (domain != null) {
            return DomainManagerNative.jni_CheckFieldIsValid(this.getHandle(), domain.getHandle(), dataset.getHandle(), fieldname);
        }
        return true;
    }

    public ArrayList<Integer> checkFieldValues(DatasetVector dataset, String fieldName) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Domain domain = this.getDomain(dataset, fieldName);
        if (domain != null) {
            Recordset recordset = dataset.getRecordset(false, CursorType.STATIC);
            recordset.moveFirst();
            FieldInfos fieldInfos = dataset.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.get(fieldName);
            while (!recordset.isEOF()) {
                Object object = recordset.getFieldValue(fieldName);
                if (!domain.check(object)) {
                    arrayList.add(recordset.getID());
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        return arrayList;
    }

    public ArrayList<Object> checkFieldValuesForObj(DatasetVector dataset, String fieldName) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Domain domain = this.getDomain(dataset, fieldName);
        if (domain != null) {
            Recordset recordset = dataset.getRecordset(false, CursorType.STATIC);
            recordset.moveFirst();
            FieldInfos fieldInfos = dataset.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.get(fieldName);
            while (!recordset.isEOF()) {
                Object object = recordset.getFieldValue(fieldName);
                if (!domain.check(object)) {
                    if (recordset.getDataset().getDatasetIDType().equals(DatasetIDType.INT64)) {
                        arrayList.add(recordset.getVariantID());
                    } else {
                        arrayList.add(recordset.getID());
                    }
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        return arrayList;
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this.a = null;
        if (null != this.b) {
            int n = this.b.size();
            for (int i = 0; i < n; ++i) {
                this.b.get(i).clearHandle();
            }
            this.b.clear();
            this.b = null;
        }
    }
}

