/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingJP2Native;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;
import com.supermap.data.conversion.a;

public class ImportSettingJP2
extends ImportSetting {
    public ImportSettingJP2() {
        long l = ImportSettingJP2Native.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingJP2(ImportSettingJP2 importSettingJP2) {
        if (importSettingJP2 == null) {
            String string = InternalResource.loadString("importSettingJP2", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingJP2);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingJP2", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingJP2Native.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingJP2.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingJP2.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingJP2.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.b);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingJP2));
    }

    public ImportSettingJP2(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingJP2(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingJP2Native.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingJP2Native.jni_SetImportingAsGrid(this.getHandle(), value);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingJP2Native.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJP2Native.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJP2Native.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingJP2Native.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingJP2Native.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingJP2Native.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingJP2Native.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

