/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.DatasetType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoCADNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalFieldInfos;
import com.supermap.data.conversion.InternalResource;

public class ImportDataInfoDWG
extends ImportDataInfo {
    private String i = "Layer";
    private String j = "Elevation";

    ImportDataInfoDWG(long handle, String filePath, FileType fileType, String targetName) {
        super(handle, filePath, fileType, targetName);
    }

    public DatasetType getDatasetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ImportDataInfoCADNative.jni_GetDatasetType(this.getHandle());
        DatasetType datasetType = (DatasetType)InternalEnum.parse(DatasetType.class, (int)n);
        return datasetType;
    }

    public int getRecordCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordCount()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportDataInfoCADNative.jni_GetRecordCount(this.getHandle());
    }

    public String getLayerNameField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayerNameField()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.i;
    }

    public void setLayerNameField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLayerNameFiled(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "conversion_resources");
        }
        this.changeFieldName("Layer", value);
        this.i = value;
    }

    @Deprecated
    public void setLayerNameFiled(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLayerNameFiled(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "conversion_resources");
        }
        this.changeFieldName("Layer", value);
        this.i = value;
    }

    public String getElevationNameField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getElevationNameField()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.j;
    }

    public void setElevationNameField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getElevationNameField()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "conversion_resources");
        }
        this.changeFieldName("Elevation", value);
        this.j = value;
    }

    public FieldInfo[] getSourceFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a();
    }

    public FieldInfo[] getTargetFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.b();
    }

    public void setTargetFieldInfos(FieldInfo[] fieldinfo) {
        FieldInfos fieldInfos = new FieldInfos(fieldinfo);
        if (ImportDataInfoDWG.getHandle((InternalHandle)fieldInfos) == 0L) {
            String string = InternalResource.loadString("fieldInfos", "Global_InvalidConstructorArgument", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalFieldInfos.getHandle(fieldInfos);
        ImportDataInfoCADNative.jni_SetTargetFieldInfos(this.getHandle(), l);
        this.Init();
    }

    public boolean changeFieldName(String oldName, String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ChangeFieldName(String oldName, String newName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a(oldName, newName);
    }

    public boolean setImportFieldState(String fieldName, boolean excludeField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportFieldState(String fieldname,Boolean excludeField)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a(fieldName, excludeField);
    }

    public boolean exchangeFieldOrder(String fieldName1, String fieldName2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("exchangeFieldOrder(String fieldName1, String fieldName2)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.b(fieldName1, fieldName2);
    }

    public boolean getImportFieldState(String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportFieldState(String fieldname)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.a(fieldName);
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

