/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.SolarRadiationNative;
import com.supermap.analyst.spatialanalyst.SolarRadiationParameter;
import com.supermap.analyst.spatialanalyst.SolarRadiationResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class SolarRadiation {
    private static License a;
    private static transient Vector b;

    private SolarRadiation() {
    }

    public static SolarRadiationResult areaSolarRadiation(DatasetGrid sourceDatasetGrid, SolarRadiationParameter parameter, Datasource targetDatasource, String totalGridName, String directGridName, String diffuseGridName, String durationGridName) {
        return SolarRadiation.areaSolarRadiation(sourceDatasetGrid, parameter, targetDatasource, totalGridName, directGridName, diffuseGridName, durationGridName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolarRadiationResult areaSolarRadiation(DatasetGrid sourceDatasetGrid, SolarRadiationParameter parameter, Datasource targetDatasource, String totalGridName, String directGridName, String diffuseGridName, String durationGridName, SteppedListener ... listeners) {
        try {
            DatasetGrid datasetGrid;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDatasetGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (parameter == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (totalGridName == null) {
                String string = InternalResourceSpatialanalyst.loadString("totalGridName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(totalGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("totalGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (directGridName != null && !directGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(directGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("directGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (diffuseGridName != null && !diffuseGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(diffuseGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("diffuseGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (durationGridName != null && !durationGridName.isEmpty() && !targetDatasource.getDatasets().isAvailableDatasetName(durationGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("durationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (parameter.getHourStart() > parameter.getHourEnd()) {
                String string = InternalResourceSpatialanalyst.loadString("parameter", "StartHourCannotGreaterThanEndHour", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetGrid);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long[] lArray = SolarRadiationNative.jni_AreaSolarRadiation(l2, l, l3, totalGridName, directGridName, diffuseGridName, durationGridName);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
            Object object = null;
            if (lArray != null && lArray.length == 4 && lArray[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                DatasetGrid datasetGrid2 = null;
                if (lArray[1] != 0L) {
                    datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
                }
                DatasetGrid datasetGrid3 = null;
                if (lArray[2] != 0L) {
                    datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
                }
                DatasetGrid datasetGrid4 = null;
                if (lArray[3] != 0L) {
                    datasetGrid4 = InternalDatasetGrid.createInstance(lArray[3], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid4);
                }
                object = new SolarRadiationResult(datasetGrid, datasetGrid2, datasetGrid3, datasetGrid4);
            }
            datasetGrid = object;
            return datasetGrid;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "SolarRadiation";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

