/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.ReconcileInfo;
import com.supermap.data.ReconcileResult;
import com.supermap.data.ToolkitNative;
import com.supermap.data.VersionAccessType;
import com.supermap.data.VersionChanges;
import com.supermap.data.VersionManager;
import com.supermap.data.VersionNative;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;

public class Version
extends InternalHandleDisposable {
    protected VersionManager m_versionManager = null;

    protected Version(long handle, VersionManager versionManager) {
        this.setHandle(handle, true);
        this.m_versionManager = versionManager;
    }

    public String getName() {
        this.a();
        String string = VersionNative.jni_GetName(this.getHandle());
        return string;
    }

    public int getID() {
        this.a();
        return VersionNative.jni_GetID(this.getHandle());
    }

    public String getDescription() {
        this.a();
        String string = VersionNative.jni_GetDescription(this.getHandle());
        return string;
    }

    public VersionAccessType getAccessType() {
        this.a();
        int n = VersionNative.jni_GetAccessType(this.getHandle());
        return (VersionAccessType)Enum.parseUGCValue(VersionAccessType.class, n);
    }

    public Date getCreatedTime() {
        this.a();
        String string = VersionNative.jni_GetCreatedTime(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public Date getModifiedTime() {
        this.a();
        String string = VersionNative.jni_GetModifiedTime(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public boolean alterName(String strNewName) {
        this.a();
        this.a(strNewName);
        boolean bl = VersionNative.jni_AlterName(this.getHandle(), strNewName);
        return bl;
    }

    public boolean alterAccessType(VersionAccessType nType) {
        this.a();
        return VersionNative.jni_AlterAccessType(this.getHandle(), nType.getUGCValue());
    }

    public boolean alterDescription(String strDescription) {
        this.a();
        if (strDescription == null) {
            strDescription = "";
        }
        return VersionNative.jni_AlterDescription(this.getHandle(), strDescription);
    }

    public boolean delete() {
        this.a();
        return VersionNative.jni_DeleteVersion(this.getHandle());
    }

    public boolean hasConflicts() {
        return false;
    }

    public ReconcileResult reconcile(ReconcileInfo reconcileInfo) {
        this.a();
        long l = VersionNative.jni_Reconcile(this.getHandle());
        if (l > 0L) {
            return new ReconcileResult(l, this);
        }
        return null;
    }

    public boolean post() {
        this.a();
        return VersionNative.jni_Post(this.getHandle());
    }

    public VersionChanges getVersionChanges() {
        this.a();
        long l = VersionNative.jni_GetVersionChanges(this.getHandle());
        if (l > 0L) {
            return new VersionChanges(l, this);
        }
        return null;
    }

    public Datasource getVersionDataSource() {
        this.a();
        long l = VersionNative.jni_GetVersionDataSource(this.getHandle());
        Datasource datasource = null;
        if (l > 0L) {
            datasource = new Datasource();
            datasource.m_datasets = new Datasets(datasource);
            datasource.setHandle(l);
        }
        return datasource;
    }

    public Duration getServerDifferenceTime() {
        this.a();
        int n = VersionNative.jni_GetServerDifferenceTime(this.getHandle());
        Duration duration = Duration.ofSeconds(n);
        return duration;
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            VersionNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    private void a(String string) {
        int n = ToolkitNative.jni_IsValidDatasetName(string);
        if (n == -1) {
            return;
        }
        InternalInvalidState internalInvalidState = (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
        if (internalInvalidState != null) {
            String string2 = "version name is " + internalInvalidState.name() + ", valid name = " + string;
            throw new IllegalArgumentException(string2);
        }
    }
}

