/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.StringAlignment;
import com.supermap.data.TextAlignment;
import com.supermap.data.TextStyleNative;
import java.awt.Color;

public class TextStyle
extends InternalHandleDisposable {
    public TextStyle() {
        long l = TextStyleNative.jni_New();
        this.setHandle(l, true);
        this.a();
    }

    public TextStyle(TextStyle textStyle) {
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TextStyleNative.jni_Clone(textStyle.getHandle());
        this.setHandle(l, true);
        textStyle.makeSureNativeObjectLive();
    }

    TextStyle(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.dispose(TextStyleNative::jni_Delete);
    }

    public TextAlignment getAlignment() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAlignment()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TextStyleNative.jni_GetTextAlignment(this.getHandle());
        return (TextAlignment)Enum.parseUGCValue(TextAlignment.class, n);
    }

    public void setAlignment(TextAlignment textAlignment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAlignment(TextAlignment value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textAlignment == null) {
            String string = InternalResource.loadString("textAlignment", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = textAlignment.getUGCValue();
        TextStyleNative.jni_SetTextAlignment(this.getHandle(), n);
    }

    public StringAlignment getStringAlignment() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStringAlignment()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TextStyleNative.jni_GetStringAlignment(this.getHandle());
        return (StringAlignment)Enum.parseUGCValue(StringAlignment.class, n);
    }

    public void setStringAlignment(StringAlignment stringAlignment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStringAlignment(StringAlignment value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (stringAlignment == null) {
            String string = InternalResource.loadString("stringAlignment", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = stringAlignment.getUGCValue();
        TextStyleNative.jni_SetStringAlignment(this.getHandle(), n);
    }

    public Color getBackColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TextStyleNative.jni_GetBackColor(this.getHandle());
        return new Color(n, true);
    }

    public void setBackColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBackColor(this.getHandle(), value.getRGB());
    }

    public boolean getBold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBold()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBold(this.getHandle());
    }

    public void setBold(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBold(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBold(this.getHandle(), value);
    }

    public Color getForeColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getForeColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TextStyleNative.jni_GetForeColor(this.getHandle());
        return new Color(n, true);
    }

    public void setForeColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setForeColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetForeColor(this.getHandle(), value.getRGB());
    }

    public boolean isSizeFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSizeFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetIsSizeFixed(this.getHandle());
    }

    public void setSizeFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSizeFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetSizeFixed(this.getHandle(), value);
    }

    public double getFontHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontHeight(this.getHandle());
    }

    public void setFontHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "TextStyle_TheValueOfFontHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyleNative.jni_SetFontHeight(this.getHandle(), value);
    }

    public double getFontWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontWidth(this.getHandle());
    }

    public void setFontWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TextStyle_TheValueOfFontWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyleNative.jni_SetFontWidth(this.getHandle(), value);
    }

    public String getFontName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontName(this.getHandle());
    }

    public void setFontName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        TextStyleNative.jni_SetFontName(this.getHandle(), value);
    }

    public boolean getItalic() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItalic()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetItalic(this.getHandle());
    }

    public void setItalic(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItalic(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetItalic(this.getHandle(), value);
    }

    public double getItalicAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItalicAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetItalicAngle(this.getHandle());
    }

    public void setItalicAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItalicAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetItalicAngle(this.getHandle(), value);
    }

    public boolean getOutline() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutline()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetOutline(this.getHandle());
    }

    public void setOutline(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutline(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetOutline(this.getHandle(), value);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetRotation(this.getHandle(), value);
    }

    public boolean getShadow() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadow()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetShadow(this.getHandle());
    }

    public void setShadow(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadow(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetShadow(this.getHandle(), value);
    }

    public boolean getStrikeout() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStrikeout()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetStrikeout(this.getHandle());
    }

    public void setStrikeout(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStrikeout(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetStrikeout(this.getHandle(), value);
    }

    public boolean getBackOpaque() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackOpaque()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBackOpaque(this.getHandle());
    }

    public void setBackOpaque(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackOpaque(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBackOpaque(this.getHandle(), value);
    }

    public boolean getUnderline() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUnderline()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetUnderLine(this.getHandle());
    }

    public void setUnderline(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUnderline(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetUnderLine(this.getHandle(), value);
    }

    public int getWeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetWeight(this.getHandle());
    }

    public void setWeight(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWeight(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_setWeight(this.getHandle(), value);
    }

    public double getFontScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFontScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontScale(this.getHandle());
    }

    public void setFontScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFontScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetFontScale(this.getHandle(), value);
    }

    public int getOpaqueRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpaqueRate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetOpaqueRate(this.getHandle());
    }

    public void setOpaqueRate(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpaqueRate()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 100) {
            String string = InternalResource.loadString("value", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetOpaqueRate(this.getHandle(), value);
    }

    public int getOutlineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHaloWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetHaloWidth(this.getHandle());
    }

    public void setOutlineWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHaloWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0 || value > 5) {
            String string = InternalResource.loadString("value", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetHaloWidth(this.getHandle(), value);
    }

    public int getBorderSpacingWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBorderSpacingWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBorderSpacingWidth(this.getHandle());
    }

    public void setBorderSpacingWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderSpacingWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBorderSpacingWidth(this.getHandle(), value);
    }

    public double getShadowOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadowOffsetX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetShadowOffsetX(this.getHandle());
    }

    public void setShadowOffsetX(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowOffsetX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetShadowOffsetX(this.getHandle(), value);
    }

    public double getShadowOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadowOffsetY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetShadowOffsetY(this.getHandle());
    }

    public void setShadowOffsetY(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowOffsetY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetShadowOffsetY(this.getHandle(), value);
    }

    public Color getShadowColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadowColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = TextStyleNative.jni_GetShadowColor(this.getHandle());
        return new Color(n, true);
    }

    public void setShadowColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetShadowColor(this.getHandle(), value.getRGB());
    }

    public TextStyle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TextStyle(this);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = TextStyleNative.jni_ToXML(this.getHandle());
        return string;
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (xml != null && xml.trim().length() != 0) {
            bl = TextStyleNative.jni_FromXML(this.getHandle(), xml);
        }
        return bl;
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Alignment = ");
        stringBuffer.append(this.getAlignment().name());
        stringBuffer.append(",BackColor = ");
        stringBuffer.append(this.getBackColor().toString());
        stringBuffer.append(",BackOpaque = ");
        stringBuffer.append(this.getBackOpaque());
        stringBuffer.append(",Bold = ");
        stringBuffer.append(this.getBold());
        stringBuffer.append(",FontName = ");
        stringBuffer.append(this.getFontName());
        stringBuffer.append(",FontHeight = ");
        stringBuffer.append(this.getFontHeight());
        stringBuffer.append(",FontWidth = ");
        stringBuffer.append(this.getFontWidth());
        stringBuffer.append(",FontColor = ");
        stringBuffer.append(this.getForeColor().toString());
        stringBuffer.append(",IsSizeFixed = ");
        stringBuffer.append(this.isSizeFixed());
        stringBuffer.append(",Italic = ");
        stringBuffer.append(this.getItalic());
        stringBuffer.append(",Outline = ");
        stringBuffer.append(this.getOutline());
        stringBuffer.append(",Rotation = ");
        stringBuffer.append(this.getRotation());
        stringBuffer.append(",Shadow = ");
        stringBuffer.append(this.getShadow());
        stringBuffer.append(",Strikeout = ");
        stringBuffer.append(this.getStrikeout());
        stringBuffer.append(",Underline = ");
        stringBuffer.append(this.getUnderline());
        stringBuffer.append(",Weight = ");
        stringBuffer.append(this.getWeight());
        stringBuffer.append(",OutlineWidth = ");
        stringBuffer.append(this.getOutlineWidth());
        stringBuffer.append(",BorderSpacingWidth = ");
        stringBuffer.append(this.getBorderSpacingWidth());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected static TextStyle createInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new TextStyle(handle);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void changeHandle(TextStyle style, long handle) {
        style.a(handle);
    }

    protected static void clearHandle(TextStyle style) {
        style.clearHandle();
    }

    private void a(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            TextStyleNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }

    protected static void refreshHandle(TextStyle style, long handle) {
        style.b(handle);
    }

    private void b(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    void a() {
        TextStyleNative.jni_Reset(this.getHandle());
    }
}

