/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineBase;
import com.supermap.data.SymbolLineLibraryNative;
import com.supermap.data.SymbolMarkerLibrary;
import java.io.File;

public class SymbolLineLibrary
extends SymbolLibrary {
    SymbolLineLibrary(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolLineLibraryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public SymbolMarkerLibrary getInlineMarkerLib() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("inlineMarkerLib()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = SymbolLineLibraryNative.jni_GetInlineMarkerLib(this.getHandle());
        if (l == 0L) {
            return null;
        }
        SymbolMarkerLibrary symbolMarkerLibrary = new SymbolMarkerLibrary(l);
        return symbolMarkerLibrary;
    }

    public boolean toFile(String filePath, int[] extractedIDs) {
        String[] stringArray;
        long l = SymbolLineLibraryNative.jni_New();
        SymbolLineLibrary symbolLineLibrary = new SymbolLineLibrary(l);
        symbolLineLibrary.clear();
        symbolLineLibrary.setHandle(l, true);
        SymbolMarkerLibrary symbolMarkerLibrary = this.getInlineMarkerLib();
        SymbolMarkerLibrary symbolMarkerLibrary2 = symbolLineLibrary.getInlineMarkerLib();
        symbolMarkerLibrary2.clear();
        for (int i = 0; i < extractedIDs.length; ++i) {
            stringArray = (String[])this.findSymbol(extractedIDs[i]);
            if (stringArray == null) continue;
            SymbolLine symbolLine = (SymbolLine)Symbol.a((Symbol)stringArray);
            symbolLineLibrary.add(symbolLine);
            int n = stringArray.getCount();
            for (int j = 0; j < n; ++j) {
                Symbol symbol;
                SymbolLineBase symbolLineBase = stringArray.get(j);
                int n2 = symbolLineBase.getCode();
                Symbol symbol2 = symbolMarkerLibrary2.findSymbol(n2);
                if (symbol2 != null || (symbol = symbolMarkerLibrary.findSymbol(n2)) == null) continue;
                Symbol symbol3 = Symbol.a(symbol);
                symbolMarkerLibrary2.add(symbol3);
            }
        }
        symbolLineLibrary.toFile(filePath);
        String string = filePath.substring(0, filePath.lastIndexOf("."));
        stringArray = new String[]{string + ".lock", string + ".sc", string + ".sc00"};
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            file.delete();
        }
        return true;
    }
}

