/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill3DBase;
import com.supermap.data.SymbolFill3DNative;
import com.supermap.data.SymbolLibrary;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SymbolFill3D
extends Symbol {
    private ArrayList<SymbolFill3DBase> a;

    public SymbolFill3D() {
        this.setHandle(SymbolFill3DNative.jni_New(), true);
        this.a(null);
        this.a = new ArrayList();
    }

    SymbolFill3D(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
    }

    public ArrayList<SymbolFill3DBase> getSymbolFillBases() {
        return this.a;
    }

    public SymbolFill3D(SymbolFill3D symbolFill3D) {
        if (symbolFill3D.getHandle() == 0L) {
            String string = InternalResource.loadString("SymbolFill3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SymbolFill3DNative.jni_Clone(symbolFill3D.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(symbolFill3D);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolFill3DNative.jni_GetCount(this.getHandle());
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolFill3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            geometry.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
            SymbolLibrary symbolLibrary = this.getLibrary();
            long l2 = 0L;
            if (symbolLibrary != null) {
                l2 = symbolLibrary.getHandle();
            }
            if (bl = SymbolFill3DNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry.getHandle(), l2)) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
            }
            if (symbolLibrary != null) {
                symbolLibrary.makeSureNativeObjectLive();
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Override
    public boolean draw(Graphics graphics, Point2Ds points, GeoStyle style) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion geoRegion = new GeoRegion(points);
        Rectangle2D rectangle2D = geoRegion.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoRegion.offset(-rectangle2D.getLeft(), -rectangle2D.getBottom());
        Point2Ds point2Ds = geoRegion.getPart(0);
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        SymbolLibrary symbolLibrary = this.getLibrary();
        long l = 0L;
        if (symbolLibrary != null) {
            l = symbolLibrary.getHandle();
        }
        if (bl = style == null ? SymbolFill3DNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, 0L, l) : SymbolFill3DNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, style.getHandle(), l)) {
            graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft(), (int)rectangle2D.getBottom(), null);
        }
        if (symbolLibrary != null) {
            symbolLibrary.makeSureNativeObjectLive();
        }
        internalBufferImage.makeSureNativeObjectLive();
        if (style != null) {
            style.makeSureNativeObjectLive();
        }
        return bl;
    }

    @Override
    public boolean draw(BufferedImage image, Point2Ds points, GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(image.getGraphics(), points, style);
        InternalHandleDisposable.makeSureNativeObjectLive(style);
        return bl;
    }

    @Override
    public SymbolType getType() {
        return SymbolType.FILL3D;
    }

    public int add(SymbolFill3DBase fillBase) {
        if (fillBase == null) {
            return -1;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle(fillBase);
        SymbolFill3DNative.jni_Add(this.getHandle(), l);
        if (!this.a.contains(fillBase)) {
            this.a.add(fillBase);
        }
        return this.a.size() - 1;
    }

    public boolean remove(int index) {
        if (index < 0) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a != null && this.a.size() > 0 && this.a.size() > index) {
            this.a.remove(index);
        }
        return SymbolFill3DNative.jni_Remove(this.getHandle(), index);
    }

    public void setThumbnail(BufferedImage image) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThumnnail(image)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = image.getRGB(j, n2 - i - 1);
            }
        }
        SymbolFill3DNative.jni_SetImage(this.getHandle(), nArray, n, n2);
    }

    public BufferedImage getThumbnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThumnnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = SymbolFill3DNative.jni_GetImage(this.getHandle(), nArray);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage.setRGB(j, n2 - i - 1, nArray2[i * n + j]);
                }
            }
        }
        return bufferedImage;
    }
}

