/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Environment;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SpatialGridCodingNative;

public class SpatialGridCoding {
    private SpatialGridCoding() {
    }

    public static String geoSOTEncode(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(geometry instanceof Geometry3D) && geometry.getType() != GeometryType.GEOPOINT && geometry.getType() != GeometryType.GEOLINE && geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = SpatialGridCodingNative.jni_GeoSOTEncode(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String[] geoSOTEncode3D(Geometry3D geometry3D) {
        if (geometry3D == null || geometry3D.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = SpatialGridCodingNative.jni_GeoSOTEncode3D(geometry3D.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry3D);
        if (stringArray[0].isEmpty()) {
            stringArray[0] = null;
        }
        return stringArray;
    }

    public static String geoEntityEncode(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(geometry instanceof Geometry3D) && geometry.getType() != GeometryType.GEOPOINT && geometry.getType() != GeometryType.GEOLINE && geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = SpatialGridCodingNative.jni_GeoEntityEncode(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String geoEntityEncode3D(Geometry3D geometry3D) {
        if (geometry3D == null || geometry3D.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = SpatialGridCodingNative.jni_GeoEntityEncode3D(geometry3D.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry3D);
        if (string.isEmpty()) {
            string = null;
        }
        return string;
    }

    public static String beidouGridEncode(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(geometry instanceof Geometry3D) && geometry.getType() != GeometryType.GEOPOINT && geometry.getType() != GeometryType.GEOLINE && geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = SpatialGridCodingNative.jni_BeiDouGridEncode(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String beidouGridEncode3D(Geometry3D geometry3D) {
        if (geometry3D == null || geometry3D.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String string = SpatialGridCodingNative.jni_BeiDouGridEncode3D(geometry3D.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry3D);
        if (string.isEmpty()) {
            string = null;
        }
        return string;
    }

    static {
        Environment.LoadWrapJ();
    }
}

