/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasource;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ReplicaManager;
import com.supermap.data.ReplicaNative;
import com.supermap.data.ReplicaType;
import com.supermap.data.Version;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Replica
extends InternalHandleDisposable {
    protected ReplicaManager m_replicaManager = null;

    Replica(long handle, ReplicaManager replicaManager) {
        this.setHandle(handle, true);
        this.m_replicaManager = replicaManager;
    }

    public boolean synchronizeToDefault() {
        this.a();
        return ReplicaNative.jni_SynchronizeToDefault(this.getHandle());
    }

    public boolean synchronizeToDefault(Datasource childReplicaDatasource) {
        this.a();
        if (childReplicaDatasource.getHandle() == 0L) {
            return false;
        }
        return ReplicaNative.jni_SynchronizeToDefault2(this.getHandle(), childReplicaDatasource.getHandle());
    }

    public Version synchronizeToVersion() {
        this.a();
        long l = ReplicaNative.jni_SynchronizeToVersion(this.getHandle());
        Datasource datasource = this.m_replicaManager.getDatasource();
        if (l != 0L && datasource != null && datasource.getVersionManager() != null) {
            return new Version(l, datasource.getVersionManager());
        }
        return null;
    }

    public Version synchronizeToVersion(String versionName) {
        this.a();
        long l = ReplicaNative.jni_SynchronizeToVersion3(this.getHandle(), versionName);
        Datasource datasource = this.m_replicaManager.getDatasource();
        if (l != 0L && datasource != null && datasource.getVersionManager() != null) {
            return new Version(l, datasource.getVersionManager());
        }
        return null;
    }

    public Version synchronizeToVersion(Datasource childReplicaDatasource) {
        this.a();
        if (childReplicaDatasource.getHandle() == 0L) {
            return null;
        }
        long l = ReplicaNative.jni_SynchronizeToVersion2(this.getHandle(), childReplicaDatasource.getHandle());
        Datasource datasource = this.m_replicaManager.getDatasource();
        if (l != 0L && datasource != null && datasource.getVersionManager() != null) {
            return new Version(l, datasource.getVersionManager());
        }
        return null;
    }

    public Version synchronizeToVersion(Datasource childReplicaDatasource, String versionName) {
        this.a();
        if (childReplicaDatasource.getHandle() == 0L) {
            return null;
        }
        long l = ReplicaNative.jni_SynchronizeToVersion4(this.getHandle(), childReplicaDatasource.getHandle(), versionName);
        Datasource datasource = this.m_replicaManager.getDatasource();
        if (l != 0L && datasource != null && datasource.getVersionManager() != null) {
            return new Version(l, datasource.getVersionManager());
        }
        return null;
    }

    public Boolean delete() {
        this.a();
        return ReplicaNative.jni_DeleteReplica(this.getHandle());
    }

    public String getName() {
        this.a();
        return ReplicaNative.jni_GetName(this.getHandle());
    }

    public String getDescription() {
        this.a();
        return ReplicaNative.jni_GetDescription(this.getHandle());
    }

    public Date getCreateTime() {
        this.a();
        String string = ReplicaNative.jni_GetCreateTime(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public Date getModifyTime() {
        this.a();
        String string = ReplicaNative.jni_GetModifyTime(this.getHandle());
        if (string.isEmpty()) {
            return null;
        }
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public ReplicaType getReplicaType() {
        this.a();
        int n = ReplicaNative.jni_GetReplicaType(this.getHandle());
        return (ReplicaType)Enum.parseUGCValue(ReplicaType.class, n);
    }

    public String[] getDatasetVectorNames() {
        this.a();
        return ReplicaNative.jni_GetDatasetVectorNames(this.getHandle());
    }

    public EngineType getChildReplicaEngineType() {
        this.a();
        int n = ReplicaNative.jni_GetChildReplicaEngineType(this.getHandle());
        return (EngineType)Enum.parseUGCValue(EngineType.class, n);
    }

    public String getGolbalID() {
        this.a();
        return ReplicaNative.jni_GetGolbalID(this.getHandle());
    }

    public String getChildReplicaPath() {
        this.a();
        return ReplicaNative.jni_GetChildReplicaPath(this.getHandle());
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            ReplicaNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }
}

